<?php

/**
 * The template for displaying page title in page title section
 *
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (is_search()) :
	$energy_search_query = esc_html(get_search_query());
	if ((bool) trim($energy_search_query) === false) :
		echo esc_html__('Search', 'energy');
	else :
		echo esc_html__('Search Results for: ', 'energy');
		echo esc_html($energy_search_query);
	endif;

	return;
endif;

if (is_home()) :
	$energy_title = energy_option('blog_page_name', esc_html__('Blog', 'energy'));
	echo esc_html($energy_title);

	return;
endif;

if (is_404()) :
	$energy_title = esc_html__('404', 'energy');
	echo esc_html($energy_title);

	return;
endif;

if (function_exists('is_shop')) :
	if (is_shop()) :
		$energy_title = esc_html__('Shop', 'energy');
		echo esc_html($energy_title);

		return;
	endif;
endif;

if (is_singular()) :
	the_title();

	return;
endif;

if (is_archive()) :
	$energy_hide_tax_name_class = energy_option('title_hide_taxonomy_name', '') ? 'hide-tax-name' : 'tax-name';
	echo '<span class="' . esc_attr($energy_hide_tax_name_class) . '">';
	the_archive_title();
	echo '</span>';

	return;
endif;
