<?php

/**
 * The title section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_fluid             = energy_option('title_fluid') ? '-fluid' : '';
$energy_show_title       = energy_option('title_show_title', '');
$energy_show_breadcrumbs = energy_breadcrumbs_enabled();

$energy_title_background     = energy_option('title_background', '');
$energy_extra_padding_top    = energy_option('title_extra_padding_top', '');
$energy_extra_padding_bottom = energy_option('title_extra_padding_bottom', '');
$energy_border_top           = energy_option('title_border_top', '');
$energy_border_bottom        = energy_option('title_border_bottom', '');
$energy_font_size            = energy_option('title_font_size', '');
$energy_background_image     = energy_section_background_image_array('title');

?>
<section id="title" class="title title-1 <?php echo esc_attr($energy_title_background . ' ' . $energy_font_size . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $energy_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container<?php echo esc_attr($energy_fluid); ?> <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
		<?php
		if ('container' === $energy_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		if (!empty($energy_show_title)) {
		?>
			<h1 itemprop="headline"><?php get_template_part('template-parts/title/title-text'); ?></h1>
		<?php
		} //show_title
		if (!empty($energy_show_breadcrumbs)) {
			energy_breadcrumbs();
		}
		if ('container' === $energy_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</div><!-- .container -->
	<?php
	if ('full' === $energy_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
</section><!-- #title -->