<?php

/**
 * The template to display post author bio
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_author_id = get_the_author_meta('ID');

$energy_show_bio   = energy_option('blog_single_show_author_bio', true);
$energy_author_bio = get_the_author_meta('description', $energy_author_id);

if (empty($energy_show_bio) || empty($energy_author_bio)) {
	return;
}

//SEO additional fields
$energy_twitter_url 	  = get_the_author_meta('twitter', $energy_author_id);
$energy_facebook_url     = get_the_author_meta('facebook', $energy_author_id);
$energy_linkedin_url     = get_the_author_meta('linkedin', $energy_author_id);
$energy_instagram_url    = get_the_author_meta('instagram', $energy_author_id);
$energy_youtube_url      = get_the_author_meta('youtube', $energy_author_id);
$energy_custom_image_url = get_the_author_meta('custom_profile_image', $energy_author_id);
?>
<div class="author-meta content-padding with_shadow with-bottom-border">
	<div class="side-item has-post-thumbnail">
		<div class="item-media">
			<?php
			if (!empty($energy_custom_image_url)) {
				echo '<img src="' . esc_url($energy_custom_image_url) . '" alt="' . esc_attr(get_the_author_meta('display_name', $energy_author_id)) . '">';
			} else {
				echo get_avatar($energy_author_id, 700);
			}
			?>
		</div><!-- eof .item-media -->
		<div class="item-content">
			<?php
			$energy_about_word = energy_option('blog_single_author_bio_about_word');
			if (!empty($energy_about_word)) :
			?>
				<p class="about-author-heading">
					<?php echo esc_html($energy_about_word); ?>
				</p>
			<?php endif; ?>
			<h5 class="author-name mt-0">
				<?php
				the_author();
				//echo wp_kses_post( get_the_author_meta( 'display_name', $energy_author_id ) );
				?>
			</h5>
			<?php if (!empty($energy_author_bio)) : ?>
				<p class="author-bio">
					<?php echo wp_kses_post($energy_author_bio); ?>
				</p>
			<?php
			endif; //author_bio
			if ($energy_twitter_url || $energy_facebook_url || $energy_linkedin_url || $energy_instagram_url || $energy_youtube_url) :
			?>
				<span class="social-links author-social">
					<?php

					if ($energy_facebook_url) :
						energy_social_link_2('facebook', $energy_facebook_url, '');
					endif;
					if ($energy_twitter_url) :
						energy_social_link_2('twitter', $energy_twitter_url, '');
					endif;
					if ($energy_instagram_url) :
						energy_social_link_2('instagram', $energy_instagram_url, '');
					endif;
					if ($energy_linkedin_url) :
						energy_social_link_2('linkedin', $energy_linkedin_url, '');
					endif;
					if ($energy_youtube_url) :
						energy_social_link_2('youtube', $energy_youtube_url, '');
					endif;
					?>
				</span><!-- eof .author-social -->
			<?php endif; //author social 
			?>
		</div><!-- eof .item-content -->
	</div><!-- eof author-meta -->
</div>
<?php
