<?php

/**
 * The main template file
 * Also used in the Customizer preview
 * It contains the index.php file but without header and footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_show_title = energy_get_feed_shot_title();
$energy_layout     = energy_get_feed_layout();
$energy_layout_gap = energy_get_feed_gap();

//layout may contain columns count separated by space and 'masonry' word after columns count
$energy_layout         = explode(' ', $energy_layout);
$energy_columns_number = (!empty($energy_layout[1])) ? absint($energy_layout[1]) : '';
$energy_masonry        = (!empty($energy_layout[2]) && 'masonry' === $energy_layout[2]) ? true : false;
$energy_grid_class     = (!empty($energy_masonry)) ? 'masonry' : 'grid-wrapper';
$energy_layout         = $energy_layout[0];
$energy_columns        = (!empty($energy_columns_number)) ? true : false;

//additional css classes for #layout div element
$energy_layout_class  = 'layout-' . $energy_layout;
$energy_layout_class .= !empty($energy_columns) ? ' layout-cols-' . $energy_columns_number : ' layout-cols-1';
$energy_layout_class .= !empty($energy_layout_gap) ? ' layout-gap-' . $energy_layout_gap : ' layout-gap-default';

if (!empty($energy_masonry)) {
	energy_enqueue_masonry_action();
}

if (have_posts()) :
?>
	<div id="layout" class="<?php echo esc_attr($energy_layout_class); ?>">
		<?php if (!empty($energy_show_title)) : ?>
			<h1 class="archive-title">
				<span><?php get_template_part('template-parts/title/title-text'); ?></span>
			</h1>
		<?php
		endif; //show_title

		if (is_category()) :
			$energy_category_description = category_description();
			if (!empty($energy_category_description)) {
				echo '<div class="category-description">' . wp_kses_post($energy_category_description) . '</div><!-- .category-description -->';
			}
		endif; //is_category

		if (!empty($energy_columns)) :
			// read about masonry layout here:
			// https://masonry.desandro.com/options.html
			// https://github.com/desandro/masonry/issues/549
		?>
			<div class="grid-columns-wrapper">
				<div class="<?php echo esc_attr($energy_grid_class); ?>">
					<div class="grid-sizer"></div>
				<?php
			endif; //columns

			// Load posts loop.
			while (have_posts()) :

				the_post();
				get_template_part('template-parts/blog/' . $energy_layout . '/content', get_post_format());

			endwhile;

			if (!empty($energy_columns)) :
				?>
				</div><!-- .<?php echo esc_html($energy_grid_class); ?>-->
			</div><!-- .grid-columns-wrapper -->
		<?php
			endif; //columns 
		?>
		<?php
		// Previous/next page navigation.
		the_posts_pagination(
			energy_get_the_posts_pagination_atts()
		);
		?> <?php
			?>
	</div><!-- #layout -->
<?php
else :

	// If no content, include the "No posts found" template.
	get_template_part('template-parts/content', 'none');

endif; //have_posts
