<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//options
$energy_fluid             = energy_option('header_fluid') ? '-fluid' : '';
$energy_transparent       = energy_option('header_transparent') ? 'transparent' : '';
$energy_absolute          = energy_option('header_absolute') ? 'absolute' : '';
$energy_header_top_tall   = energy_option('header_top_tall') ? 'header-tall' : '';
$energy_sticky            = energy_option('header_sticky');
$energy_header_meta         = energy_option('header_meta') ? 'show-header-meta' : '';
$energy_header_background = energy_option('header_background', '');
$energy_header_toplogo_bg = energy_option('header_toplogo_background', 'l');
$energy_font_size         = energy_option('header_toplogo_font_size', '');

$energy_border_top    = energy_option('header_border_top', '');
$energy_border_bottom = energy_option('header_border_bottom', '');

//meta
$energy_meta                 = energy_get_theme_meta();
$header_meta                 = energy_option('header_meta');

$energy_toggler_side_in_header = energy_option('header_toggler_menu_side', true);
$energy_toggler_main_in_header = energy_option('header_toggler_menu_main', true);

$energy_header_align_main_menu = energy_option('header_align_main_menu', '');
$energy_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

$header_toplogo = energy_option('header_toplogo');

if (!empty($header_toplogo)) :
?>
    <div id="toplogo" class="toplogo toplogo-2 <?php echo esc_attr($energy_font_size . ' ' . $energy_header_toplogo_bg . ' ' . $energy_header_top_tall); ?>">
        <div class="container<?php echo esc_attr($energy_fluid); ?> container-flex">
            <div class="logo-wrap darklinks">
                <?php
                get_template_part('template-parts/header/logo/logo', energy_template_part('logo', '1'));
                ?>
            </div>
            <div class="toplogo_right_buttons greylinks hidden-xs">
                <div class="header-login">
                    <button class="hidden-xs" id="login_toggle" aria-controls="login_dropdown" aria-expanded="false" aria-label="<?php esc_attr_e('login', 'energy'); ?>">
                        <?php
                        energy_icon('log-in');
                        echo esc_html('Log In')
                        ?>
                    </button>
                </div><!-- .header-login -->
                <?php if (class_exists('YITH_WCWL')) : ?>
                    <a href="<?php echo esc_url(YITH_WCWL()->get_wishlist_url()); ?>">
                        <i class="yith-wcwl-icon fa fa-heart-o"></i>
                        <?php echo esc_html__('Wishlist', 'energy') ?>
                    </a>
                <?php endif; ?>
                <?php
                if (class_exists('WooCommerce')) :
                ?>
                    <div class="cart-wrap">
                        <span class="cart-header">
                            <?php echo esc_html('Cart /') ?>
                            <?php wc_cart_totals_subtotal_html(); ?>
                        </span>
                        <?php
                        get_template_part('template-parts/header/cart-dropdown');
                        ?>
                    </div>
                <?php
                endif; //woocommerce
                ?>
            </div>
        </div>
    </div><!-- eof .col- -->
<?php endif; ?>