<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//meta
$energy_meta                 = energy_get_theme_meta();

$energy_fluid                = energy_option('topline_fluid') ? '-fluid' : '';
$energy_topline_background   = energy_option('topline_background', '');
$energy_font_size            = energy_option('topline_font_size', '');

$energy_topline_link_1       = energy_option('topline_link_1');
$energy_topline_link_1_URL   = energy_option('topline_link_1_url');
$energy_topline_link_2       = energy_option('topline_link_2');
$energy_topline_link_2_URL   = energy_option('topline_link_2_url');

?>
<div id="topline" class="topline topline-2 <?php echo esc_attr($energy_topline_background . ' ' . $energy_font_size); ?>">
    <div class="container<?php echo esc_attr($energy_fluid); ?>">
        <?php if (
            !empty(energy_option('meta_facebook'))
            ||
            !empty(energy_option('meta_twitter'))
            ||
            !empty(energy_option('meta_instagram'))
            ||
            !empty(energy_option('meta_linkedin'))
            ||
            !empty(energy_option('meta_youtube'))
            ||
            !empty(energy_option('meta_pinterest'))
            ||
            !empty(energy_option('meta_github'))
        ) { ?>
            <div class="social-links-wrap greylinks color2">
                <span class="small-text"><?php echo esc_html('follow us:', 'energy'); ?></span>
                <?php energy_social_links('', 'divided-content'); ?>
            </div>
        <?php }; ?>
        <div class="inline-content greylinks color2 divided-content">
            <?php if (class_exists('WooCommerce')) : ?>
                <div class="small-text">
                    <?php if (!is_user_logged_in()) : ?>
                        <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>"><?php echo esc_html__('Login / Register', 'energy'); ?>
                        </a>
                    <?php else : ?>
                        <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>"><?php echo esc_html__('My account', 'energy'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div>
                    <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="cart-button">
                        <?php if (WC()->cart->get_cart_contents_count()) : ?>
                            <i class="fa fa-shopping-basket" aria-hidden="true"></i>
                        <?php
                            echo '<span class="total-price">' . WC()->cart->get_cart_subtotal() . '</span>';
                        else : ?>
                            <i class="fa fa-shopping-basket empty" aria-hidden="true"></i>
                        <?php endif; ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php
            get_template_part('template-parts/header/header-search');
            ?>
        </div>
    </div><!-- .container -->
</div><!-- #topline -->