<?php

/**
 * The logo template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$args = !empty($args) ? $args : array();
$div = !empty($args['div']) ? 'div' : 'a';

$energy_custom_logo         = energy_option('custom_logo');
$energy_logo_white          = energy_option('logo_image_inverse');
$energy_logo_image_class    = (!empty($energy_custom_logo) || !empty($energy_logo_white)) ? 'with-image' : 'no-image';
$energy_logo_text_primary   = energy_option('logo_primary_text');
$energy_logo_text_secondary = energy_option('logo_text_secondary');
$energy_logo_background     = energy_option('logo_background');
$energy_logo_x_padding      = energy_option('logo_padding_horizontal');
$energy_logo_padding_class  = (!empty($energy_logo_x_padding)) ? 'px' : '';

//if no text - get blog name for primary text
if (empty($energy_logo_text_primary) && empty($energy_logo_text_secondary) && empty($energy_custom_logo)) {
	$energy_logo_text_primary = get_bloginfo('name');
}
?>
<<?php echo esc_html($div); ?> class="logo logo-vertical <?php echo esc_attr($energy_logo_image_class . ' ' . $energy_logo_background . ' ' . $energy_logo_padding_class); ?>" href="<?php echo esc_url(home_url('/')); ?>" rel="home" itemprop="url">
	<?php
	//image
	if (energy_option('header_background') === 'l' || energy_option('header_background') === 'l m' || energy_option('header_background') === '') :
		echo wp_get_attachment_image($energy_custom_logo, 'full');
	else :
		if (!empty($energy_logo_white)) :
	?>
			<img src="<?php echo esc_url($energy_logo_white); ?>" alt="<?php esc_attr_e('white logo', 'energy'); ?>">
		<?php
		endif; //logo_white
	endif; //image
	//text
	if (!empty($energy_logo_text_primary) || !empty($energy_logo_text_secondary)) :
		?>
		<span class="logo-text">
			<?php if (!empty($energy_logo_text_primary)) : ?>
				<span class="logo-text-primary">
					<?php echo wp_kses_post($energy_logo_text_primary); ?>
				</span><!-- .logo-text-primary -->
			<?php endif; ?>
			<?php if (!empty($energy_logo_text_secondary)) : ?>
				<span class="logo-text-secondary">
					<?php echo wp_kses_post($energy_logo_text_secondary); ?>
				</span><!-- .logo-text-secondary -->
			<?php endif; ?>
		</span><!-- .logo-text -->
	<?php endif; ?>
</<?php echo esc_html($div); ?>><!-- .logo -->