<?php

/**
 * The header search template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_search = energy_option('header_search', '');


if (empty($energy_search)) {
	return;
}

switch ($energy_search):
	case 'button':
?>
		<div class="header-search">
			<button id="search_toggle" aria-controls="search_dropdown" aria-expanded="false" aria-label="<?php esc_attr_e('Search Dropdown Toggler', 'energy'); ?>">
				<?php
				energy_icon('magnify');
				?>
			</button>
		</div><!-- .header-search -->
	<?php
		break;

	case 'button2':
	?>
		<div class="header-search">
			<div class="dropdown">
				<button id="search_toggle_alt" aria-controls="search_toggle_alt" aria-expanded="false" aria-label="<?php esc_attr_e('Search Dropdown Toggler', 'energy'); ?>">
					<?php energy_icon('magnify'); ?>
				</button>
			</div>
		</div><!-- .header-search -->
	<?php
		break;
	default:
	?>
		<div class="header-search">
			<?php get_search_form(); ?>
		</div><!-- .header-search -->
<?php
endswitch;
