<?php

/**
 * The footer top section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$energy_footer_top_heading     = energy_option('footer_top_heading', '');
$energy_footer_top_description = energy_option('footer_top_description', '');
$energy_footer_top_widget      = is_active_sidebar('sidebar-footer-top');
$energy_footer_top_shortcode   = energy_option('footer_top_shortcode', '');

if (
	empty($energy_footer_top_heading)
	&&
	empty($energy_footer_top_description)
	&&
	empty($energy_footer_top_widget)
	&&
	empty($energy_footer_top_shortcode)
) {
	return;
}

$energy_fluid = energy_option('footer_fluid') ? '-fluid' : '';

$energy_footer_top_background = energy_option('footer_top_background', '');
$energy_extra_padding_top     = energy_option('footer_top_extra_padding_top', '');
$energy_extra_padding_bottom  = energy_option('footer_top_extra_padding_bottom', '');

$energy_border_top    = energy_option('footer_top_border_top', '');
$energy_border_bottom = energy_option('footer_top_border_bottom', '');
$energy_font_size     = energy_option('footer_top_font_size', '');
$energy_footer_top_layout_gap = energy_option('footer_top_layout_gap', '');

$energy_background_image = energy_section_background_image_array('footer_top');

//animation
//animate an__XXX
//footer_top_heading_animation
//footer_top_description_animation
//footer_top_button_first_animation
//footer_top_button_second_animation
//footer_top_shortcode_animation
$energy_footer_top_heading_animation       = energy_option('footer_top_heading_animation', '') ? 'animate an__' . energy_option('footer_top_heading_animation') : '';
$energy_footer_top_description_animation   = energy_option('footer_top_description_animation', '') ? 'animate an__' . energy_option('footer_top_description_animation') : '';
$energy_footer_top_button_first_animation  = energy_option('footer_top_button_first_animation', '') ? 'animate an__' . energy_option('footer_top_button_first_animation') : '';
$energy_footer_top_button_second_animation = energy_option('footer_top_button_second_animation', '') ? 'animate an__' . energy_option('footer_top_button_second_animation') : '';
$energy_footer_top_shortcode_animation     = energy_option('footer_top_shortcode_animation', '') ? 'animate an__' . energy_option('footer_top_shortcode_animation') : '';

?>
<section id="footer-top" class="footer-top footer-top-1 <?php echo esc_attr($energy_footer_top_background . ' ' . $energy_font_size . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $energy_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container<?php echo esc_attr($energy_fluid . ' ' . $energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
		<?php
		if ('container' === $energy_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}

		if (!empty($energy_footer_top_heading)) :
			$energy_footer_top_heading_mt = energy_option('footer_top_heading_mt', '');
			$energy_footer_top_heading_mb = energy_option('footer_top_heading_mb', '');
		?>
			<h3 class="footer_top-heading <?php echo esc_attr($energy_footer_top_heading_animation . ' ' . $energy_footer_top_heading_mt . ' ' . $energy_footer_top_heading_mb); ?>">
				<?php echo wp_kses_post($energy_footer_top_heading); ?>
			</h3>
		<?php
		endif; //footer_top_heading

		if (!empty($energy_footer_top_description)) :
			$energy_footer_top_description_mt = energy_option('footer_top_description_mt', '');
			$energy_footer_top_description_mb = energy_option('footer_top_description_mb', '');
		?>
			<div class="footer_top-description <?php echo esc_attr($energy_footer_top_description_animation . ' ' . $energy_footer_top_description_mt . ' ' . $energy_footer_top_description_mb); ?>">
				<?php echo wp_kses_post($energy_footer_top_description); ?>
			</div>
		<?php
		endif; //footer_top_description

		if (!empty($energy_footer_top_shortcode)) :
			$energy_footer_top_shortcode_mt = energy_option('footer_top_shortcode_mt', '');
			$energy_footer_top_shortcode_mb = energy_option('footer_top_shortcode_mb', '');
		?>
			<div class="footer_top-shortcode <?php echo esc_attr($energy_footer_top_shortcode_animation . ' ' . $energy_footer_top_shortcode_mt . ' ' . $energy_footer_top_shortcode_mb); ?>">
				<?php echo do_shortcode($energy_footer_top_shortcode); ?>
			</div>
		<?php
		endif; //footer_top_shortcode

		if (is_active_sidebar('sidebar-footer-top')) :
		?>
			<div class="footer-top-widgets <?php echo esc_attr('layout-gap-' . $energy_footer_top_layout_gap); ?>">
				<div class="layout-cols-4 grid-wrapper">
					<?php
					dynamic_sidebar('sidebar-footer-top');
					?>
				</div>
			</div><!-- .footer-top-widgets -->
		<?php
		endif;

		if ('container' === $energy_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</div><!-- .container -->
	<?php
	if ('full' === $energy_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
</section><!-- #footer -->
<?php
$footer_top_bottom_section     = energy_option('footer_top_bottom_section', '');
if (!empty($footer_top_bottom_section)) {

	//text
	$energy_footer_top_bottom_section_heading     = energy_option('footer_top_bottom_section_heading', '');
	$energy_footer_top_bottom_section_description = energy_option('footer_top_bottom_section_description', '');
	$energy_footer_top_bottom_section_shortcode   = energy_option('footer_top_bottom_section_shortcode', '');

	$energy_bottom_section_fluid = energy_option('footer_top_bottom_section_fluid') ? '-fluid' : '';

	$energy_footer_top_bottom_section_background = energy_option('footer_top_bottom_section_background', '');
	$energy_bottom_section_extra_padding_top     = energy_option('footer_top_bottom_section_extra_padding_top', '');
	$energy_bottom_section_extra_padding_bottom  = energy_option('footer_top_bottom_section_extra_padding_bottom', '');

	$energy_bottom_section_border_top    = energy_option('footer_top_bottom_section_border_top', '');
	$energy_bottom_section_border_bottom = energy_option('footer_top_bottom_section_border_bottom', '');
	$energy_bottom_section_font_size     = energy_option('footer_top_bottom_section_font_size', '');

	$energy_bottom_section_background_image = energy_section_background_image_array('footer_top_bottom_section');

	if (
		empty($energy_footer_top_bottom_section_heading)
		&&
		empty($energy_footer_top_bottom_section_description)
		&&
		empty($energy_footer_top_bottom_section_shortcode)
	) {
		return;
	}

	$footer_top_bottom_section_home_page_only = energy_option('footer_top_bottom_section_home_page_only', '');

	if (
		!empty($footer_top_bottom_section_home_page_only)
		&&
		!is_front_page()
	) {
		return;
	}
?>

	<section id="footer-top-bottom-section" class="footer-top-bottom-section <?php echo esc_attr($energy_footer_top_bottom_section_background . ' ' . $energy_bottom_section_font_size . ' ' . $energy_bottom_section_background_image['class']); ?>" <?php echo (!empty($energy_bottom_section_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_bottom_section_background_image['url']) . ');"' : ''; ?>>
		<?php
		if ('full' === $energy_bottom_section_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
		<div class="container<?php echo esc_attr($energy_bottom_section_fluid . ' ' . $energy_bottom_section_extra_padding_top . ' ' . $energy_bottom_section_extra_padding_bottom); ?>">
			<?php
			if ('container' === $energy_bottom_section_border_top) {
				echo wp_kses_post('<hr class="section-hr">');
			}

			if (!empty($energy_footer_top_bottom_section_heading)) :
				$energy_footer_top_bottom_section_heading_mb = energy_option('footer_top_bottom_section_heading_mb', '');
			?>
				<h3 class="footer_top_bottom_section-heading <?php echo esc_attr($energy_footer_top_bottom_section_heading_mb); ?>">
					<?php echo wp_kses_post($energy_footer_top_bottom_section_heading); ?>
				</h3>
			<?php
			endif; //footer_top_heading

			if (!empty($energy_footer_top_bottom_section_description)) :
				$energy_footer_top_bottom_section_description_mb = energy_option('footer_top_bottom_section_description_mb', '');
			?>
				<div class="footer_top_bottom_section-description <?php echo esc_attr($energy_footer_top_bottom_section_description_mb); ?>">
					<?php echo wp_kses_post($energy_footer_top_bottom_section_description); ?>
				</div>
			<?php
			endif; //footer_top_description

			if (!empty($energy_footer_top_bottom_section_shortcode)) :
				$energy_footer_top_bottom_section_shortcode_mb = energy_option('footer_top_bottom_section_shortcode_mb', '');
			?>
				<div class="footer_top_bottom_section-shortcode <?php echo esc_attr($energy_footer_top_bottom_section_shortcode_mb); ?>">
					<?php echo do_shortcode($energy_footer_top_bottom_section_shortcode); ?>
				</div>
			<?php
			endif; //footer_top_shortcode

			if ('container' === $energy_bottom_section_border_bottom) {
				echo wp_kses_post('<hr class="section-hr">');
			}
			?>
		</div><!-- .container -->
		<?php
		if ('full' === $energy_bottom_section_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</section><!-- .footer -->
<?php } ?>