<?php

/**
 * The copyright section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_fluid = energy_option('copyright_fluid') ? '-fluid' : '';

$energy_text = energy_option('copyright_text', '');
if (empty($energy_text)) {
	$energy_text = get_bloginfo('name', 'display');
}

$energy_copyright_background = energy_option('copyright_background', '');
$energy_extra_padding_top    = energy_option('copyright_extra_padding_top');
$energy_extra_padding_bottom = energy_option('copyright_extra_padding_bottom');
$energy_font_size            = energy_option('copyright_font_size', '');

$energy_background_image = energy_section_background_image_array('copyright'); ?>
<div id="copyright" class="copyright <?php echo esc_attr($energy_copyright_background . ' ' . $energy_font_size . ' ' . $energy_background_image['class']); ?>" <?php echo (!empty($energy_background_image['url'])) ? 'style="background-image: url(' . esc_url($energy_background_image['url']) . ');"' : ''; ?>>
	<div class="container<?php echo esc_attr($energy_fluid . ' ' . $energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
		<div class="cols-2">

			<div class="copyright-text color-dark">
				<?php echo wp_kses_post(energy_get_copyright_text($energy_text)); ?>
			</div>

			<?php
			if (has_nav_menu('copyright')) :
			?>
				<nav class="copyright-navigation" aria-label="<?php esc_attr_e('Copyright Menu', 'energy'); ?>">
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'copyright',
							'menu_class'     => 'social-navigation',
							'depth'          => 1,
							'container'      => false,
							'link_before' => '<span class="screen-reader-text">',
							'link_after'  => '</span>'
						)
					);
					?>
				</nav><!-- .copyright-navigation -->
			<?php endif; ?>
		</div><!-- .cols-2 -->
	</div><!-- .container -->

</div><!-- #copyright -->