<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('bg_teaser text-center vertical-item i'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
    <?php
    energy_post_thumbnail('energy-default-post');
    ?>
    <div class="item-content content-padding">
        <?php if (get_the_title()) : ?>
            <?php
            the_title(sprintf('<h3 class="entry-title highlightlinks" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
            ?>
        <?php endif; //get_the_title 
        ?>
        <?php
        the_content(
            energy_read_more_inside_link_markup()
        );

        wp_link_pages(
            energy_get_wp_link_pages_atts()
        );
        ?>
    </div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->