<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item with_shadow'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	energy_post_thumbnail('energy-default-post');
	?>

	<div class="item-content content-padding with-bottom-border">
		<div class="entry-meta post-meta">
			<?php
			if (
				!empty(energy_option('blog_show_author'))
				|| !empty(energy_option('blog_show_date'))
				|| !empty(energy_option('blog_show_categories'))
				|| !empty(energy_option('blog_show_comments_link'))
				|| !empty(energy_option('blog_show_views'))
			) :
			?>
				<div class="meta-left highlightlinks">
					<?php
					energy_entry_meta(true, true, true, false, true, true, true);
					?>
				</div>
			<?php endif; ?>
		</div><!-- .entry-meta -->
		<?php if (get_the_title()) : ?>
			<header class="entry-header">
				<?php
				the_title(sprintf('<h4 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h4>');
				?>
			</header><!-- .entry-header -->
		<?php endif; //get_the_title 
		?>
		<div class="entry-content" itemprop="text">
			<?php
			the_content(
				esc_html__('', 'energy')
			);
			echo ' <p class="more-tag"><a class="more-link" href="' . esc_url(get_permalink()) . '">' . energy_read_more_inside_link_markup() . '</a></p><!-- .more-tag -->';

			wp_link_pages(
				energy_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
		<?php
		if (
			!empty(energy_option('blog_show_tags'))
		) :
		?>
			<footer class="entry-footer entry-footer-top">
				<div class="meta-left highlightlinks">
					<?php
					energy_entry_meta(false, false, false, true, false, false, false);
					?>
				</div>
			</footer><!-- .entry-footer-top -->
		<?php endif; ?>
		<?php
		if (
			!empty(energy_option('blog_share_facebook', true))
			||
			!empty(energy_option('blog_share_twitter', true))
			||
			!empty(energy_option('blog_share_telegram', true))
			||
			!empty(energy_option('blog_share_pinterest', true))
			||
			!empty(energy_option('blog_share_linkedin', true))
		) :
			if (function_exists('energy_share_this')) {
		?>
				<footer class="entry-footer entry-footer-bottom entry-blog-share">
					<?php
					energy_share_this();
					?>
				</footer><!-- .entry-footer-bottom -->
		<?php
			}
		endif;
		?>
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->