<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
$author_id = get_the_author_meta('ID');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('bg_teaser text-center vertical-item i'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	energy_post_thumbnail('energy-default-post');
	?>
	<div class="item-content content-padding highlightlinks">
		<header class="entry-header">
			<?php
			if (get_the_title()) :
				the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
			endif;
			?>
		</header><!-- .entry-header -->
		<?php
		energy_post_time();
		?>
		<div class="entry-content" itemprop="text">
			<?php
			the_content(
				esc_html__('', 'energy')
			);
			wp_link_pages(
				energy_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->