<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item with_shadow'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	energy_post_thumbnail('energy-default-post');
	?>

	<div class="item-content content-padding with-bottom-border">
		<div class="entry-meta post-meta">
			<?php
			if (
				!empty(energy_option('blog_show_categories'))
				|| !empty(energy_option('blog_show_views'))
			) :
			?>
				<div class="meta-left highlightlinks">
					<?php
					energy_entry_meta(true, true, true, false, true, true, true);
					?>
				</div>
			<?php endif; ?>
		</div><!-- .entry-meta -->
		<?php if (get_the_title()) : ?>
			<header class="entry-header d-none">
				<?php
				the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
				?>
			</header><!-- .entry-header -->
		<?php endif; //get_the_title 
		?>
		<div class="entry-content darklinks" itemprop="text">
			<?php
			$energy_show_full_text = energy_option('blog_show_full_text', false);

			the_content(
				energy_read_more_inside_link_markup()
			);

			wp_link_pages(
				energy_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
		<div class="after-title greylinks">
			<span class="entry-author-wrap icon-inline">
				<?php energy_icon('user'); ?>
				<span class="vcard author" itemtype="https://schema.org/Person" itemscope="itemscope" itemprop="author">
					<?php the_author_posts_link(); ?>
				</span>
			</span><!-- .entry-author-wrap -->
			<span class="entry-date-wrap icon-inline">
				<?php energy_icon('clock-outline'); ?>
				<a href="<?php echo esc_url(get_permalink()); ?>" rel="bookmark" itemprop="mainEntityOfPage">
					<span itemprop="datePublished"><?php the_time(get_option('date_format')); ?></span>
					<span class="hidden" itemprop="dateModified"><?php the_modified_time(get_option('date_format')); ?></span>
				</a>
			</span> <!--.entry-date-wrap-->
			<span class="comments-link icon-inline">
				<?php
				energy_icon('comment-outline');
				$comments_count = get_comments_number();
				comments_popup_link($comments_count, $comments_count, $comments_count);
				?>
			</span><!-- .comments-link -->
		</div>
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->