<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
$author_id = get_the_author_meta('ID');
?>
<div class="grid-item">
	<article id="post-<?php the_ID(); ?>" <?php post_class('content-narrow bg_teaser text-center vertical-item content-padding'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
		<?php
		energy_post_thumbnail('energy-square');
		?>
		<div class="item-content i">
			<?php if (get_the_title()) : ?>
				<header class="entry-header">
					<div class="entry-avatar">
						<?php
						global $post;
						echo get_avatar($post->post_author, 96); ?>
					</div>
					<?php
					the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
					?>
				</header><!-- .entry-header -->
			<?php endif; ?>
			<div class="entry-content" itemprop="text">
				<?php
				the_content(
					esc_html__('', 'energy')
				);
				wp_link_pages(
					energy_get_wp_link_pages_atts()
				);
				?>
			</div><!-- .entry-content -->
			<div class="entry-meta post-meta">
				<?php
				if (
					!empty(energy_option('blog_show_date'))
					|| !empty(energy_option('blog_show_author'))
					|| !empty(energy_option('blog_show_comments_link'))
					|| !empty(energy_option('blog_show_views'))
					|| !empty(energy_option('blog_show_tags'))
				) :
				?>
					<div class="meta-left">
						<?php
						energy_sticky_post_label();
						energy_entry_meta(true, true, false, true, true, true, true);
						?>
					</div>
				<?php
				endif;
				?>
			</div><!-- .entry-meta -->

		</div><!-- .item-content -->
	</article><!-- #post-<?php the_ID(); ?> -->
</div>