<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<div class="grid-item">
	<article id="post-<?php the_ID(); ?>" <?php post_class('content-narrow vertical-item content-padding bordered text-center'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
		<?php
		energy_post_thumbnail('energy-square');
		if (!empty(energy_option('blog_show_categories'))) :
			energy_entry_meta(false, false, true, false, false, false, false);
		endif;
		?>

		<div class="item-content">
			<?php
			if (!empty(energy_option('blog_show_categories'))) :
				energy_entry_meta(false, false, true, false, false, false, false);
			endif;
			?>
			<?php if (get_the_title()) : ?>
				<header class="entry-header">
					<?php
					the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
					?>
				</header><!-- .entry-header -->
			<?php endif; //get_the_title 
			?>
			<div class="entry-meta post-meta">
				<?php
				if (
					!empty(energy_option('blog_show_date'))
					|| !empty(energy_option('blog_show_author'))
					|| !empty(energy_option('blog_show_comments_link'))
					|| !empty(energy_option('blog_show_views'))
					|| !empty(energy_option('blog_show_tags'))
				) :
				?>
					<div class="meta-left">
						<?php
						energy_sticky_post_label();
						energy_entry_meta(true, true, false, true, true, true, true);
						?>
					</div>
				<?php
				endif;
				?>
			</div><!-- .entry-meta -->
			<div class="entry-content" itemprop="text">
				<?php
				$energy_show_full_text = energy_option('blog_show_full_text', false);

				the_content(
					energy_read_more_inside_link_markup()
				);

				wp_link_pages(
					energy_get_wp_link_pages_atts()
				);
				?>
				<?php
				if (
					!empty(energy_option('blog_share_facebook', true))
					||
					!empty(energy_option('blog_share_twitter', true))
					||
					!empty(energy_option('blog_share_telegram', true))
					||
					!empty(energy_option('blog_share_pinterest', true))
					||
					!empty(energy_option('blog_share_linkedin', true))
				) :
					if (function_exists('energy_share_this')) {
				?>
						<div class="entry-blog-share">
							<?php
							energy_share_this();
							?>
						</div>
				<?php
					}
				endif;
				?>
			</div><!-- .entry-content -->
		</div><!-- .item-content -->
	</article><!-- #post-<?php the_ID(); ?> -->
</div>