<?php

/**
 * WooCommerce support
 *
 * @package WordPress
 * @subpackage energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//Woo min required version is 3.6

//removing aria-describedby in add to cart link
add_filter('woocommerce_loop_add_to_cart_link', 'energy_woocommerce_loop_add_to_cart_link', 10, 2);
if (!function_exists('energy_woocommerce_loop_add_to_cart_link')) :
	function energy_woocommerce_loop_add_to_cart_link($link, $product)
	{
		$link = sprintf(
			'<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s" aria-label="%s">%s</a>',
			esc_url($product->add_to_cart_url()),
			esc_attr(isset($quantity) ? $quantity : 1),
			esc_attr($product->get_id()),
			esc_attr($product->get_sku()),
			esc_attr(isset($class) ? $class : 'button product_type_simple add_to_cart_button ajax_add_to_cart'),
			esc_attr($product->add_to_cart_description()),
			esc_html($product->add_to_cart_text())
		);

		return $link;
	}
endif;

//header products counter ajax refresh
add_filter('woocommerce_add_to_cart_fragments', 'energy_filter_woocommerce_cart_count_fragments', 10, 1);
if (!function_exists('energy_filter_woocommerce_cart_count_fragments')) :
	function energy_filter_woocommerce_cart_count_fragments($fragments)
	{
		$fragments['span.cart-count'] = '<span class="cart-count">';
		if (!empty(WC()->cart->get_cart_contents_count())) {
			$fragments['span.cart-count'] .= WC()->cart->get_cart_contents_count();
		}
		$fragments['span.cart-count'] .= '</span>';
		return $fragments;
	}
endif;

//removing wrapper 'main' and 'div' elements - templates/global and adding our custom with class .woo
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

add_action('woocommerce_before_main_content', 'energy_action_woocommerce_output_content_wrapper', 10);
if (!function_exists('energy_action_woocommerce_output_content_wrapper')) :
	function energy_action_woocommerce_output_content_wrapper()
	{
		echo '<div class="woo">';
	}
endif;
add_action('woocommerce_after_main_content', 'energy_action_woocommerce_output_content_wrapper_end', 10);
if (!function_exists('energy_action_woocommerce_output_content_wrapper_end')) :
	function energy_action_woocommerce_output_content_wrapper_end()
	{
		echo '</div><!--.woo-->';
	}
endif;


//removing default WooCommerce sidebar - we have our sidebar
remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

//removing default breadcrumbs - we have our breadcrumbs
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

//removing page title if it is showing in the title section (to prevent duplication)
$energy_title = energy_option('title_show_title', '');
if (!empty($energy_title)) {
	remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
	add_filter('woocommerce_show_page_title', '__return_false');
}

/////////////////
//Products Loop//
/////////////////

//wrap products counter and filter dropdown to div on products archive
add_action('woocommerce_before_shop_loop', 'energy_action_woocommerce_before_shop_loop_open_wrap_div', 15);
if (!function_exists('energy_action_woocommerce_before_shop_loop_open_wrap_div')) :
	function energy_action_woocommerce_before_shop_loop_open_wrap_div()
	{
		echo '<div class="row clear woo-count-filter-wrap">';
	}
endif;

add_action('woocommerce_before_shop_loop', 'energy_action_woocommerce_before_shop_loop_close_wrap_div', 35);
if (!function_exists('energy_action_woocommerce_before_shop_loop_close_wrap_div')) :
	function energy_action_woocommerce_before_shop_loop_close_wrap_div()
	{
		echo '</div><!--.woo-count-filter-wrap-->';
	}
endif; //energy_action_woocommerce_before_shop_loop_close_wrap_div

//wrap product and category loop item into div
add_action('woocommerce_before_subcategory', 'energy_action_woocommerce_before_shop_loop_item_open_wrap_div', 5);
add_action('woocommerce_before_shop_loop_item', 'energy_action_woocommerce_before_shop_loop_item_open_wrap_div', 5);
if (!function_exists('energy_action_woocommerce_before_shop_loop_item_open_wrap_div')) :
	function energy_action_woocommerce_before_shop_loop_item_open_wrap_div()
	{
		echo '<div class="product-loop-item product-inner">';
		echo '<div class="product-thumbnail-wrap">';
	}
endif; //energy_action_woocommerce_before_shop_loop_item_open_wrap_div
add_action('woocommerce_after_subcategory', 'energy_action_woocommerce_after_shop_loop_item_close_wrap_div', 15);
add_action('woocommerce_after_shop_loop_item', 'energy_action_woocommerce_after_shop_loop_item_close_wrap_div', 15);
if (!function_exists('energy_action_woocommerce_after_shop_loop_item_close_wrap_div')) :
	function energy_action_woocommerce_after_shop_loop_item_close_wrap_div()
	{
		echo '</div><!--.product-text-wrap-->';
		echo '</div><!--.product-loop-item-->';
	}
endif;

add_action('woocommerce_after_shop_loop_item', 'energy_action_woocommerce_after_shop_loop_item_product_short_description', 7);
if (!function_exists('energy_action_woocommerce_after_shop_loop_item_product_short_description')) :
	function energy_action_woocommerce_after_shop_loop_item_product_short_description()
	{
		global $product;
		echo '<div class="product-short-description">';
		echo wp_kses_post($product->get_short_description());
		echo '</div><!-- .product-short-description -->';
	}
endif;

//quick view button
if (class_exists('YITH_WCQV_Frontend')) :
	remove_action('woocommerce_after_shop_loop_item', array(YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button'), 15);
	remove_action('yith_wcwl_table_after_product_name', array(YITH_WCQV_Frontend::get_instance(), 'yith_add_quick_view_button'), 15, 0);

	add_filter('yith_add_quick_view_button_html', 'energy_filter_yith_add_quick_view_button_html');
	if (!function_exists('energy_filter_yith_add_quick_view_button_html')) :
		function energy_filter_yith_add_quick_view_button_html($html)
		{
			return str_replace('class="button ', 'class="', $html);
		}
	endif;
endif;

//closing product link after image
add_action('woocommerce_before_shop_loop_item_title', 'energy_action_woocommerce_template_loop_close_link_and_div_after_thumbnail', 11);
if (!function_exists('energy_action_woocommerce_template_loop_close_link_and_div_after_thumbnail')) :
	function energy_action_woocommerce_template_loop_close_link_and_div_after_thumbnail()
	{
		echo '</a>';

		$css_rating_class = energy_option('product_show_thumbnail_rating', '') ? 'visible' : 'hidden';
		echo '<div class="product-thumbnail-rating-wrap ' . esc_attr($css_rating_class) . '">';
		if (wc_review_ratings_enabled()) {
			woocommerce_template_loop_rating();
		}
		echo '</div>';

		$show_cart_link   = energy_option('product_show_cart_thumbnail_link', '');
		$show_add_to_cart = energy_option('product_show_thumbnail_add_to_cart', '');
		$show_whishlist   = defined('YITH_WCWL') && energy_option('product_show_thumbnail_whishlist', '');
		$show_quick_view  = class_exists('YITH_WCQV_Frontend');

		if ($show_cart_link || $show_add_to_cart || $show_whishlist || $show_quick_view) :
			echo '<div class="product-buttons-wrap">';
			echo '<div class="product-icons-wrap">';
			if ($show_cart_link) {
				echo '<a class="added_to_cart wc-forward"  href="' . esc_url(wc_get_cart_url()) . '"></a>';
			}
			if ($show_add_to_cart) {
				//echo '<div class="add-to-cart-wrap">';
				woocommerce_template_loop_add_to_cart();
				//echo '</div><!-- .add-to-cart-wrap -->';
			}
			echo '</div><!-- .product-icons-wrap -->';
			echo '</div><!-- .product-buttons-wrap -->';
			//YITH WooCommerce Wishlist
			if ($show_whishlist && is_user_logged_in()) {
				echo do_shortcode('[yith_wcwl_add_to_wishlist]');
			}
			//YITH WooCommerce Quick View
			if ($show_quick_view) {
				echo do_shortcode('[yith_quick_view]');
			}
		endif; //buttons
		echo '</div><!-- .product-thumbnail-wrap -->';
		//add to cart button options
		$hide_btn  = energy_option('product_simple_add_to_cart_hide_button', '') ? 'hide-btn' : '';
		//additional product info options
		$show_cat  = energy_option('product_show_category', '') ? 'show-cat' : '';
		$show_desc = energy_option('product_show_short_description', '') ? 'show-desc' : '';
		echo '<div class="product-text-wrap ' . esc_attr($hide_btn . ' ' . $show_cat . ' ' . $show_desc) . '">';
	}
endif; //energy_woocommerce_template_loop_close_link_and_div_after_thumbnail

//putting link to product in the product title heading
if (!function_exists('energy_action_woocommerce_template_loop_product_title')) :
	function energy_action_woocommerce_template_loop_product_title()
	{
		echo '<h2 class="woocommerce-loop-product__title">';
		woocommerce_template_loop_product_link_open();
		the_title();
		woocommerce_template_loop_product_link_close();
		echo '</h2>';
	}

endif;

add_action('woocommerce_shop_loop_item_title', 'energy_action_woocommerce_template_loop_product_title_elementor_fix', 5);
function energy_action_woocommerce_template_loop_product_title_elementor_fix()
{
	add_action('woocommerce_shop_loop_item_title', 'energy_action_woocommerce_template_loop_product_title', 10);
	remove_action('woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10);
}

remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5);

//closing category link after image
add_action('woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_link_close', 9);
remove_action('woocommerce_shop_loop_subcategory_title', 'woocommerce_template_loop_category_title', 10);
//putting link to category in the product category title heading
add_action('woocommerce_shop_loop_subcategory_title', 'energy_action_woocommerce_template_loop_category_title', 10);
if (!function_exists('energy_action_woocommerce_template_loop_category_title')) :
	function energy_action_woocommerce_template_loop_category_title($category)
	{
		echo '</div><!-- .product-thumbnail-wrap -->';
		echo '<div class="product-text-wrap">';
		echo '<h2 class="woocommerce-loop-category__title">';
		woocommerce_template_loop_category_link_open($category);
		echo esc_html($category->name);
		if ($category->count > 0) {
			echo wp_kses(
				apply_filters(
					'energy_woocommerce_subcategory_count_html',
					' <mark class="count">(' . esc_html($category->count) . ')</mark>',
					$category
				),
				array(
					'mark' => array(
						'class' => array(),
					),
				)
			);
		}
		woocommerce_template_loop_category_link_close();
		echo '</h2>';
	}
endif;

//add categories to loop
add_action('woocommerce_shop_loop_item_title', 'energy_action_woocommerce_shop_loop_item_title_open_wrap', 5);
if (!function_exists('energy_action_woocommerce_shop_loop_item_title_open_wrap')) :
	function energy_action_woocommerce_shop_loop_item_title_open_wrap()
	{
		echo '<div class="product-title-cat-wrap">';
	}
endif;
add_action('woocommerce_shop_loop_item_title', 'energy_action_woocommerce_shop_loop_item_title', 20);
if (!function_exists('energy_action_woocommerce_shop_loop_item_title')) :
	function energy_action_woocommerce_shop_loop_item_title()
	{
		global $product;
		echo wp_kses_post(wc_get_product_category_list($product->get_id(), ', ', '<span class="posted_in">', '</span>'));
		echo '</div><!-- .product-title-cat-wrap -->';
	}
endif;

//add price and rating inside it
if (!function_exists('energy_action_woocommerce_after_shop_loop_item_title_price_and_add_to_cart_wrap')) :
	function energy_action_woocommerce_after_shop_loop_item_title_price_and_add_to_cart_wrap()
	{
		echo '<div class="shop-price-rating-wrap">';
		woocommerce_template_loop_price();

		if (!wc_review_ratings_enabled()) {
			return;
		}
		$css_class = energy_option('product_show_rating', '') ? 'visible' : 'hidden';
		echo '<div class="product-rating-wrap ' . esc_attr($css_class) . '">';
		woocommerce_template_loop_rating();
		echo '</div>';
		echo '</div>';
	}
endif; //energy_action_woocommerce_after_shop_loop_item_title_rating_wrap_and_reviews_count

add_action('woocommerce_after_shop_loop_item_title', 'energy_action_woocommerce_after_shop_loop_item_title_price_and_add_to_cart_wrap_elementor_fix', 5);
function energy_action_woocommerce_after_shop_loop_item_title_price_and_add_to_cart_wrap_elementor_fix()
{
	add_action('woocommerce_after_shop_loop_item_title', 'energy_action_woocommerce_after_shop_loop_item_title_price_and_add_to_cart_wrap', 10);
	remove_action('woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10);
}

//add product button wrap
if (!function_exists('energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap')) :
	function energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap()
	{
		echo '<div class="shop-product-buttons">';
		woocommerce_template_loop_add_to_cart();
		echo '</div>';
	}
endif; //energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap

add_action('woocommerce_after_shop_loop_item', 'energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap_elementor_fix', 5);
function energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap_elementor_fix()
{
	remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
	add_action('woocommerce_after_shop_loop_item', 'energy_action_woocommerce_after_shop_loop_item_add_to_cart_wrap', 10);
}


//remove closing A tag from the end of product and category loop item - we have our own earlier
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action('woocommerce_after_subcategory', 'woocommerce_template_loop_category_link_close', 10);

//change woo pagination
add_action('woocommerce_after_shop_loop', 'energy_action_woocommerce_after_shop_loop', 9);
if (!function_exists('energy_action_woocommerce_after_shop_loop')) :
	function energy_action_woocommerce_after_shop_loop()
	{
		echo '<div class="nav-links">';
	}
endif;
//change woo pagination
add_action('woocommerce_after_shop_loop', 'energy_action_woocommerce_after_shop_loop_end', 1);
if (!function_exists('energy_action_woocommerce_after_shop_loop_end')) :
	function energy_action_woocommerce_after_shop_loop_end()
	{
		echo '</div><!--.nav-links -->';
	}
endif;
//change woo pagination
add_filter('woocommerce_pagination_args', 'energy_filter_woocommerce_pagination_args');
if (!function_exists('energy_filter_woocommerce_pagination_args')) :
	function energy_filter_woocommerce_pagination_args($args)
	{
		$args['type'] = 'plain';
		$args         = wp_parse_args(energy_get_the_posts_pagination_atts(), $args);
		return $args;
	}
endif;

//add autocomplete none for search form
add_filter('get_product_search_form', 'energy_filter_woocommerce_get_product_search_form');
if (!function_exists('energy_filter_woocommerce_get_product_search_form')) :
	function energy_filter_woocommerce_get_product_search_form($form_html)
	{
		$form_html = str_replace('<form', '<form autocomplete="off"', $form_html);
		$form_html = str_replace('class="woocommerce-product-search"', 'class="woocommerce-product-search search-form"', $form_html);
		$form_html = str_replace('class="woocommerce-product-search"', 'class="woocommerce-product-search search-form"', $form_html);
		$form_html = str_replace('<button type="submit"', '<button type="submit" class="search-submit"', $form_html);
		$form_html = str_replace('</button>', energy_icon('magnify', true) . '</button>', $form_html);
		return $form_html;
	}
endif;

////////////////////
//cart page layout//
////////////////////
add_action('woocommerce_before_cart', 'energy_action_woocommerce_before_cart');
if (!function_exists('energy_action_woocommerce_before_cart')) :
	function energy_action_woocommerce_before_cart()
	{
		echo '<div class ="cart-cols">';
	}
endif;

add_action('woocommerce_after_cart', 'energy_action_woocommerce_after_cart');
if (!function_exists('energy_action_woocommerce_after_cart')) :
	function energy_action_woocommerce_after_cart()
	{
		echo '</div><!-- .cart-cols.cols-2 -->';
	}
endif;

//////////
//Blocks//
//////////

//add autocomplete none for search form
add_filter('woocommerce_blocks_product_grid_item_html', 'energy_filter_woocommerce_blocks_product_grid_item_html', 10, 2);
if (!function_exists('energy_filter_woocommerce_blocks_product_grid_item_html')) :
	function energy_filter_woocommerce_blocks_product_grid_item_html($html, $data)
	{
		return "<li class=\"product wc-block-grid__product\">
				<div class=\"product-loop-item\">
					<div class=\"product-thumbnail-wrap\">
						<a href=\"{$data->permalink}\" class=\"wc-block-grid__product-link\">
							{$data->image}
						</a>
					</div>
					<div class=\"product-text-wrap\">
						<a href=\"{$data->permalink}\" class=\"wc-block-grid__product-link\">
							{$data->title}
						</a>
						{$data->badge}
						{$data->price}
						{$data->rating}
						{$data->button}
					</div>
				</div>
			</li>";
	}
endif;

/*
add .products to block UL
uncomment, if needed
add_filter( 'the_content', 'energy_filter_woocommerce_the_content' );
*/
if (!function_exists('energy_filter_woocommerce_the_content')) :
	function energy_filter_woocommerce_the_content($html)
	{
		return str_replace('ul class="wc-block-grid__products"', 'ul class="products wc-block-grid__products"', $html);
	}
endif;

//add class to checkout button
remove_action('woocommerce_widget_shopping_cart_buttons', 'woocommerce_widget_shopping_cart_proceed_to_checkout', 20);
add_action('woocommerce_widget_shopping_cart_buttons', 'energy_action_woocommerce_widget_shopping_cart_proceed_to_checkout', 20);
if (!function_exists('energy_action_woocommerce_widget_shopping_cart_proceed_to_checkout')) :
	function energy_action_woocommerce_widget_shopping_cart_proceed_to_checkout()
	{
		echo '<a href="' . esc_url(wc_get_checkout_url()) . '" class="button alt checkout wc-forward">' . esc_html__('Checkout', 'energy') . '</a>';
	}
endif;

add_action('woocommerce_checkout_before_order_review_heading', 'energy_action_echo_div_checkout_before_order_review_heading');
if (!function_exists('energy_action_echo_div_checkout_before_order_review_heading')) :
	function energy_action_echo_div_checkout_before_order_review_heading()
	{
		echo '<div class="order_wrap">';
	}
endif;

add_action('woocommerce_checkout_after_order_review', 'energy_action_echo_div_checkout_after_order_review');
if (!function_exists('energy_action_echo_div_checkout_after_order_review')) :
	function energy_action_echo_div_checkout_after_order_review()
	{
		echo '</div>';
	}
endif;

//add spans to filter widget braces
add_filter('woocommerce_layered_nav_count', 'energy_filter_woocommerce_layered_nav_count', 10, 2);
if (!function_exists('energy_filter_woocommerce_layered_nav_count')) :
	function energy_filter_woocommerce_layered_nav_count($html, $count)
	{
		return '<span class="count"><span class="count-open">(</span>' . absint($count) . '<span class="count-close">)</span></span>';
	}
endif;

//cart_page
remove_action('woocommerce_cart_collaterals', 'woocommerce_cross_sell_display');

add_action('woocommerce_after_cart', 'woocommerce_cross_sell_display');

//add sidebar position option for product and shop
add_filter('energy_customizer_options', 'energy_filter_energy_customizer_options');
if (!function_exists('energy_filter_energy_customizer_options')) :
	function energy_filter_energy_customizer_options($options)
	{
		//sections
		$options['section_energy_woocommerce_layout'] = array(
			'type'        => 'section',
			'panel'       => 'woocommerce',
			'label'       => esc_html__('Shop Layout', 'energy'),
			'description' => esc_html__('These options let you manage sidebar positions on the shop and product pages.', 'energy'),
		);

		$options['section_energy_woocommerce_products'] = array(
			'type'        => 'section',
			'panel'       => 'woocommerce',
			'label'       => esc_html__('Products List', 'energy'),
			'description' => esc_html__('These options let you manage your products list display.', 'energy'),
		);

		$options['section_energy_woocommerce_product_share_button'] = array(
			'type'        => 'section',
			'panel'       => 'woocommerce',
			'label'       => esc_html__('Product Share Buttons', 'energy'),
			'description' => esc_html__('These options let you manage your product share buttons.', 'energy'),
		);

		//options
		//sidebars
		$options['shop_sidebar_position'] = array(
			'type'        => 'radio',
			'section'     => 'section_energy_woocommerce_layout',
			'default'     => energy_option('shop_sidebar_position', 'right'),
			'label'       => esc_html__('Shop sidebar position', 'energy'),
			'description' => esc_html__('This option let you manage sidebar position on the shop page.', 'energy'),
			'choices'     => energy_get_sidebar_position_options(),
		);

		$options['product_sidebar_position'] = array(
			'type'        => 'radio',
			'section'     => 'section_energy_woocommerce_layout',
			'default'     => energy_option('product_sidebar_position', 'right'),
			'label'       => esc_html__('Product sidebar position', 'energy'),
			'description' => esc_html__('This option let you manage sidebar position on product pages.', 'energy'),
			'choices'     => energy_get_sidebar_position_options(),
		);

		$options['header_cart_dropdown'] = array(
			'type'        => 'checkbox',
			'section'     => 'section_energy_woocommerce_layout',
			'default'     => energy_option('header_cart_dropdown', ''),
			'label'       => esc_html__('Show Cart Dropdown in Header', 'energy'),
			'description' => esc_html__('Show cart icon in header with product count in shopping cart if added.', 'energy'),
		);

		//products list
		//button options
		$options['product_simple_add_to_cart_hide_button'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_simple_add_to_cart_hide_button', ''),
			'label'   => esc_html__('Hide product "Add to Cart" button', 'energy'),
		);

		//products additional info options
		$options['product_show_category'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_category', ''),
			'label'   => esc_html__('Show products categories', 'energy'),
		);

		$options['product_show_rating'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_rating', ''),
			'label'   => esc_html__('Show rating', 'energy'),
		);

		$options['product_show_short_description'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_short_description', ''),
			'label'   => esc_html__('Show product short description', 'energy'),
		);

		$options['product_show_thumbnail_add_to_cart'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_thumbnail_add_to_cart', ''),
			'label'   => esc_html__('Show "Add to Cart" button over thumbnail', 'energy'),
		);

		$options['product_show_cart_thumbnail_link'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_cart_thumbnail_link', ''),
			'label'   => esc_html__('Show "Cart" button over thumbnail', 'energy'),
		);

		$options['product_show_thumbnail_rating'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_products',
			'default' => energy_option('product_show_thumbnail_rating', ''),
			'label'   => esc_html__('Show rating over thumbnail', 'energy'),
		);

		if (defined('YITH_WCWL')) {
			$options['product_show_thumbnail_whishlist'] = array(
				'type'    => 'checkbox',
				'section' => 'section_energy_woocommerce_products',
				'default' => energy_option('product_show_thumbnail_whishlist', ''),
				'label'   => esc_html__('Show "Whishlist" button over thumbnail', 'energy'),
			);
		}

		//product share buttons
		$options['product_share_facebook'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_product_share_button',
			'label'   => esc_html__('Enable Facebook Share Button', 'energy'),
			'default' => energy_option('product_share_facebook', true),
		);

		$options['product_share_twitter'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_product_share_button',
			'label'   => esc_html__('Enable Twitter Share Button', 'energy'),
			'default' => energy_option('product_share_twitter', true),
		);

		$options['product_share_telegram'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_product_share_button',
			'label'   => esc_html__('Enable Telegram Share Button', 'energy'),
			'default' => energy_option('product_share_telegram', true),
		);

		$options['product_share_pinterest'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_product_share_button',
			'label'   => esc_html__('Enable Pinterest Share Button', 'energy'),
			'default' => energy_option('product_share_pinterest', true),
		);

		$options['product_share_linkedin'] = array(
			'type'    => 'checkbox',
			'section' => 'section_energy_woocommerce_product_share_button',
			'label'   => esc_html__('Enable LinkedIn Share Button', 'energy'),
			'default' => energy_option('product_share_linkedin', true),
		);

		return $options;
	}
endif;

//elements in single product summary
remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
add_action('woocommerce_single_product_summary', 'energy_woocommerce_template_single_rating', 8);
if (!function_exists('energy_woocommerce_template_single_rating')) :
	function energy_woocommerce_template_single_rating()
	{
		if (!wc_review_ratings_enabled()) {
			return;
		}
		echo '<div class="product-rating-wrap">';
		woocommerce_template_loop_rating();
		if (comments_open()) :
			global $product;
			$review_count = $product->get_review_count();
			$link         = apply_filters('rating_woocommerce_loop_product_link', get_the_permalink(), $product); ?>
			<a href="<?php echo esc_url($link); ?>#reviews" class="product-review-link" rel="nofollow">
				<?php
				printf(
					esc_html(
						/* translators: 1: number of comments */
						_n(
							'(%s customer review)',
							'(%s customer reviews)',
							esc_html($review_count),
							'rating'
						)
					),
					'<span class="count">' . esc_html($review_count) . '</span>'
				);
				?>
			</a>
<?php
		endif; //comments_open
		echo '</div><!-- .product-rating-wrap -->';
	}
endif; //energy_woocommerce_template_single_rating

add_action('woocommerce_before_add_to_cart_button', 'energy_action_echo_open_div_before_add_to_cart_button');
if (!function_exists('energy_action_echo_open_div_before_add_to_cart_button')) :
	function energy_action_echo_open_div_before_add_to_cart_button()
	{
		echo '<div class="add-to-cart">';
	}
endif;

add_action('woocommerce_after_add_to_cart_button', 'energy_action_echo_open_div_after_add_to_cart_button');
if (!function_exists('energy_action_echo_open_div_after_add_to_cart_button')) :
	function energy_action_echo_open_div_after_add_to_cart_button()
	{
		echo '</div>';
	}
endif;

//change image thumbnails size
add_filter('woocommerce_get_image_size_gallery_thumbnail', 'energy_change_image_size_gallery_thumbnail');
if (!function_exists('energy_change_image_size_gallery_thumbnail')) :
	function energy_change_image_size_gallery_thumbnail($size)
	{
		return array(
			'width' => 300,
			'height' => 300,
			'crop' => 0,
		);
	}
endif;

add_action('woocommerce_before_single_product_summary', 'energy_action_echo_div_columns_before_single_product_summary', 9);
if (!function_exists('energy_action_echo_div_columns_before_single_product_summary')) :
	function energy_action_echo_div_columns_before_single_product_summary()
	{
		echo '<div class="product-wrap">';
	}
endif;

add_action('woocommerce_before_single_product_summary', 'energy_action_echo_div_close_first_column_before_single_product_summary', 21);
if (!function_exists('energy_action_echo_div_close_first_column_before_single_product_summary')) :
	function energy_action_echo_div_close_first_column_before_single_product_summary()
	{
		echo '</div><!-- eof .product-gallery-wrap -->';
	}
endif;

add_filter('woocommerce_product_thumbnails_columns', 'paulc_change_product_thumbnails_columns');
function paulc_change_product_thumbnails_columns()
{
	return 4; // change the value as per your need
}

add_action('woocommerce_single_product_summary', 'flicke_action_echo_open_div_before_add_to_cart_button');
if (!function_exists('flicke_action_echo_open_div_before_add_to_cart_button')) :
	function flicke_action_echo_open_div_before_add_to_cart_button()
	{
		$product_share_facebook  = energy_option('product_share_facebook', true);
		$product_share_twitter  = energy_option('product_share_twitter', true);
		$product_share_telegram  = energy_option('product_share_telegram', true);
		$product_share_pinterest  = energy_option('product_share_pinterest', true);
		$product_share_linkedin  = energy_option('product_share_linkedin', true);
		if ($product_share_facebook || $product_share_twitter || $product_share_telegram || $product_share_pinterest || $product_share_linkedin) {
			echo '<div class="share_buttons">';
			if ($product_share_facebook) {
				echo '<a href="https://www.facebook.com/share.php?u=' . esc_url(get_permalink()) . '" class="social-icon color-bg-icon ico-socicon-facebook" target="_blank"></a>';
			}

			if ($product_share_twitter) {
				echo '<a href="https://twitter.com/intent/tweet?url=' . esc_url(get_permalink()) . '" class="social-icon color-bg-icon ico-Twitter" target="_blank"></a>';
			}

			if ($product_share_telegram) {
				echo '<a href="https://telegram.me/share/url?url=' . esc_url(get_permalink()) . '" class="social-icon color-bg-icon ico-socicon-telegram" target="_blank"></a>';
			}

			if ($product_share_pinterest) {
				echo '<a href="https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url(get_permalink()) . '" class="social-icon color-bg-icon ico-socicon-pinterest" target="_blank"></a>';
			}

			if ($product_share_linkedin) {
				echo '<a href="https://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink()) . '" class="social-icon color-bg-icon ico-socicon-linkedin" target="_blank"></a>';
			}
			echo '</div>';
		}
	}
endif;

/**
 * New badge fields
 */
add_action('woocommerce_product_options_general_product_data', 'energy_product_badge_fields');
function energy_product_badge_fields()
{
	echo '<div class="options_group">';

	woocommerce_wp_select(
		array(
			'id'          => '_woocommerce_product_badge',
			'label'       => __('Product badge', 'energy'),
			'options'     => array(
				'none'    => __('None', 'energy'),
				'new'     => __('New', 'energy'),
				'hot'     => _x('Hot', 'Tax status', 'energy'),
			),
			'desc_tip'    => 'true',
			'description' => __('Some text.', 'energy'),
		)
	);
}

add_action('woocommerce_product_options_general_product_data', 'energy_product_video_url_fields');
function energy_product_video_url_fields()
{
	woocommerce_wp_text_input(
		array(
			'id'          => '_woocommerce_product_video_url',
			'label'       => __('Product video URL', 'energy'),
			'placeholder' => 'https://',
			'description' => __('Adds featured video embed only.', 'energy'),
		)
	);

	echo '</div>';
}

/**
 * Save custom fields values
 */
add_action('woocommerce_process_product_meta', 'energy_product_badge_fields_save');
function energy_product_badge_fields_save($post_id)
{
	$badge = $_POST['_woocommerce_product_badge'];

	if (!empty($badge)) {
		update_post_meta($post_id, '_woocommerce_product_badge', esc_attr($badge));
	}
}

add_action('woocommerce_process_product_meta', 'energy_product_video_url_fields_save');
function energy_product_video_url_fields_save($post_id)
{
	$video_url = $_POST['_woocommerce_product_video_url'];

	if (!empty($video_url)) {
		update_post_meta($post_id, '_woocommerce_product_video_url', esc_attr($video_url));
	}
}

/**
 * Display product badge
 */
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 9);
add_action('woocommerce_before_shop_loop_item_title', 'energy_simple_product_badge_display', 9);
add_action('woocommerce_before_single_product_summary', 'energy_simple_product_badge_display', 11);
function energy_simple_product_badge_display()
{
	$badge = get_post_meta(get_the_ID(), '_woocommerce_product_badge', true);

	if (!empty($badge) && $badge !== 'none') {
		$class = '';
		if ($badge === 'new') {
			$class = 'badge-new';
		} else if ($badge === 'hot') {
			$class = 'badge-hot';
		}
		echo '<span class="wc-product-badge ' . $class . '">' . $badge . '</span>';
	}
}

add_action('woocommerce_before_single_product_summary', 'energy_product_video_url_display', 11);
function energy_product_video_url_display()
{
	$video_url = get_post_meta(get_the_ID(), '_woocommerce_product_video_url', true);

	if (!empty($video_url)) {
		echo '<a href="' . $video_url . '" class="shop_video_modal_window">' . energy_icon('video', true) . '</a>';
	}
}
