<?php

/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Energy for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */

require_once ENERGY_THEME_PATH . '/inc/tgm-plugin-activation/class-tgm-plugin-activation.php';

//required plugins arrays - default and additional for different demos
if (!function_exists('energy_get_required_plugins_array')) :
	function energy_get_required_plugins_array($energy_index = 'default', $energy_all = false, $energy_all_flat = false)
	{
		$energy_required_plugins_array = array(
			//Following plugins are required for all demo contents:
			'default' => array(
				array(
					'name'     => esc_html__('Theme Widgets', 'energy'),
					'slug'     => 'mwt-widgets',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/energy-v2/plugins/mwt-widgets.zip'),
					'required' => true,
					'version'  => '0.0.1',
				),
				array(
					'name'     => esc_html__('Energy Options for Theme', 'energy'),
					'slug'     => 'energy-options-for-theme',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/energy-v2/plugins/mwt-fields.zip'),
					'required' => true,
					'version'  => '0.0.1',
				),
				array(
					'name'     => esc_html__('MWT Addons for Elementor', 'energy'),
					'slug'     => 'mwt-addons-for-elementor',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/common-plugins-original/mwt-addons-for-elementor.zip'),
					'required' => true,
					'version'  => '1.0.0',
				),
				array(
					'name'     => esc_html__('Unyson Backup', 'energy'),
					'slug'     => 'unyson-backup',
					'source'   => esc_url('http://webdesign-finder.com/remote-demo-content/common-plugins-original/unyson-backup.zip'),
					'required' => true,
				),
				array(
					'name'             => esc_html__('MailChimp', 'energy'),
					'slug'             => 'mailchimp-for-wp',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Classic Widgets', 'energy'),
					'slug'             => 'classic-widgets',
					'required'         => true,
				),
				array(
					'name'        => esc_html__('WordPress SEO by Yoast', 'energy'),
					'slug'        => 'wordpress-seo',
					'is_callable' => 'wpseo_init',
				),
				array(
					'name'     => esc_html__('Envato Market', 'energy'),
					'slug'     => 'envato-market',
					'required' => true, // please do not turn to false!
					'source'   => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
				),
				array(
					'name'             => esc_html__('Widget CSS Classes', 'energy'),
					'slug'             => 'widget-css-classes',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Contact Form 7', 'energy'),
					'slug'             => 'contact-form-7',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('Wp-Social', 'energy'),
					'slug'             => 'wp-social',
					'required'         => true
				),
				array(
					'name'             => esc_html__('Elementor', 'energy'),
					'slug'             => 'elementor',
					'required'         => true,
				),
				array(
					'name'             => esc_html__('The Events Calendar', 'energy'),
					'slug'             => 'the-events-calendar',
					'required'         => true,
				),
				array(
					'name' => esc_html__('WooCommerce', 'energy'),
					'slug' => 'woocommerce',
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Quick View', 'energy'),
					'slug'     => 'yith-woocommerce-quick-view',
					'required' => false,
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Wishlist', 'energy'),
					'slug'     => 'yith-woocommerce-wishlist',
					'required' => false,
				),
			),
			'shop'    => array(
				array(
					'name' => esc_html__('WooCommerce', 'energy'),
					'slug' => 'woocommerce',
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Wishlist', 'energy'),
					'slug'     => 'yith-woocommerce-wishlist',
					'required' => false,
				),
				array(
					'name'     => esc_html__('YITH WooCommerce Quick View', 'energy'),
					'slug'     => 'yith-woocommerce-quick-view',
					'required' => false,
				),
			),
		);
		if (!empty($energy_all_flat)) {
			$energy_required_plugins_array_all = array();
			foreach ($energy_required_plugins_array as $key => $plugins) {
				foreach ($plugins as $plugin) {
					$energy_required_plugins_array_all[$plugin['slug']] = $plugin;
				}
			}
			return $energy_required_plugins_array_all;
		} elseif (!empty($energy_all)) {
			return $energy_required_plugins_array;
		} else {
			return $energy_required_plugins_array[$energy_index];
		}
	}
endif; //energy_get_required_plugins_array

add_action('tgmpa_register', 'energy_register_required_plugins');
if (!function_exists('energy_register_required_plugins')) :
	/**
	 * Register the required plugins for this theme.
	 *
	 * The variables passed to the `tgmpa()` function should be:
	 * - an array of plugin arrays;
	 * - optionally a configuration array.
	 * If you are not changing anything in the configuration array, you can remove the array and remove the
	 * variable from the function call: `tgmpa( $energy_plugins );`.
	 * In that case, the TGMPA default settings will be used.
	 *
	 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
	 */
	function energy_register_required_plugins()
	{
		/*
		* Array of plugin arrays. Required keys are name and slug.
		* If the source is NOT from the .org repo, then source is also required.
		*/
		//we need this to install different plugins for different demos
		if (!empty($_POST['energy_all_plugins'])) {
			$energy_plugins = energy_get_required_plugins_array('', false, true);
		} else {
			$energy_plugins = energy_get_required_plugins_array();
		}
		tgmpa(
			$energy_plugins,
			array(
				'domain'       => 'energy',
				'dismissable'  => true,
				'is_automatic' => false,
			)
		);
	}
endif;

//demo content installing
//disable branding
add_filter('pt-ocdi/disable_pt_branding', '__return_true');

if (!function_exists('energy_ocdi_get_required_demo_plugins')) :
	function energy_ocdi_get_required_demo_plugins($energy_demo_number = 'default')
	{
		//get TGMPA instance
		//$energy_tgmpa = $GLOBALS['tgmpa'];
		$energy_tgmpa = call_user_func(array(get_class($GLOBALS['tgmpa']), 'get_instance'));

		//get all plugins - different plugins for different demo as keys
		$energy_plugins = energy_get_required_plugins_array('', true);

		$energy_plugins_to_install_and_activate = array(
			'all'      => array(), // Meaning: all plugins which still have open actions.
			'install'  => array(),
			'update'   => array(),
			'activate' => array(),
		);

		if (empty($energy_plugins[$energy_demo_number])) {
			return $energy_plugins_to_install_and_activate;
		}

		//registering all plugins if they are not in the default stack
		foreach ($energy_plugins[$energy_demo_number] as $energy_plugin) {
			$energy_tgmpa->register($energy_plugin);
		}

		foreach ($energy_plugins[$energy_demo_number] as $energy_plugin) {
			if (!$energy_tgmpa->can_plugin_activate($energy_plugin['slug']) && $energy_tgmpa->is_plugin_installed($energy_plugin['slug']) && false === $energy_tgmpa->does_plugin_have_update($energy_plugin['slug'])) {
				//following will cause theme check error - is_plugin_active
				// if ( $energy_tgmpa->is_plugin_active( $energy_plugin['slug'] ) && false === $energy_tgmpa->does_plugin_have_update( $energy_plugin['slug'] ) ) {
				// No need to display plugins if they are installed, up-to-date and active.
				continue;
			}
			if (!$energy_tgmpa->is_plugin_installed($energy_plugin['slug'])) {
				$energy_plugins_to_install_and_activate['install'][$energy_plugin['slug']] = $energy_plugin;
			} else {
				if (false !== $energy_tgmpa->does_plugin_have_update($energy_plugin['slug'])) {
					$energy_plugins_to_install_and_activate['update'][$energy_plugin['slug']] = $energy_plugin;
				}

				if ($energy_tgmpa->can_plugin_activate($energy_plugin['slug'])) {
					$energy_plugins_to_install_and_activate['activate'][$energy_plugin['slug']] = $energy_plugin;
				}
			}
		}

		return $energy_plugins_to_install_and_activate;
	}
endif; //energy_ocdi_get_required_demo_plugins

if (!function_exists('energy_ocdi_get_demo_install_notice_html')) :
	function energy_ocdi_get_demo_install_notice_html($energy_demo_number = 0)
	{
		$energy_plugins       = energy_ocdi_get_required_demo_plugins($energy_demo_number);
		$energy_notice_html   = '';
		$energy_data_install  = array();
		$energy_data_activate = array();
		if (!empty($energy_plugins['install']) || !empty($energy_plugins['activate'])) {
			$energy_notice_html .= '<div class="energy-ocdi-required-plugins"><strong>' . esc_html__('Required plugins:', 'energy') . '</strong></div>';
			foreach ($energy_plugins['install'] as $energy_plugin) {
				if (empty($energy_plugin['name'])) {
					continue;
				}
				$energy_notice_html   .= '<div class="energy-ocdi-plugin-install">' . esc_html($energy_plugin['name']) . ' - <span class="energy-ocdi-' . esc_attr($energy_plugin['slug']) . '">' . esc_html__('Install', 'energy') . '</span></div>';
				$energy_data_install[] = $energy_plugin['slug'];
			}
			foreach ($energy_plugins['activate'] as $energy_plugin) {
				if (empty($energy_plugin['name'])) {
					continue;
				}
				$energy_notice_html    .= '<div class="energy-ocdi-plugin-activate">' . esc_html($energy_plugin['name']) . ' - <span class="energy-ocdi-' . esc_attr($energy_plugin['slug']) . '">' . esc_html__('Activate', 'energy') . '</span></div>';
				$energy_data_activate[] = $energy_plugin['slug'];
			}
			$energy_notice_html .= '<br><div class="energy-ocdi-button-wrap"><button class="energy-ocdi-install-plugins-button button button-primary"' .
				' data-install="' . esc_attr(join(',', $energy_data_install)) . '"' .
				' data-activate="' . esc_attr(join(',', $energy_data_activate)) . '"' .
				' data-demo="' . esc_attr($energy_demo_number) . '">' .
				esc_html__('Install and Activate plugins', 'energy') .
				'</button><span class="spinner"></span></div>';
		}

		return $energy_notice_html;
	}
endif; //energy_ocdi_get_demo_install_notice_html

// http://proteusthemes.github.io/one-click-demo-import/#basic-import-setup
if (!function_exists('energy_ocdi_import_files')) :
	function energy_ocdi_import_files()
	{
		return array(
			array(
				'import_file_name'             => esc_html__('Default', 'energy'),
				'local_import_file'            => ENERGY_THEME_PATH . '/assets/demo-content/default/demo-content.xml',
				'local_import_widget_file'     => ENERGY_THEME_PATH . '/assets/demo-content/default/widgets.wie',
				'local_import_customizer_file' => ENERGY_THEME_PATH . '/assets/demo-content/default/customizer.dat',
				'import_preview_image_url'     => ENERGY_THEME_URI . '/screenshot.jpg',
				'import_notice'                => energy_ocdi_get_demo_install_notice_html('default'),
				'preview_url'                  => '//demo.energy-wordpress-theme.com/blog/',
			),
		);
	}
endif;
//demo content only on demo page or only when ajax happens - for not load and not displayed ALL required plugins by all demos
if ((!empty($_GET['page']) && ('pt-one-click-demo-import' === $_GET['page'] || 'one-click-demo-import' === $_GET['page'])) || wp_doing_ajax()) {
	add_filter('pt-ocdi/import_files', 'energy_ocdi_import_files');
}

//setting cropped default image sizes
if (!function_exists('energy_ocdi_before_content_import')) :
	function energy_ocdi_before_content_import($selected_import)
	{
		update_option('medium_crop', '1');
		update_option('large_crop', '1');
	}
endif;
add_action('pt-ocdi/before_content_import', 'energy_ocdi_before_content_import');

//setting menus, main and blog pages and special cats after demo import
if (!function_exists('energy_ocdi_after_import_setup')) :
	function energy_ocdi_after_import_setup($selected_import)
	{

		//different operations depending on different demos
		//https://github.com/awesomemotive/one-click-demo-import#how-to-handle-different-after-import-setups-depending-on-which-predefined-import-was-selected

		// Assign menus to their locations.
		$energy_menus        = array(
			'topline'   => 'footer_menu_1',
			'primary'   => 'main_menu',
			/*
			side menu will be placed with widget, not with the menu
			'side'      => 'Side Menu',
			*/
			'copyright' => 'footer_menu_1',
		);
		$energy_menus_to_set = array();
		foreach ($energy_menus as $energy_position => $energy_name) {
			$energy_menu = get_term_by('name', $energy_name, 'nav_menu');
			if (!empty($energy_menu)) {
				$energy_menus_to_set[$energy_position] = $energy_menu->term_id;
			}
		}
		if (!empty($energy_menus_to_set)) {
			set_theme_mod('nav_menu_locations', $energy_menus_to_set);
		}

		//set reusable block with inline subscribe form as a theme mod
		$inline_subscribe_block = get_page_by_title('Inline Subscribe', OBJECT, 'wp_block');
		if (!empty($inline_subscribe_block)) {
			set_theme_mod('footer_top_shortcode', '[reblex id="' . $inline_subscribe_block->ID . '"]');
		}

		//set default items count for feed
		update_option('posts_per_page', '12');

		//hide Hello World post
		$energy_hello_world_post = get_page_by_path('hello-world', OBJECT, 'post');
		if (!empty($energy_hello_world_post)) {
			$energy_hello_world_post->post_status = 'draft';
			wp_update_post($energy_hello_world_post);
		}

		//set page as front page for demo with a static homepage
		// Assign front page and posts page (blog page).
		$energy_front_page_id = get_page_by_title('Home');
		$energy_blog_page_id  = get_page_by_title('Blog');

		update_option('show_on_front', 'page');
		update_option('page_on_front', $energy_front_page_id->ID);
		update_option('page_for_posts', $energy_blog_page_id->ID);

		//set shop page as front page for shop demo content
		//		if ( 'Shop' === $selected_import['import_file_name'] ) {
		// Assign front page - Shop, and posts page (blog page).
		$energy_front_page_id = get_page_by_title('Home');
		$energy_blog_page_id  = get_page_by_title('Blog');
		// Other Woo pages
		$energy_cart_page_id     = get_page_by_title('Cart');
		$energy_checkout_page_id = get_page_by_title('Checkout');
		$energy_account_page_id  = get_page_by_title('My account');

		update_option('show_on_front', 'page');
		update_option('page_on_front', $energy_front_page_id->ID);
		update_option('page_for_posts', $energy_blog_page_id->ID);

		//Woo
		update_option('woocommerce_cart_page_id', $energy_cart_page_id->ID);
		update_option('woocommerce_checkout_page_id', $energy_checkout_page_id->ID);
		update_option('woocommerce_myaccount_page_id', $energy_account_page_id->ID);
		//customizer
		update_option('woocommerce_catalog_columns', '3');

		//set home page link in menus in demos where home page is a post archive
		if ('Blog' === $selected_import['import_file_name']) {
			$menu_items = wp_get_nav_menu_items('Main Menu');
			if (!empty($menu_items)) {
				foreach ($menu_items as $menu_item_post_object) {
					if ('Home' === $menu_item_post_object->post_title) {
						update_post_meta($menu_item_post_object->ID, '_menu_item_url', get_site_url());
						break;
					}
				}
			}
			$menu_items = wp_get_nav_menu_items('Side Menu');
			if (!empty($menu_items)) {
				foreach ($menu_items as $menu_item_post_object) {
					if ('Home' === $menu_item_post_object->post_title) {
						$menu_item_post_object->url = get_site_url();
						update_post_meta($menu_item_post_object->ID, '_menu_item_url', get_site_url());
						break;
					}
				}
			}
		}
		//set permalinks structure
		{
			global $wp_rewrite;

			//Write the rule
			$wp_rewrite->set_permalink_structure('/%postname%/');

			//Set the option
			update_option("rewrite_rules", FALSE);

			//Flush the rules and tell it to write htaccess
			$wp_rewrite->flush_rules(true);
		}

		//change hardcoded URLs in pages, reusable blocks and nav menus
		$find = 'http://webdesign-finder.com/energy';
		$replace = get_site_url();
		$query = new WP_Query(
			array(
				'post_type' => 'wp_block',
				'posts_per_page' => -1,
			)
		);
		foreach ($query->posts as $post) :
			$post->guid = str_replace($find, $replace, $post->guid);
			$post->post_content = str_replace($find, $replace, $post->post_content);
			wp_update_post($post);
		endforeach;

		$query = new WP_Query(
			array(
				'post_type' => 'page',
				'posts_per_page' => -1,
			)
		);
		foreach ($query->posts as $post) :
			$post->guid = str_replace($find, $replace, $post->guid);
			$post->post_content = str_replace($find, $replace, $post->post_content);
			wp_update_post($post);
		endforeach;
	}
endif; //energy_ocdi_after_import_setup
add_action('pt-ocdi/after_import', 'energy_ocdi_after_import_setup');

//load plugins install script
if (!function_exists('energy_ocdi_admin_enqueue_scripts')) :
	function energy_ocdi_admin_enqueue_scripts($hook)
	{
		if ('appearance_page_pt-one-click-demo-import' === $hook || 'appearance_page_one-click-demo-import' === $hook) {
			$min = !ENERGY_DEV_MODE ? 'min/' : '';
			wp_enqueue_script('energy-ocdi-plugins-install-script', ENERGY_THEME_URI . '/assets/js/' . $min . 'ocdi.js', array('jquery'), ENERGY_THEME_VERSION, true);
			wp_localize_script(
				'energy-ocdi-plugins-install-script',
				'energy_ocdi',
				array(
					'tgm_plugin_nonce' => array(
						'update'  => wp_create_nonce('tgmpa-update'),
						'install' => wp_create_nonce('tgmpa-install'),
					),
					'tgm_bulk_url'     => admin_url('themes.php?page=tgmpa-install-plugins'),
					'ajaxurl'          => admin_url('admin-ajax.php'),
					'wpnonce'          => wp_create_nonce('energy_ocdi_nonce'),
					'text_done'        => esc_html__('Done', 'energy'),
					'text_installing'  => esc_html__('Installing...', 'energy'),
					'text_activating'  => esc_html__('Activating...', 'energy'),
					'text_fail'        => esc_html__('Ajax error', 'energy'),
					'text_fail_tgm'    => esc_html__('TGMPA Ajax error', 'energy'),
				)
			);
		}
	}
endif; //energy_ocdi_admin_enqueue_scripts
add_action('admin_enqueue_scripts', 'energy_ocdi_admin_enqueue_scripts');

//process ajax call to install plugins
add_action('wp_ajax_energy_install_and_activate_plugins', 'energy_wp_ajax_install_and_activate_plugins');
if (!function_exists('energy_wp_ajax_install_and_activate_plugins')) :
	function energy_wp_ajax_install_and_activate_plugins()
	{
		if (!check_ajax_referer('energy_ocdi_nonce', 'wpnonce')) {
			wp_send_json_error(
				array(
					'error'   => 1,
					'message' => esc_html__('Forbidden', 'energy'),
				)
			);
		}
		if (empty($_POST['slug']) || (empty($_POST['plugins_activate']) && empty($_POST['plugins_install']))) {
			wp_send_json_error(
				array(
					'error'   => 1,
					'message' => esc_html__('No Plugins to Process', 'energy'),
				)
			);
		}

		$plugins = array();
		// send back some json we use to hit up TGM
		if (isset($_POST['plugins_activate'])) {
			$plugins['activate'] = array_map('sanitize_title', $_POST['plugins_activate']);
		} else {
			$plugins['activate'] = array();
		}
		if (isset($_POST['plugins_install'])) {
			$plugins['install'] = array_map('sanitize_title', $_POST['plugins_install']);
		} else {
			$plugins['install'] = array();
		}
		// what are we doing with this plugin?
		//activating - is default
		$json = array(
			'url'             => admin_url('themes.php?page=tgmpa-install-plugins'),
			'plugin'          => array_filter($plugins['activate']),
			'tgmpa-page'      => 'tgmpa-install-plugins',
			'plugin_status'   => 'all',
			'_wpnonce'        => wp_create_nonce('bulk-plugins'),
			'action'          => 'tgmpa-bulk-activate',
			'action2'         => -1,
			'message'         => esc_html__('Activating Plugin...', 'energy'),
			//load all plugins, not only default
			'energy_all_plugins' => 1,
		);
		//every plugin to install is separate call
		//override activation here
		foreach ($plugins['install'] as $slug) {
			if ($slug === $_POST['slug']) {
				$json = array(
					'url'             => admin_url('themes.php?page=tgmpa-install-plugins'),
					'plugin'          => array($slug),
					'tgmpa-page'      => 'tgmpa-install-plugins',
					'plugin_status'   => 'all',
					'_wpnonce'        => wp_create_nonce('bulk-plugins'),
					'action'          => 'tgmpa-bulk-install',
					'action2'         => -1,
					'message'         => esc_html__('Installing Plugin...', 'energy'),
					//load all plugins, not only default
					'energy_all_plugins' => 1,
				);
				break;
			}
		}

		if ($json) {
			$json['hash'] = md5(serialize($json)); // used for checking if duplicates happen, move to next plugin
			wp_send_json($json);
		} else {
			wp_send_json(
				array(
					'done'    => 1,
					'message' => esc_html__('Success', 'energy'),
				)
			);
		}
		wp_die();
	}
endif; //energy_wp_ajax_install_and_activate_plugins
