<?php

/**
 * Theme options
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//default values for customizer or other theme options
if (!function_exists('energy_get_default_options_array')) :
    function energy_get_default_options_array()
    {

        //fonts choises:
        // Open Sans
        // Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese
        // Roboto
        // Lato
        // Raleway
        // Montserrat
        // PT Sans
        // Source Sans Pro
        // Oswald
        // Lora
        // Work Sans

        return array(
            'demo_number' => '',
            'colorLight' => '#ffffff',
            'colorFont' => '#8c8c8c',
            'colorFontDark' => '#e6e4e4',
            'colorBackground' => '#f5f5f5',
            'colorBackgroundDark' => '#1e1e1e',
            'colorBorder' => '#e3e3e3',
            'colorBorderDark' => '#353535',
            'colorDark' => '#303030',
            'colorDarkGrey' => '#333333',
            'colorGrey' => '#a4a4a4',
            'colorMain' => '#fcca03',
            'color_meta_icons' => 'meta-icons-dark-muted',
            'color_skin' => '',
            'intro_block_heading' => '',
            'intro_position' => '',
            'intro_layout' => '',
            'intro_fullscreen' => '1',
            'intro_background' => 'i',
            'intro_background_image' => '',
            'intro_background_image_cover' => '1',
            'intro_background_image_fixed' => '',
            'intro_background_image_overlay' => '',
            'intro_image' => '',
            'intro_background_image_scale' => '',
            'intro_image_absolute' => '',
            'intro_image_animation' => '',
            'intro_pre_heading' => '',
            'intro_pre_heading_mt' => '',
            'intro_pre_heading_mb' => '',
            'intro_pre_heading_animation' => '',
            'intro_heading' => '',
            'intro_heading_mt' => '',
            'intro_heading_mb' => '',
            'intro_heading_animation' => '',
            'intro_description' => '',
            'intro_description_mt' => '',
            'intro_description_mb' => '',
            'intro_description_animation' => '',
            'intro_button_text_first' => '',
            'intro_button_url_first' => '',
            'intro_button_first_animation' => '',
            'intro_button_text_second' => '',
            'intro_button_url_second' => '',
            'intro_button_second_animation' => '',
            'intro_buttons_mt' => '',
            'intro_buttons_mb' => '',
            'intro_shortcode' => '',
            'intro_shortcode_mt' => '',
            'intro_shortcode_mb' => '',
            'intro_shortcode_animation' => '',
            'intro_alignment' => 'text-center',
            'intro_extra_padding_top' => '',
            'intro_extra_padding_bottom' => '',
            'intro_social_links' => '1',
            'intro_font_size' => 'fs-20',
            'logo_image_inverse' => '',
            'logo' => '1',
            'logo_primary_text' => 'Energy',
            'logo_text_secondary' => 'New age of technologies',
            'header_top_tall' => '',
            'logo_background' => '',
            'logo_padding_horizontal' => '',
            'preset' => '',
            'main_container_width' => '1170',
            'blog_container_width' => '',
            'blog_single_container_width' => '',
            'boxed' => '',
            'preloader' => 'cover',
            'box_fade_in' => '1',
            'totop' => '1',
            'assets_min' => '',
            'jquery_to_footer' => '',
            'meta_email' => 'energy@example.com',
            'meta_email_label' => '',
            'meta_email_2' => 'support@example.com',
            'meta_email_2_label' => '',
            'meta_phone' => '0800 123 4567',
            'meta_phone_label' => '',
            'meta_phone_2' => '0800 123 4566',
            'meta_phone_2_label' => '',
            'meta_address' => 'Sacramento, California',
            'meta_address_label' => '1116 15th St, ',
            'meta_opening_hours' => 'Mon - Sat 8.00 - 18.00',
            'meta_opening_hours_label' => 'Opening Times: ',
            'meta_facebook' => '#',
            'meta_twitter' => '#',
            'meta_instagram' => '#',
            'meta_linkedin' => '#',
            'meta_youtube' => '',
            'meta_pinterest' => '',
            'meta_github' => '',
            'meta_apple' => '#',
            'meta_play' => '#',
            'meta_amazon' => '#',
            'meta_spotify' => '#',
            'meta_soundcloud' => '#',
            'header_image_background_image_cover' => '',
            'header_image_background_image_fixed' => '',
            'header_image_background_image_overlay' => '',
            'header' => '2',
            'header_fluid' => '',
            'header_background' => 'i c',
            'header_background_image' => '',
            'header_background_image_cover' => '',
            'header_background_image_fixed' => '',
            'header_background_image_overlay' => '',
            'header_toplogo' => '1',
            'header_toplogo_background' => 'i',
            'header_toplogo_font_size' => 'fs-14',
            'header_meta' => '1',
            'header_align_main_menu' => '',
            'header_toggler_menu_main' => '1',
            'header_absolute_home_page' => '',
            'header_absolute' => '',
            'header_transparent' => '',
            'header_border_top' => '',
            'header_border_bottom' => '',
            'header_font_size' => 'fs-13',
            'header_sticky' => 'always-sticky',
            'header_button_text' => 'Buy Tickets',
            'header_button_url' => '',
            'header_search' => 'button2',
            'header_topline_options_heading' => '',
            'topline' => '1',
            'topline_fluid' => '',
            'topline_background' => 'i m',
            'topline_font_size' => 'fs-12',
            'topline_before_social_word' => 'Follow Us:',
            'topline_meta_opening_hours' => '1',
            'topline_meta_mail' => '',
            'topline_meta_phone' => '',
            'topline_meta_address' => '',
            'header_logo_background' => '',
            'title' => '3',
            'title_fluid' => '',
            'title_show_title' => '1',
            'title_show_breadcrumbs' => '1',
            'title_background' => 'i',
            'title_border_top' => '',
            'title_border_bottom' => '',
            'title_extra_padding_top' => '',
            'title_extra_padding_bottom' => '',
            'title_font_size' => 'fs-14',
            'title_hide_taxonomy_name' => '1',
            'title_background_image' => '',
            'title_background_image_cover' => '1',
            'title_background_image_fixed' => '',
            'title_background_image_overlay' => '',
            'main_sidebar_width' => '30',
            'main_gap_width' => '',
            'main_sidebar_sticky' => '',
            'main_extra_padding_top' => '',
            'main_extra_padding_bottom' => '',
            'main_font_size' => 'fs-14',
            'sidebar_font_size' => '',
            'main_version' => 'l',
            '404_heading' => '',
            '404_text_bottom_line' => '',
            '404_background' => 'i',
            '404_background_image' => '',
            '404_background_image_overlay' => '',
            '404_extra_padding_top' => 'pt-8',
            '404_extra_padding_bottom' => 'pb-11',
            'footer_top' => '4',
            'footer_top_layout_gap' => '30',
            'footer_top_fluid' => '',
            'footer_top_heading' => '',
            'footer_top_heading_mt' => '',
            'footer_top_heading_mb' => '',
            'footer_top_heading_animation' => '',
            'footer_top_description' => '',
            'footer_top_description_mt' => '',
            'footer_top_description_mb' => '',
            'footer_top_description_animation' => '',
            'footer_top_shortcode' => '',
            'footer_top_shortcode_mt' => '',
            'footer_top_shortcode_mb' => '',
            'footer_top_shortcode_animation' => '',
            'footer_top_background' => 'i',
            'footer_top_border_top' => '',
            'footer_top_border_bottom' => '',
            'footer_top_extra_padding_top' => '',
            'footer_top_extra_padding_bottom' => '',
            'footer_top_font_size' => 'fs-15',
            'footer_top_background_image' => '',
            'footer_top_background_image_cover' => '1',
            'footer_top_background_image_fixed' => '',
            'footer_top_background_image_overlay' => '',
            'footer_top_bottom_section_options_heading' => '',
            'footer_top_bottom_section' => '',
            'footer_top_bottom_section_home_page_only' => '1',
            'footer_top_bottom_section_fluid' => '',
            'footer_top_bottom_section_heading' => '',
            'footer_top_bottom_section_heading_mb' => '',
            'footer_top_bottom_section_description' => '',
            'footer_top_bottom_section_description_mb' => '',
            'footer_top_bottom_section_shortcode' => '',
            'footer_top_bottom_section_background' => '',
            'footer_top_bottom_section_border_top' => 'container',
            'footer_top_bottom_section_border_bottom' => 'container',
            'footer_top_bottom_section_extra_padding_top' => '',
            'footer_top_bottom_section_extra_padding_bottom' => '',
            'footer_top_bottom_section_font_size' => 'fs-14',
            'footer_top_bottom_section_background_image' => '',
            'footer_top_bottom_section_background_image_cover' => '',
            'footer_top_bottom_section_background_image_fixed' => '',
            'footer_top_bottom_section_background_image_overlay' => '',
            'footer' => '1',
            'footer_layout_gap' => '30',
            'footer_fluid' => '',
            'footer_background' => 'i',
            'footer_border_top' => '',
            'footer_border_bottom' => 'container',
            'footer_extra_padding_top' => '',
            'footer_extra_padding_bottom' => '',
            'footer_font_size' => 'fs-14',
            'footer_background_image' => '',
            'footer_background_image_cover' => '1',
            'footer_background_image_fixed' => '1',
            'footer_background_image_overlay' => '',
            'copyright' => '1',
            'copyright_text' => '© Energy - The Premium WordPress Theme. Created With <span class="ico-icomoon-4"></span> <a class="darklink" href="http://themeforest.net/user/wprollers">by WPRollers</a>',
            'copyright_fluid' => '',
            'copyright_background' => 'i',
            'copyright_extra_padding_top' => '',
            'copyright_extra_padding_bottom' => '',
            'copyright_font_size' => 'fs-12',
            'copyright_background_image' => '',
            'copyright_background_image_cover' => '1',
            'copyright_background_image_fixed' => '1',
            'copyright_background_image_overlay' => '',
            'font_body_heading' => '',
            'font_body' => '{"font":"Open Sans","variant":["300","300italic","regular","italic","600","600italic","700","700italic","800","800italic"],"subset":["latin-ext","latin"]}',
            'font_headings_heading' => '',
            'font_headings' => '{"font":"Raleway","variant":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subset":["latin-ext","latin"]}',
            'blog_layout' => 'default-half-image',
            'blog_sidebar_position' => 'right',
            'blog_page_name' => 'Blog',
            'blog_show_full_text' => '',
            'blog_excerpt_length' => '25',
            'blog_read_more_text' => 'Read more',
            'blog_hide_taxonomy_type_name' => '1',
            'blog_meta_options_heading' => '',
            'blog_hide_meta_icons' => '1',
            'blog_show_author' => '',
            'blog_show_author_avatar' => '',
            'blog_before_author_word' => '',
            'blog_show_date' => '',
            'blog_before_date_word' => '',
            'blog_show_categories' => '1',
            'blog_before_categories_word' => '',
            'blog_show_tags' => '',
            'blog_before_tags_word' => '',
            'blog_show_views' => '',
            'blog_before_views_word' => '',
            'blog_show_likes' => '',
            'blog_before_likes_word' => '',
            'blog_show_comments_link' => '',
            'blog_share_options_heading' => '',
            'blog_share_facebook' => '',
            'blog_share_twitter' => '',
            'blog_share_telegram' => '',
            'blog_share_pinterest' => '',
            'blog_share_linkedin' => '',
            'blog_single_sidebar_position' => 'right',
            'blog_single_show_author_bio' => '',
            'blog_single_author_bio_about_word' => 'Author',
            'blog_single_post_nav_heading' => '',
            'blog_single_post_nav' => 'bg',
            'blog_single_post_nav_word_prev' => 'Prev',
            'blog_single_post_nav_word_next' => 'Next',
            'blog_single_related_posts_heading' => '',
            'blog_single_related_posts' => '',
            'blog_single_related_posts_title' => 'Related Posts',
            'blog_single_related_posts_number' => '3',
            'blog_single_meta_options_heading' => '',
            'blog_single_hide_meta_icons' => '',
            'blog_single_hide_meta_categories_icons' => '1',
            'blog_single_show_author' => '',
            'blog_single_show_author_avatar' => '',
            'blog_single_before_author_word' => '',
            'blog_single_show_date' => '',
            'blog_single_before_date_word' => '',
            'blog_single_show_categories' => '1',
            'blog_single_before_categories_word' => '',
            'blog_single_show_tags' => '1',
            'blog_single_before_tags_word' => '',
            'blog_single_show_views' => '1',
            'blog_single_before_views_word' => '',
            'blog_single_show_likes' => '1',
            'blog_single_show_comments_link' => 'number',
            'blog_single_comments_title_reply' => '',
            'blog_single_share_options_heading' => '',
            'blog_single_share_facebook' => '',
            'blog_single_share_twitter' => '',
            'blog_single_share_telegram' => '',
            'blog_single_share_pinterest' => '',
            'blog_single_share_linkedin' => '',
            'animation_enabled' => '1',
            'animation_sidebar_widgets' => '',
            'animation_footer_top_widgets' => '',
            'animation_footer_widgets' => '',
            'animation_feed_posts' => '',
            'animation_feed_posts_thumbnail' => '',
            'shop_sidebar_position' => 'left',
            'product_sidebar_position' => 'no',
            'header_cart_dropdown' => '1',
            'product_simple_add_to_cart_hide_button' => '',
            'product_show_category' => '',
            'product_show_rating' => '',
            'product_show_short_description' => '',
            'product_show_thumbnail_add_to_cart' => '',
            'product_show_cart_thumbnail_link' => '',
            'product_show_thumbnail_rating' => '1',
            'product_show_thumbnail_whishlist' => '',
            'product_share_facebook' => '',
            'product_share_twitter' => '',
            'product_share_telegram' => '',
            'product_share_pinterest' => '',
            'product_share_linkedin' => '',
        );
    }
endif;

//get theme option from default or from customizer
if (!function_exists('energy_option')) :
    function energy_option($energy_option_name, $energy_default_value = '')
    {
        //get theme defaults
        $energy_defaults = energy_get_default_options_array();

        //lowest priority is basic default value from theme defaults
        $energy_return = (!empty($energy_defaults[$energy_option_name])) ? $energy_defaults[$energy_option_name] : $energy_default_value;

        unset($energy_defaults);

        //theme_mods are higher - if not empty - overriding value from theme default
        $energy_return = get_theme_mod($energy_option_name, $energy_return);

        if (isset($_GET[$energy_option_name])) {
            $energy_return = sanitize_text_field($_GET[$energy_option_name]);
        }

        return $energy_return;
    }
endif;

//layout options array. Used global in customizer and for categories
if (!function_exists('energy_get_feed_layout_options')) :
    function energy_get_feed_layout_options($energy_category = false)
    {
        if (empty($energy_category)) {
            $energy_first_element = esc_html__('Default - Top featured image', 'energy');
        } else {
            $energy_first_element = esc_html__('Inherit from Customizer settings', 'energy');
        }

        $energy_return = apply_filters(
            'energy_feed_layout_options',
            array(
                ''                                => $energy_first_element,
                'default-half-image'              => esc_html__('Half thumbnail', 'energy'),
            )
        );

        return $energy_return;
    }
endif;

//gap options array. Used global in customizer and for categories
if (!function_exists('energy_get_feed_layout_gap_options')) :
    function energy_get_feed_layout_gap_options($energy_category = false)
    {
        if (empty($energy_category)) {
            $energy_first_element = esc_html__('Default - none', 'energy');
        } else {
            $energy_first_element = esc_html__('Inherit from Customizer settings', 'energy');
        }

        $energy_return = apply_filters(
            'energy_feed_layout_gap_options',
            array(
                ''   => $energy_first_element,
                '1'  => esc_html__('1px', 'energy'),
                '2'  => esc_html__('2px', 'energy'),
                '3'  => esc_html__('3px', 'energy'),
                '4'  => esc_html__('4px', 'energy'),
                '5'  => esc_html__('5px', 'energy'),
                '10' => esc_html__('10px', 'energy'),
                '15' => esc_html__('15px', 'energy'),
                '20' => esc_html__('20px', 'energy'),
                '30' => esc_html__('30px', 'energy'),
                '40' => esc_html__('40px', 'energy'),
                '50' => esc_html__('50px', 'energy'),
                '60' => esc_html__('60px', 'energy'),
            )
        );

        return $energy_return;
    }
endif;


//layout options array. Used global in customizer and for single posts
if (!function_exists('energy_get_post_layout_options')) :
    function energy_get_post_layout_options($energy_category = false)
    {
        if (empty($energy_category)) {
            $energy_first_element = esc_html__('Default - top featured image', 'energy');
        } else {
            $energy_first_element = esc_html__('Inherit from Customizer settings', 'energy');
        }

        $energy_return = apply_filters(
            'energy_post_layout_options',
            array(
                ''                    => $energy_first_element,
                'wide-image'          => esc_html__('Wide featured image', 'energy'),
                'meta-top'            => esc_html__('Post meta above featured image', 'energy'),
                'meta-image'          => esc_html__('Post meta on featured image', 'energy'),
                'meta-side'           => esc_html__('Side post meta', 'energy'),
                'bottom-meta'         => esc_html__('Bottom post meta', 'energy'),
                'title-section-image' => esc_html__('Title section featured image', 'energy'),
            )
        );

        return $energy_return;
    }
endif;


//sidebar options array. Used global in customizer and for categories
if (!function_exists('energy_get_sidebar_position_options')) :
    function energy_get_sidebar_position_options($energy_category = false)
    {
        if (empty($energy_category)) {
            $energy_first_element = esc_html__('Default', 'energy');
        } else {
            $energy_first_element = esc_html__('Inherit from Customizer settings', 'energy');
        }

        $energy_return = array(
            'right' => esc_html__('Right sidebar', 'energy'),
            'left'  => esc_html__('Left sidebar', 'energy'),
            'no'    => esc_html__('No sidebar', 'energy'),
        );

        if ($energy_category) {
            $energy_return = array($energy_first_element) + $energy_return;
        }

        return $energy_return;
    }
endif;

//animation options array.
if (!function_exists('energy_get_animation_options')) :
    function energy_get_animation_options()
    {

        $energy_return = array(
            ''             => esc_html__('None', 'energy'),
            'bounce'       => esc_html__('bounce', 'energy'),
            'flash'        => esc_html__('flash', 'energy'),
            'pulse'        => esc_html__('pulse', 'energy'),
            'rubberBand'   => esc_html__('rubberBand', 'energy'),
            'shake'        => esc_html__('shake', 'energy'),
            'headShake'    => esc_html__('headShake', 'energy'),
            'swing'        => esc_html__('swing', 'energy'),
            'tada'         => esc_html__('tada', 'energy'),
            'wobble'       => esc_html__('wobble', 'energy'),
            'jello'        => esc_html__('jello', 'energy'),
            'heartBeat'    => esc_html__('heartBeat', 'energy'),
            'bounceIn'     => esc_html__('bounceIn', 'energy'),
            'fadeInEnergy'       => esc_html__('fadeIn', 'energy'),
            'fadeInDown'   => esc_html__('fadeInDown', 'energy'),
            'fadeInLeft'   => esc_html__('fadeInLeft', 'energy'),
            'fadeInRight'  => esc_html__('fadeInRight', 'energy'),
            'fadeInUp'     => esc_html__('fadeInUp', 'energy'),
            'flip'         => esc_html__('flip', 'energy'),
            'flipInX'      => esc_html__('flipInX', 'energy'),
            'flipInY'      => esc_html__('flipInY', 'energy'),
            'lightSpeedIn' => esc_html__('lightSpeedIn', 'energy'),
            'jackInTheBox' => esc_html__('jackInTheBox', 'energy'),
            'zoomIn'       => esc_html__('zoomIn', 'energy'),
        );

        return $energy_return;
    }
endif;

if (!class_exists('Energy_Color')) {
    class Energy_Color
    {
        public $hex;
        public $rgb;
        public $hsl;

        public function __construct($hex)
        {
            $hex = str_replace("#", "", $hex);
            $this->hex = $hex;
            $this->rgb = $this->hexToRgb($this->hex);
            $this->hsl = $this->toHSL($this->rgb);
        }
        public function back()
        {
            $this->rgb = $this->HSLtoRGB($this->hsl);
            $this->hex = $this->rgb2hex($this->rgb);
        }
        public function adjust_hue($newVal)
        {
            $this->hsl[0] += $newVal;
            $this->back();
        }
        public function saturate($newVal)
        {
            $this->hsl[1] += $newVal;
            $this->back();
        }
        public function desaturate($newVal)
        {
            $this->hsl[1] -= $newVal;
            $this->back();
        }
        public function lighten($newVal)
        {
            $this->hsl[2] += $newVal;
            $this->back();
        }
        public function darken($newVal)
        {
            $this->hsl[2] -= $newVal;
            $this->back();
        }
        public function get_all()
        {
            return array(
                'hex' => $this->hex,
                'rgb' => $this->rgb,
                'hls' => $this->hsl,
            );
        }
        public function hexToRgb($hex)
        {
            if (strlen($hex) == 3) {
                $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
                $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
                $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
            } else {
                $r = hexdec(substr($hex, 0, 2));
                $g = hexdec(substr($hex, 2, 2));
                $b = hexdec(substr($hex, 4, 2));
            }
            $rgb = array($r, $g, $b);
            return $rgb; // returns an array with the rgb values
        }
        public function rgbString()
        {
            return implode(", ", $this->rgb);
        }
        public function toHSL($rgb)
        {
            $red = $rgb[0];
            $green = $rgb[1];
            $blue = $rgb[2];
            $max = max($red, $green, $blue);
            $min = min($red, $green, $blue);

            $lightness = $max + $min;

            if ($max === $min) {
                $saturation = $hue = 0;
            } else {
                $diff = $max - $min;

                if ($lightness < 255) $saturation = $diff / $lightness;
                else $saturation = $diff / (510 - $lightness);

                if ($max === $red) $hue = 60 * ($green - $blue) / $diff;
                elseif ($max === $green) $hue = 60 * ($blue - $red) / $diff + 120;
                elseif ($max === $blue) $hue = 60 * ($red - $green) / $diff + 240;
            }

            return array(fmod($hue, 360), $saturation * 100, $lightness / 5.1);
        }
        public function hueToRGB($p, $q, $decHue)
        {
            if ($decHue < 0) $decHue += 1;
            else if ($decHue > 1) $decHue -= 1;

            if ($decHue * 6 < 1) return $p + ($q - $p) * $decHue * 6;
            if ($decHue * 2 < 1) return $q;
            if ($decHue * 3 < 2) return $p + ($q - $p) * (2 / 3 - $decHue) * 6;

            return $p;
        }
        // hue from 0 to 360, saturation and lightness from 0 to 100
        public function HSLtoRGB($hsl)
        {
            $hue = $hsl[0];
            $saturation = $hsl[1];
            $lightness = $hsl[2];
            if ($hue < 0) $hue += 360;

            $decHue = $hue / 360;
            $decSaturation = min(100, max(0, $saturation)) / 100;
            $decLightness = min(100, max(0, $lightness)) / 100;

            $q = $decLightness <= 0.5 ? $decLightness * ($decSaturation + 1) : $decLightness + $decSaturation - $decLightness * $decSaturation;
            $p = $decLightness * 2 - $q;

            $red = $this->hueToRGB($p, $q, $decHue + 1 / 3) * 255;
            $green = $this->hueToRGB($p, $q, $decHue) * 255;
            $blue = $this->hueToRGB($p, $q, $decHue - 1 / 3) * 255;

            return array(round($red), round($green), round($blue));
        }
        function rgb2hex($rgb)
        {
            $hex = '';
            $hex .= str_pad(dechex($rgb[0]), 2, "0", STR_PAD_LEFT);
            $hex .= str_pad(dechex($rgb[1]), 2, "0", STR_PAD_LEFT);
            $hex .= str_pad(dechex($rgb[2]), 2, "0", STR_PAD_LEFT);

            return $hex; // returns the hex value including the number sign (#)
        }
    }
}

if (!function_exists('sanitize_rgba_color')) {
    function sanitize_rgba_color($color)
    {
        if (empty($color) || is_array($color)) {
            return 'rgba(0,0,0,0)';
        }

        // If string does not start with 'rgba', then treat as hex
        // sanitize the hex color and finally convert hex to rgba
        if (false === strpos($color, 'rgba')) {
            return sanitize_hex_color($color);
        }

        // By now we know the string is formatted as an rgba color so we need to further sanitize it.
        $color = str_replace(' ', '', $color);
        sscanf($color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha);

        return 'rgba(' . $red . ',' . $green . ',' . $blue . ',' . $alpha . ')';
    }
}

//get :root colors inline styles string
if (!function_exists('energy_get_root_colors_inline_styles_string')) :
    function energy_get_root_colors_inline_styles_string()
    {
        //colors
        $energy_colors_string = '';
        // colorLight
        // colorFont
        // colorFontDark
        // colorBackground
        // colorBackgroundDark
        // colorBorder
        // colorBorderDark
        // colorDark
        // colorDarkGrey
        // colorGrey
        // colorMain

        $energy_colors_string .= energy_option('colorLight', '') ? '--colorLight:' . sanitize_hex_color(energy_option('colorLight', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorFont', '') ? '--colorFont:' . sanitize_hex_color(energy_option('colorFont', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorFontDark', '') ? '--colorFontDark:' . sanitize_hex_color(energy_option('colorFontDark', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorBackground', '') ? '--colorBackground:' . sanitize_hex_color(energy_option('colorBackground', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorBackgroundDark', '') ? '--colorBackgroundDark:' . sanitize_hex_color(energy_option('colorBackgroundDark', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorBorder', '') ? '--colorBorder:' . sanitize_hex_color(energy_option('colorBorder', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorBorderDark', '') ? '--colorBorderDark:' . sanitize_hex_color(energy_option('colorBorderDark', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorDark', '') ? '--colorDark:' . sanitize_hex_color(energy_option('colorDark', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorDarkGrey', '') ? '--colorDarkGrey:' . sanitize_hex_color(energy_option('colorDarkGrey', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorGrey', '') ? '--colorGrey:' . sanitize_hex_color(energy_option('colorGrey', '')) . ';' : '';
        $energy_colors_string .= energy_option('colorMain', '') ? '--colorMain:' . sanitize_hex_color(energy_option('colorMain', '')) . ';' : '';

        //RGB Colors
        // colorMainRGB
        $colorMainRGB = new Energy_Color(energy_option('colorMain', ''));
        $colorMainRGB = $colorMainRGB->rgbString();
        $energy_colors_string .= '--colorMainRGB:' . $colorMainRGB . ';';

        // colorFontRGB
        $colorFontRGB = new Energy_Color(energy_option('colorFont', ''));
        $colorFontRGB = $colorFontRGB->rgbString();
        $energy_colors_string .= '--colorFontRGB:' . $colorFontRGB . ';';

        // colorFontDarkRGB
        $colorFontDarkRGB = new Energy_Color(energy_option('colorFontDark', ''));
        $colorFontDarkRGB = $colorFontDarkRGB->rgbString();
        $energy_colors_string .= '--colorFontDarkRGB:' . $colorFontDarkRGB . ';';

        // colorDarkGreyRGB
        $colorDarkGreyRGB = new Energy_Color(energy_option('colorDarkGrey', ''));
        $colorDarkGreyRGB = $colorDarkGreyRGB->rgbString();
        $energy_colors_string .= '--colorDarkGreyRGB:' . $colorDarkGreyRGB . ';';

        // colorGreyRGB
        $colorGreyRGB = new Energy_Color(energy_option('colorGrey', ''));
        $colorGreyRGB = $colorGreyRGB->rgbString();
        $energy_colors_string .= '--colorGreyRGB:' . $colorGreyRGB . ';';

        // colorDarkRGB
        $colorDarkRGB = new Energy_Color(energy_option('colorDark', ''));
        $colorDarkRGB = $colorDarkRGB->rgbString();
        $energy_colors_string .= '--colorDarkRGB:' . $colorDarkRGB . ';';

        // colorLightRGB
        $colorLightRGB = new Energy_Color(energy_option('colorLight', ''));
        $colorLightRGB = $colorLightRGB->rgbString();
        $energy_colors_string .= '--colorLightRGB:' . $colorLightRGB . ';';

        // colorBackgroundRGB
        $colorBackgroundRGB = new Energy_Color(energy_option('colorBackground', ''));
        $colorBackgroundRGB = $colorBackgroundRGB->rgbString();
        $energy_colors_string .= '--colorBackgroundRGB:' . $colorBackgroundRGB . ';';

        // colorBackgroundDarkRGB
        $colorBackgroundDarkRGB = new Energy_Color(energy_option('colorBackgroundDark', ''));
        $colorBackgroundDarkRGB = $colorBackgroundDarkRGB->rgbString();
        $energy_colors_string .= '--colorBackgroundDarkRGB:' . $colorBackgroundDarkRGB . ';';

        // colorBorderRGB
        $colorBorderRGB = new Energy_Color(energy_option('colorBorder', ''));
        $colorBorderRGB = $colorBorderRGB->rgbString();
        $energy_colors_string .= '--colorBorderRGB:' . $colorBorderRGB . ';';

        // colorBorderDarkRGB
        $colorBorderDarkRGB = new Energy_Color(energy_option('colorBorderDark', ''));
        $colorBorderDarkRGB = $colorBorderDarkRGB->rgbString();
        $energy_colors_string .= '--colorBorderDarkRGB:' . $colorBorderDarkRGB . ';';

        // font
        $fontBody       = '';
        $fontSecondary   = '';

        $huphoria_font_body     = json_decode(energy_option('font_body', '{"font":"","variant": [],"subset":[]}'));
        $huphoria_font_secondary = json_decode(energy_option('font_headings', '{"font":"","variant": [],"subset":[]}'));

        $huphoria_font_body_font = '';
        if (!empty($huphoria_font_body->font)) {
            $huphoria_font_body_font = $huphoria_font_body->font;
        } else {
            $huphoria_font_body_font = 'Arial, Helvetica Neue, Helvetica, sans-serif';
        }
        $fontBody = "--fontBody: \"{$huphoria_font_body_font}\" !important;";

        $huphoria_font_secondary_font = '';
        if (!empty($huphoria_font_secondary->font)) {
            $huphoria_font_secondary_font = $huphoria_font_secondary->font;
        } else {
            $huphoria_font_body_font = 'Playfair Display, serif';
        }
        $fontSecondary = "--fontSecondary: \"{$huphoria_font_secondary_font}\" !important;";

        $energy_colors_string .= $fontBody;
        $energy_colors_string .= $fontSecondary;

        return $energy_colors_string;
    }
endif;
