<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

require_once ENERGY_THEME_PATH . '/inc/customizer/class-mwt-block-heading-control.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/class-mwt-dropdown-category-control.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/class-mwt-google-font-control.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/class-mwt-hidden-customize-control.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/class-mwt-customizer.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/customizer-helpers.php';
require_once ENERGY_THEME_PATH . '/inc/customizer/customizer-woocommerce.php';


//cutsomizer theme settings
if (!function_exists('energy_customizer_settings_array')) :
	function energy_customizer_settings_array()
	{
		return apply_filters(
			'energy_customizer_options',
			//panels -> sections -> settings
			array(
				//////////////////////
				//registering panels//
				//////////////////////
				'panel_theme'                           => array(
					'type'            => 'panel',
					'label'           => esc_html__('Theme options', 'energy'),
					'description'     => esc_html__('Theme specific options', 'energy'),
					'priority'        => 130,
					'active_callback' => '',
				),
				////////////////////////
				//registering sections//
				////////////////////////

				/*
				make sure that you have appropriate panel registered above
				otherwise do not pass 'panel' key
				*/

				//global settings preset. It will change multiple options over 'Theme options' panel
				'section_layout'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Layout', 'energy'),
					'description' => esc_html__('Site layout options', 'energy'),
					'priority'    => 100,
				),
				'section_meta'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Meta', 'energy'),
					'description' => esc_html__('Email, phone, address etc. Appears in various template parts depending from choosen sections layout', 'energy'),
					'priority'    => 100,
				),

				//template parts layout sections
				'section_header'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Header Section', 'energy'),
					'description' => esc_html__('Choose header options', 'energy'),
					'priority'    => 100,
				),
				'section_title'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Title Section', 'energy'),
					'description' => esc_html__('Choose title options. Yoast SEO plugin required for breadcrumbs', 'energy'),
					'priority'    => 100,
				),
				'section_main'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Main Section', 'energy'),
					'description' => esc_html__('Choose main section options', 'energy'),
					'priority'    => 100,
				),
				'section_404'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('404 Section', 'energy'),
					'description' => esc_html__('Choose 404 section options', 'energy'),
					'priority'    => 100,
				),
				'section_footer_top'                    => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Top Footer Section', 'energy'),
					'description' => esc_html__('Choose top footer section options', 'energy'),
					'priority'    => 100,
				),
				'section_footer'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Footer Section', 'energy'),
					'description' => esc_html__('Choose footer options', 'energy'),
					'priority'    => 100,
				),
				'section_copyright'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Copyright Section', 'energy'),
					'description' => esc_html__('Choose copyright options', 'energy'),
					'priority'    => 100,
				),
				'section_blog'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Blog', 'energy'),
					'description' => esc_html__('Blog display options', 'energy'),
					'priority'    => 100,
				),
				'section_blog_post'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Single Post', 'energy'),
					'description' => esc_html__('Single post display options', 'energy'),
					'priority'    => 100,
				),
				'section_fonts'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Fonts', 'energy'),
					'description' => esc_html__('Choose Google fonts', 'energy'),
					'priority'    => 100,
				),
				'section_special_categories'            => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Services, Portfolio, Team', 'energy'),
					'description' => esc_html__('Choose separate categories for displaying Services, Portfolio, Team. They will be removed from regular blog displaying', 'energy'),
					'priority'    => 100,
				),
				'section_animation'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Animation', 'energy'),
					'description' => esc_html__('You can select elements that you want to animate on your page', 'energy'),
					'priority'    => 100,
				),

				///////////////////////
				//registering options//
				///////////////////////
				/*
				make sure that you have registered appropriate section above
				or used default sections as 'section' key's value:
					'title_tagline' - Site Title & Tagline
					'colors' - Colors
					'header_image' - Header Image
					'background_image' - Background Image
					'nav' - Navigation
					'static_front_page' - Static Front Page
				*/
				/*
				available types:
					'checkbox'
					'color'
					'dropdown-pages'
					'file'
					'image'
					'radio'
					'select'
					'text'
					'textarea'
					'url'
					'dropdown-category' - our custom dropdown
					'block-heading' - our custom block heading
					'hidden-option' - our custom hidden option
				make sure that you have provide an array with 'choices' key for 'select' and 'radio':
					'choices' => array(
						'choice_1' => esc_html__( 'Choice 1', 'energy' ),
						...
					)
				*/

				//////////////////////
				//Hidden Demo Number//
				//////////////////////
				'demo_number'                           => array(
					'type'    => 'hidden-option',
					'section' => 'section_presets',
					'default' => energy_option('demo_number', ''),
				),

				//////////
				//colors//
				//////////
				//see _variables.scss
				//see options.php for defaults
				// colorLight
				// colorFont
				// colorFontDark
				// colorBackground
				// colorBackgroundDark
				// colorBorder
				// colorBorderDark
				// colorDark
				// colorDarkGrey
				// colorGrey
				// colorMain
				'colorLight'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Light color', 'energy'),
					'default'     => energy_option('colorLight', '#ffffff'),
					'description' => esc_html__('Using as a background for light sections and as a headings color in inversed sections.', 'energy'),
				),
				'colorFont'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Font color', 'energy'),
					'default'     => energy_option('colorFont', '#8c8c8c'),
					'description' => esc_html__('Using as a font color.', 'energy'),
				),
				'colorFontDark'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark Font color', 'energy'),
					'default'     => energy_option('colorFontDark', '#e6e4e4'),
					'description' => esc_html__('Using as a font color in inversed muted sections.', 'energy'),
				),
				'colorBackground'                       => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Background color', 'energy'),
					'default'     => energy_option('colorBackground', '#f5f5f5'),
					'description' => esc_html__('Background color for elements in light section.', 'energy'),
				),
				'colorBackgroundDark'                       => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark Background color', 'energy'),
					'default'     => energy_option('colorBackground', '#1e1e1e'),
					'description' => esc_html__('Background color for elements in inversed muted section.', 'energy'),
				),
				'colorBorder'                           => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Border color', 'energy'),
					'default'     => energy_option('colorBorder', '#e3e3e3'),
					'description' => esc_html__('Using as a border color.', 'energy'),
				),
				'colorBorderDark'                           => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark Border color', 'energy'),
					'default'     => energy_option('colorBorderDark', '#353535'),
					'description' => esc_html__('Using as a border color in inversed section.', 'energy'),
				),
				'colorDark'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark color', 'energy'),
					'default'     => energy_option('colorDark', '#303030'),
					'description' => esc_html__('Using as a background for inversed sections.', 'energy'),
				),
				'colorDarkGrey'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark Grey color', 'energy'),
					'default'     => energy_option('colorDarkGrey', '#333333'),
					'description' => esc_html__('Using as headings color and a background for inversed sections.', 'energy'),
				),
				'colorGrey'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Grey color', 'energy'),
					'default'     => energy_option('colorGrey', '#a4a4a4'),
					'description' => esc_html__('Using as a background for light muted sections.', 'energy'),
				),
				'colorMain'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Accent color', 'energy'),
					'default'     => energy_option('colorMain', '#fcca03'),
					'description' => esc_html__('Using as a main accent color.', 'energy'),
				),
				'color_meta_icons'                      => array(
					'type'    => 'select',
					'section' => 'colors',
					'label'   => esc_html__('Color for icons in post meta', 'energy'),
					'default' => energy_option('color_meta_icons', ''),
					'choices' => array(
						''                      => esc_html__('Default', 'energy'),
						'meta-icons-main'       => esc_html__('Accent color', 'energy'),
						'meta-icons-border'     => esc_html__('Borders color', 'energy'),
						'meta-icons-dark'       => esc_html__('Dark color', 'energy'),
						'meta-icons-dark-muted' => esc_html__('Darker color', 'energy'),
					),
				),
				'color_skin' => array(
					'type'    => 'select',
					'section' => 'colors',
					'value'   => '',
					'label'   => esc_html__('Choose theme skin', 'energy'),
					'description'    => esc_html__('Select one of predefined skins', 'energy'),
					'choices' => array(
						''  => esc_html__('No skin', 'energy'),
						'skin1' => esc_html__('Geothermal Demo', 'energy'),
						'skin2' => esc_html__('Shop Demo', 'energy'),
					),
				),

				//////////////////////////
				//homepage intro section//
				//////////////////////////

				// static_front_page
				'intro_block_heading'                   => array(
					'type'        => 'block-heading',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section', 'energy'),
					'description' => esc_html__('Set your settings for homepage intro section. Leave blank if not needed.', 'energy'),
				),
				'intro_position'                        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Position', 'energy'),
					'default' => energy_option('intro_position', ''),
					'choices' => array(
						''       => esc_html__('Hidden', 'energy'),
						'before' => esc_html__('Before header', 'energy'),
						'after'  => esc_html__('After header', 'energy'),
					),
				),
				'intro_layout'                          => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Layout', 'energy'),
					'default' => energy_option('intro_layout', ''),
					'choices' => array(
						''             => esc_html__('Background image', 'energy'),
						'image-left'   => esc_html__('Left side image', 'energy'),
						'image-right'  => esc_html__('Right side image', 'energy'),
						'image-top'    => esc_html__('Top image', 'energy'),
						'image-bottom' => esc_html__('Bottom image', 'energy'),
					),
				),
				'intro_fullscreen'                      => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Full Screen Intro Height', 'energy'),
					'default' => energy_option('intro_fullscreen', false),
				),
				'intro_background'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Background', 'energy'),
					'default' => energy_option('intro_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'intro_background_image'                => array(
					'type'    => 'image',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Background Image', 'energy'),
					'default' => energy_option('intro_background_image', ''),
				),
				'intro_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('intro_background_image_cover', false),
				),
				'intro_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('intro_background_image_fixed', false),
				),
				'intro_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('intro_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),
				'intro_image'                => array(
					'type'    => 'image',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Image', 'energy'),
					'default' => energy_option('intro_image', ''),
				),
				'intro_background_image_scale' => array(
					'type'        => 'checkbox',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Make image bigger on large screen', 'energy'),
					'description' => esc_html__('Scale image for large screens', 'energy'),
					'default'     => energy_option('intro_background_image_scale', false),
				),
				'intro_image_absolute' => array(
					'type'        => 'checkbox',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Make image position absolute on large screen', 'energy'),
					'description' => esc_html__('Scale image for large screens (only for left/right side image layout)', 'energy'),
					'default'     => energy_option('intro_image_absolute', false),
				),
				'intro_image_animation'                 => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro image', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_image_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Pre Heading text', 'energy'),
					'default' => energy_option('intro_pre_heading', ''),
				),
				'intro_pre_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading top margin', 'energy'),
					'default' => energy_option('intro_pre_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_pre_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading bottom margin', 'energy'),
					'default' => energy_option('intro_pre_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_pre_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for pre intro heading', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_pre_heading_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Heading text', 'energy'),
					'default' => energy_option('intro_heading', ''),
				),
				'intro_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading top margin', 'energy'),
					'default' => energy_option('intro_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading bottom margin', 'energy'),
					'default' => energy_option('intro_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro heading', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_heading_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_description'                     => array(
					'type'    => 'textarea',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section description text', 'energy'),
					'default' => energy_option('intro_description', ''),
				),
				'intro_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description top margin', 'energy'),
					'default' => energy_option('intro_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description bottom margin', 'energy'),
					'default' => energy_option('intro_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro description text', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_description_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_button_text_first'               => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button Text', 'energy'),
					'default' => energy_option('intro_button_text_first', ''),
				),
				'intro_button_url_first'                => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button URL', 'energy'),
					'default' => energy_option('intro_button_url_first', ''),
				),
				'intro_button_first_animation'          => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for first intro button', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_button_first_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_button_text_second'              => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button Text', 'energy'),
					'default' => energy_option('intro_button_text_second', ''),
				),
				'intro_button_url_second'               => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button URL', 'energy'),
					'default' => energy_option('intro_button_url_second', ''),
				),
				'intro_button_second_animation'         => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for second intro button', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_button_second_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_buttons_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons top margin', 'energy'),
					'default' => energy_option('intro_buttons_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_buttons_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons bottom margin', 'energy'),
					'default' => energy_option('intro_buttons_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section Shortcode', 'energy'),
					'description' => esc_html__('You can put shortcode here. It will appear below Intro description', 'energy'),
					'default'     => energy_option('intro_shortcode', ''),
				),
				'intro_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode top margin', 'energy'),
					'default' => energy_option('intro_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode bottom margin', 'energy'),
					'default' => energy_option('intro_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro shortcode', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('intro_shortcode_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'intro_alignment'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Text Alignment', 'energy'),
					'default' => energy_option('intro_alignment', 'text-left'),
					'choices' => array(
						'text-left'   => esc_html__('Left', 'energy'),
						'text-center' => esc_html__('Centered', 'energy'),
						'text-right'  => esc_html__('Right', 'energy'),
					),
				),
				'intro_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section top padding', 'energy'),
					'default' => energy_option('intro_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'intro_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section bottom padding', 'energy'),
					'default' => energy_option('intro_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'intro_social_links'                    => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Show social links if they set', 'energy'),
					'default' => energy_option('intro_social_links', false),
				),
				'intro_font_size'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section font size', 'energy'),
					'default' => energy_option('intro_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),

				////////
				//logo//
				////////

				//to existing 'title_tagline' section
				'logo_image_inverse'                => array(
					'type'    => 'image',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Inverse', 'energy'),
					'default' => energy_option('logo_image_inverse', ''),
				),
				'logo'                                  => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Layout', 'energy'),
					'default' => energy_option('logo', ''),
					'choices' => array(
						'1' => esc_html__('Left image and right text', 'energy'),
						'2' => esc_html__('Top image and bottom text', 'energy'),
						'3' => esc_html__('Image between text', 'energy'),
					),
				),
				'logo_primary_text'                     => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Primary Text', 'energy'),
					'default' => energy_option('logo_primary_text', ''),
				),
				'logo_text_secondary'                   => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Secondary Text', 'energy'),
					'default' => energy_option('logo_text_secondary', ''),
				),
				'header_top_tall'                       => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional vertical padding', 'energy'),
					'description' => esc_html__('Will make header taller in top position', 'energy'),
					'default'     => energy_option('header_top_tall', false),
				),
				'logo_background'                       => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Background', 'energy'),
					'default' => energy_option('logo_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'logo_padding_horizontal'               => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional horizontal padding', 'energy'),
					'description' => esc_html__('This will add an extra horizontal padding for logo', 'energy'),
					'default'     => energy_option('logo_padding_horizontal', false),
				),

				//////////
				//layout//
				//////////
				'preset'                                => array(
					'type'    => 'select',
					'section' => 'section_presets',
					'label'   => esc_html__('Select global preset of Theme options', 'energy'),
					'default' => energy_option('preset', ''),
					'choices' => array(
						''  => esc_html__('No preset', 'energy'),
						'1' => esc_html__('First preset', 'energy'),
						'2' => esc_html__('Second preset', 'energy'),
					),
				),
				'main_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Global container max width', 'energy'),
					'default' => energy_option('main_container_width', '1170'),
					'choices' => array(
						'1520' => esc_html__('1520px', 'energy'),
						'1170' => esc_html__('1170px', 'energy'),
						'960'  => esc_html__('960px', 'energy'),
						'720'  => esc_html__('720px', 'energy'),
					),
				),
				'blog_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Archive container max width', 'energy'),
					'default' => energy_option('blog_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'energy'),
						'1520' => esc_html__('1520px', 'energy'),
						'1170' => esc_html__('1170px', 'energy'),
						'960'  => esc_html__('960px', 'energy'),
						'720'  => esc_html__('720px', 'energy'),
					),
				),
				'blog_single_container_width'           => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Single post container max width', 'energy'),
					'default' => energy_option('blog_single_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'energy'),
						'1520' => esc_html__('1520px', 'energy'),
						'1170' => esc_html__('1170px', 'energy'),
						'960'  => esc_html__('960px', 'energy'),
						'720'  => esc_html__('720px', 'energy'),
					),
				),
				'boxed'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_layout',
					'label'   => esc_html__('Boxed', 'energy'),
					'default' => energy_option('boxed', false),
				),
				'preloader'                             => array(
					'type'     => 'select',
					'section'  => 'section_layout',
					'label'    => esc_html__('Page preloader', 'energy'),
					'default'  => energy_option('preloader', ''),
					'priority' => 200,
					'choices'  => array(
						''       => esc_html__('No preloader', 'energy'),
						'cover'  => esc_html__('Cover page preloader', 'energy'),
						'corner' => esc_html__('Corner page preloader', 'energy'),
					),
				),
				'box_fade_in'                           => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Fade in page on load', 'energy'),
					'default'  => energy_option('box_fade_in', ''),
					'priority' => 200,
				),
				'totop'                                 => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Enable page \'to top\' button', 'energy'),
					'default'  => energy_option('totop', ''),
					'priority' => 200,
				),
				'assets_min'                            => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Use minified version of CSS files', 'energy'),
					'description' => esc_html__('You can use compressed versions of your static files for best performance', 'energy'),
					'default'     => energy_option('assets_min', ''),
					'priority'    => 200,
				),
				'jquery_to_footer'                      => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Put jQuery script to footer for guest users', 'energy'),
					'description' => esc_html__('If some plugins requires jQuery, it will be loaded in the footer section', 'energy'),
					'default'     => energy_option('jquery_to_footer', ''),
					'priority'    => 200,
				),

				////////
				//meta//
				////////
				'meta_email'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email', 'energy'),
					'default' => energy_option('meta_email', ''),
				),
				'meta_email_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email label', 'energy'),
					'default' => energy_option('meta_email_label', ''),
				),
				'meta_email_2'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email 2', 'energy'),
					'default' => energy_option('meta_email_2', ''),
				),
				'meta_email_2_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email 2 label', 'energy'),
					'default' => energy_option('meta_email_2_label', ''),
				),
				'meta_phone'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone', 'energy'),
					'default' => energy_option('meta_phone', ''),
				),
				'meta_phone_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone label', 'energy'),
					'default' => energy_option('meta_phone_label', ''),
				),
				'meta_phone_2'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone 2', 'energy'),
					'default' => energy_option('meta_phone_2', ''),
				),
				'meta_phone_2_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone 2 label', 'energy'),
					'default' => energy_option('meta_phone_2_label', ''),
				),
				'meta_address'                          => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address', 'energy'),
					'default' => energy_option('meta_address', ''),
				),
				'meta_address_label'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address label', 'energy'),
					'default' => energy_option('meta_address_label', ''),
				),
				'meta_opening_hours'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours', 'energy'),
					'default' => energy_option('meta_opening_hours', ''),
				),
				'meta_opening_hours_label'              => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours label', 'energy'),
					'default' => energy_option('meta_opening_hours_label', ''),
				),
				//social links
				'meta_facebook'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Facebook URL', 'energy'),
					'default' => energy_option('meta_facebook', ''),
				),
				'meta_twitter'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Twitter URL', 'energy'),
					'default' => energy_option('meta_twitter', ''),
				),
				'meta_instagram'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Instagram URL', 'energy'),
					'default' => energy_option('meta_instagram', ''),
				),
				'meta_linkedin'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('LinkedIn URL', 'energy'),
					'default' => energy_option('meta_linkedin', ''),
				),
				'meta_youtube'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('YouTube URL', 'energy'),
					'default' => energy_option('meta_youtube', ''),
				),
				'meta_pinterest'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Pinterest URL', 'energy'),
					'default' => energy_option('meta_pinterest', ''),
				),
				'meta_github'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('GitHub URL', 'energy'),
					'default' => energy_option('meta_github', ''),
				),
				'meta_apple'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('App Store URL', 'energy'),
					'description' => esc_html__('Only for \'Theme Meta\' widget', 'energy'),
					'default' => energy_option('meta_apple', ''),
				),
				'meta_play'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Google Play URL', 'energy'),
					'description' => esc_html__('Only for \'Theme Meta\' widget', 'energy'),
					'default' => energy_option('meta_play', ''),
				),
				'meta_amazon'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Amazon URL', 'energy'),
					'description' => esc_html__('Only for \'Theme Meta\' widget', 'energy'),
					'default' => energy_option('meta_amazon', ''),
				),
				'meta_spotify'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Spotify URL', 'energy'),
					'description' => esc_html__('Only for \'Theme Meta\' widget', 'energy'),
					'default' => energy_option('meta_spotify', ''),
				),
				'meta_soundcloud'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('SoundCloud URL', 'energy'),
					'description' => esc_html__('Only for \'Theme Meta\' widget', 'energy'),
					'default' => energy_option('meta_soundcloud', ''),
				),

				//////////
				//header//
				//////////

				//header image options
				//section 'header_image'
				'header_image_background_image_cover'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('header_image_background_image_cover', false),
				),
				'header_image_background_image_fixed'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('header_image_background_image_fixed', false),
				),
				'header_image_background_image_overlay' => array(
					'type'    => 'select',
					'section' => 'header_image',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('header_image_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				//header
				'header'                                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Layout', 'energy'),
					'default' => energy_option('header', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'energy'),
						'1' => esc_html__('Logo, menu and button', 'energy'),
						'2' => esc_html__('Top logo and meta, bottom menu', 'energy'),
						'3' => esc_html__('Top logo, login/register, wishlist, sopping cart and bottom menu', 'energy'),
					),
				),
				'header_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header', 'energy'),
					'default' => energy_option('header_fluid', true),
				),
				'header_background'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Background', 'energy'),
					'default' => energy_option('header_background', 'l'),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'header_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_header',
					'label'   => esc_html__('Background Image', 'energy'),
					'default' => energy_option('header_background_image', ''),
				),
				'header_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('header_background_image_cover', false),
				),
				'header_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('header_background_image_fixed', false),
				),
				'header_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('header_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),
				'header_toplogo'                         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Toplogo Section in Header', 'energy'),
					'description' => esc_html__('If header layout contains it', 'energy'),
					'default' => energy_option('header_toplogo', false),
				),
				'header_toplogo_background'             => array(
					'type'        => 'select',
					'section'     => 'section_header',
					'label'       => esc_html__('Header Logo Section background', 'energy'),
					'default'     => energy_option('header_toplogo_background', 'l'),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'header_toplogo_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Logo Section font size', 'energy'),
					'default' => energy_option('header_toplogo_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'header_meta'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show meta in Header', 'energy'),
					'default' => energy_option('header_meta', false),
				),
				'header_align_main_menu'                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Align main menu', 'energy'),
					'default' => energy_option('header_align_main_menu', true),
					'choices' => array(
						''            => esc_html__('Default', 'energy'),
						'menu-right'  => esc_html__('Right', 'energy'),
						'menu-center' => esc_html__('Center', 'energy'),
					),
				),
				// TODO why commented out?
				'header_toggler_menu_main'              => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Put main menu mobile toggler in header', 'energy'),
					'default' => energy_option('header_toggler_menu_main', true),
				),
				'header_absolute_home_page'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Position absolute header (Home Page)', 'energy'),
					'default' => energy_option('header_absolute_home_page', false),
				),
				'header_absolute'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Position absolute header', 'energy'),
					'default' => energy_option('header_absolute', false),
				),
				'header_transparent'                    => array(
					'type'        => 'checkbox',
					'section'     => 'section_header',
					'label'       => esc_html__('Remove background color', 'energy'),
					'description' => esc_html__('Make header transparent', 'energy'),
					'default'     => energy_option('header_transparent', false),
				),
				'header_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Top border', 'energy'),
					'default' => energy_option('header_border_top', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'header_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Bottom border', 'energy'),
					'default' => energy_option('header_border_bottom', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'header_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header section font size', 'energy'),
					'default' => energy_option('header_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'header_sticky'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Sticky Header', 'energy'),
					'default' => energy_option('header_sticky', false),
					'choices' => array(
						''                 => esc_html__('Disabled', 'energy'),
						'always-sticky'    => esc_html__('Always visible', 'energy'),
						'scrolltop-sticky' => esc_html__('Visible on scrolling to top', 'energy'),
					),
				),
				'header_button_text'                         => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Header button text', 'energy'),
					'default' => energy_option('header_button_text', ''),
				),
				'header_button_url'                         => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Header button URL', 'energy'),
					'default' => energy_option('header_button_url', ''),
				),
				'header_search'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Show Search', 'energy'),
					'default' => energy_option('header_search', ''),
					'choices' => array(
						''       => esc_html__('Disabled', 'energy'),
						'button' => esc_html__('Search Modal button', 'energy'),
						'button2' => esc_html__('Search Modal button alt', 'energy'),
						'form'   => esc_html__('Search Form', 'energy'),
					),
				),
				//topline in header
				'header_topline_options_heading'        => array(
					'type'        => 'block-heading',
					'section'     => 'section_header',
					'label'       => esc_html__('Header topline options', 'energy'),
					'description' => esc_html__('You need to fill theme meta options to show them in header topline.', 'energy'),
				),
				'topline'                               => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline Layout', 'energy'),
					'default' => energy_option('topline', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'energy'),
						'1' => esc_html__('Left social icons and right meta', 'energy'),
					),
				),
				'topline_fluid'                         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header Topline', 'energy'),
					'default' => energy_option('topline_fluid', true),
				),
				'topline_background'                    => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Topline Background', 'energy'),
					'default' => energy_option('topline_background', 'l'),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'topline_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline section font size', 'energy'),
					'default' => energy_option('topline_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'topline_before_social_word'               => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Text before social icons', 'energy'),
					'default' => energy_option('topline_before_social_word', ''),
				),
				'topline_meta_opening_hours'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Opening Hours', 'energy'),
					'default' => energy_option('topline_meta_opening_hours', false),
				),
				'topline_meta_mail'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Mail', 'energy'),
					'default' => energy_option('topline_meta_mail', false),
				),
				'topline_meta_phone'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Phone', 'energy'),
					'default' => energy_option('topline_meta_phone', false),
				),
				'topline_meta_address'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Address', 'energy'),
					'default' => energy_option('topline_meta_address', false),
				),

				'header_logo_background'                      => array(
					'type'    => 'image',
					'section' => 'section_header',
					'label'   => esc_html__('Logo modal Background image', 'energy'),
					'default' => energy_option('header_logo_background', ''),
				),

				/////////
				//title//
				/////////
				'title'                                 => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Layout', 'energy'),
					'default' => energy_option('title', '1'),
					'choices' => array(
						'1' => esc_html__('Title above breadcrumbs', 'energy'),
						'2' => esc_html__('Title above breadcrumbs centered', 'energy'),
						'3' => esc_html__('Title inline with breadcrumbs', 'energy'),
						'4' => esc_html__('Title above breadcrumbs bottom', 'energy'),
					),
				),
				'title_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Full Width Title', 'energy'),
					'default' => energy_option('title_fluid', true),
				),
				'title_show_title'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show title in title section instead of content area', 'energy'),
					'default' => energy_option('title_show_title', ''),
				),
				'title_show_breadcrumbs'                => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show breadcrumbs (Yoast SEO or Rank Math plugins required)', 'energy'),
					'default' => energy_option('title_show_breadcrumbs', true),
				),
				'title_background'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Background', 'energy'),
					'default' => energy_option('title_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'title_border_top'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top border', 'energy'),
					'default' => energy_option('title_border_top', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'title_border_bottom'                   => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom border', 'energy'),
					'default' => energy_option('title_border_bottom', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'title_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('title_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'title_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('title_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'title_font_size'                       => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title section font size', 'energy'),
					'default' => energy_option('title_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'title_hide_taxonomy_name'              => array(
					'type'        => 'checkbox',
					'section'     => 'section_title',
					'label'       => esc_html__('Hide taxonomy name', 'energy'),
					'description' => esc_html__('You can hide a taxonomy name on taxonomy archives page', 'energy'),
					'default'     => energy_option('title_hide_taxonomy_name', false),
				),
				'title_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_title',
					'label'   => esc_html__('Title Section Background Image', 'energy'),
					'default' => energy_option('title_background_image', ''),
				),
				'title_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('title_background_image_cover', false),
				),
				'title_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('title_background_image_fixed', false),
				),
				'title_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('title_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				////////////////
				//main section//
				////////////////
				'main_sidebar_width'                    => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar width on big screens', 'energy'),
					'default' => energy_option('main_sidebar_width', ''),
					'choices' => array(
						'33' => esc_html__('Default - 1/3 - 33%', 'energy'),
						'25' => esc_html__('1/4 - 25%', 'energy'),
						'30' => esc_html__('30% - 70%', 'energy'),
					),
				),
				'main_gap_width'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar gap width', 'energy'),
					'default' => energy_option('main_gap_width', ''),
					'choices' => array(
						''  => esc_html__('Default', 'energy'),
						'1' => esc_html__('1em', 'energy'),
						'2' => esc_html__('2em', 'energy'),
						'3' => esc_html__('3em', 'energy'),
						'4' => esc_html__('4em', 'energy'),
					),
				),
				'main_sidebar_sticky'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_main',
					'label'   => esc_html__('Sticky sidebar', 'energy'),
					'default' => energy_option('main_sidebar_sticky', false),
				),
				'main_extra_padding_top'                => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('main_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'main_extra_padding_bottom'             => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('main_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'main_font_size'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Main section font size', 'energy'),
					'default' => energy_option('main_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'sidebar_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar font size', 'energy'),
					'default' => energy_option('sidebar_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'main_version'             => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Theme Version', 'energy'),
					'description' => esc_html__('Light or dark version (not working for Elementor pages)', 'energy'),
					'default' => energy_option('main_version', ''),
					'choices' => array(
						'l' => esc_html__('Light', 'energy'),
						'i m'  => esc_html__('Dark', 'energy'),
					),
				),
				///////
				//404//
				///////
				'404_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_404',
					'label'   => esc_html__('404', 'energy'),
					'default' => energy_option('404_heading', ''),
				),
				'404_text_bottom_line'                         => array(
					'type'    => 'text',
					'section' => 'section_404',
					'label'   => esc_html__('404 Text', 'energy'),
					'default' => energy_option('404_text_bottom_line', ''),
				),
				'404_background'                      => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('404 Page Background', 'energy'),
					'default' => energy_option('404_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'404_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_404',
					'label'   => esc_html__('404 Page Background Image', 'energy'),
					'default' => energy_option('404_background_image', ''),
				),
				'404_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('404_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),
				'404_extra_padding_top'                => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('404_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
						'pt-11' => esc_html__('11em', 'energy'),
					),
				),
				'404_extra_padding_bottom'             => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('404_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
						'pb-11' => esc_html__('11em', 'energy'),
					),
				),
				//////////////
				//footer_top//
				//////////////
				'footer_top'                                => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Layout', 'energy'),
					'default' => energy_option('footer_top', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'energy'),
						'1' => esc_html__('Single column', 'energy'),
						'2' => esc_html__('Single column centered', 'energy'),
						'3' => esc_html__('Two columns', 'energy'),
						'4' => esc_html__('Four columns centered (widgets included)', 'energy'),
					),
				),
				'footer_top_layout_gap'                     => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Widgets gap', 'energy'),
					'description' => esc_html__('Used only for \'Three columns centered\' layouts', 'energy'),
					'default'     => energy_option('footer_top_layout_gap', ''),
					'choices'     => energy_get_feed_layout_gap_options(),
				),
				'footer_top_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Full Width Section', 'energy'),
					'default' => energy_option('footer_top_fluid', false),
				),
				'footer_top_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading text', 'energy'),
					'default' => energy_option('footer_top_heading', ''),
				),
				'footer_top_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading top margin', 'energy'),
					'default' => energy_option('footer_top_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading bottom margin', 'energy'),
					'default' => energy_option('footer_top_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top heading', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('footer_top_heading_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'footer_top_description'                     => array(
					'type'    => 'textarea',
					'section' => 'section_footer_top',
					'label'   => esc_html__('description text', 'energy'),
					'default' => energy_option('footer_top_description', ''),
				),
				'footer_top_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description top margin', 'energy'),
					'default' => energy_option('footer_top_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description bottom margin', 'energy'),
					'default' => energy_option('footer_top_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top description text', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('footer_top_description_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'footer_top_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Shortcode', 'energy'),
					'description' => esc_html__('You can put shortcode here. It will appear below description', 'energy'),
					'default'     => energy_option('footer_top_shortcode', ''),
				),
				'footer_top_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode top margin', 'energy'),
					'default' => energy_option('footer_top_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode bottom margin', 'energy'),
					'default' => energy_option('footer_top_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for shortcode', 'energy'),
					'description' => esc_html__('Animation should be enabled', 'energy'),
					'default'     => energy_option('footer_top_shortcode_animation', ''),
					'choices'     => energy_get_animation_options(),
				),
				'footer_top_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background', 'energy'),
					'default' => energy_option('footer_top_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'footer_top_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top border', 'energy'),
					'default' => energy_option('footer_top_border_top', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_top_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom border', 'energy'),
					'default' => energy_option('footer_top_border_bottom', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_top_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('footer_top_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_top_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('footer_top_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_top_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Font Size', 'energy'),
					'default' => energy_option('footer_top_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'footer_top_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background Image', 'energy'),
					'default' => energy_option('footer_top_background_image', ''),
				),
				'footer_top_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('footer_top_background_image_cover', false),
				),
				'footer_top_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('footer_top_background_image_fixed', false),
				),
				'footer_top_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('footer_top_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				//footer top bottom section
				'footer_top_bottom_section_options_heading'        => array(
					'type'        => 'block-heading',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Bottom Section options', 'energy'),
					'description' => esc_html__('You need select \'Four columns centered (widgets included)\' layout to add this section after top footer section.', 'energy'),
				),
				'footer_top_bottom_section'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Show Bottom Section', 'energy'),
					'default' => energy_option('footer_top_bottom_section', false),
				),
				'footer_top_bottom_section_home_page_only'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Show only on Home page', 'energy'),
					'default' => energy_option('footer_top_bottom_section_home_page_only', false),
				),
				'footer_top_bottom_section_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Full Width Section', 'energy'),
					'default' => energy_option('footer_top_bottom_section_fluid', false),
				),
				'footer_top_bottom_section_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading text', 'energy'),
					'default' => energy_option('footer_top_bottom_section_heading', ''),
				),
				'footer_top_bottom_section_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading bottom margin', 'energy'),
					'default' => energy_option('footer_top_bottom_section_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_bottom_section_description'                     => array(
					'type'    => 'textarea',
					'section' => 'section_footer_top',
					'label'   => esc_html__('description text', 'energy'),
					'default' => energy_option('footer_top_bottom_section_description', ''),
				),
				'footer_top_bottom_section_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description bottom margin', 'energy'),
					'default' => energy_option('footer_top_bottom_section_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_bottom_section_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Shortcode', 'energy'),
					'description' => esc_html__('You can put shortcode here. It will appear below description', 'energy'),
					'default'     => energy_option('footer_top_bottom_section_shortcode', ''),
				),
				'footer_top_bottom_section_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background', 'energy'),
					'default' => energy_option('footer_top_bottom_section_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'footer_top_bottom_section_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top border', 'energy'),
					'default' => energy_option('footer_top_bottom_section_border_top', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_top_bottom_section_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom border', 'energy'),
					'default' => energy_option('footer_top_bottom_section_border_bottom', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_top_bottom_section_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('footer_top_bottom_section_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_top_bottom_section_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('footer_top_bottom_section_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_top_bottom_section_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Font Size', 'energy'),
					'default' => energy_option('footer_top_bottom_section_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'footer_top_bottom_section_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background Image', 'energy'),
					'default' => energy_option('footer_top_bottom_section_background_image', ''),
				),
				'footer_top_bottom_section_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('footer_top_bottom_section_background_image_cover', false),
				),
				'footer_top_bottom_section_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('footer_top_bottom_section_background_image_fixed', false),
				),
				'footer_top_bottom_section_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('footer_top_bottom_section_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				//////////
				//footer//
				//////////
				'footer'                                => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Layout', 'energy'),
					'default' => energy_option('footer', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'energy'),
						'1' => esc_html__('Equal columns', 'energy'),
						'2' => esc_html__('First one half column', 'energy'),
						'3' => esc_html__('Second one half column', 'energy'),
						'4' => esc_html__('Full Width', 'energy'),
						'5' => esc_html__('Full Width centered', 'energy'),
						'6' => esc_html__('Full Width centered narrow', 'energy'),
						'7' => esc_html__('Second and third narrow columns', 'energy'),
						'8' => esc_html__('Full Width centered (top corner body)', 'energy'),
						'9' => esc_html__('First column 75%', 'energy'),
						'10' => esc_html__('Equal columns (top border body)', 'energy'),
						'11' => esc_html__('First one half column alt', 'energy'),
					),
				),
				'footer_layout_gap'                     => array(
					'type'        => 'select',
					'section'     => 'section_footer',
					'label'       => esc_html__('Footer widgets gap', 'energy'),
					'description' => esc_html__('Used only for multiple columns layouts', 'energy'),
					'default'     => energy_option('footer_layout_gap', ''),
					'choices'     => energy_get_feed_layout_gap_options(),
				),
				'footer_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Full Width Footer', 'energy'),
					'default' => energy_option('footer_fluid', false),
				),
				'footer_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Background', 'energy'),
					'default' => energy_option('footer_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'footer_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top border', 'energy'),
					'default' => energy_option('footer_border_top', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom border', 'energy'),
					'default' => energy_option('footer_border_bottom', ''),
					'choices' => energy_customizer_borders_array(),
				),
				'footer_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('footer_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('footer_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'footer_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Font Size', 'energy'),
					'default' => energy_option('footer_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'footer_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Background Image', 'energy'),
					'default' => energy_option('footer_background_image', ''),
				),
				'footer_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('footer_background_image_cover', false),
				),
				'footer_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('footer_background_image_fixed', false),
				),
				'footer_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('footer_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				/////////////
				//copyright//
				/////////////
				'copyright'                             => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Layout', 'energy'),
					'default' => energy_option('copyright', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'energy'),
						'1' => esc_html__('Only copyright (centered)', 'energy'),
						'2' => esc_html__('Only copyright (left aligned)', 'energy'),
						'3' => esc_html__('Left copyright and right menu', 'energy'),
						'4' => esc_html__('Left copyright and right social icons', 'energy'),
						'5' => esc_html__('Left copyright, menu and right social icons', 'energy'),
						'6' => esc_html__('Top copyright and bottom social icons (centered)', 'energy'),
						'7' => esc_html__('Left copyright and right social menu', 'energy'),
					),
				),
				'copyright_text'                        => array(
					'type'        => 'textarea',
					'section'     => 'section_copyright',
					'label'       => esc_html__('Copyright text', 'energy'),
					'description' => esc_html__('Site name will be displayed, if leave empty', 'energy'),
					'default'     => energy_option('copyright_text', ''),
				),
				'copyright_fluid'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Full Width copyright', 'energy'),
					'default' => energy_option('copyright_fluid', true),
				),
				'copyright_background'                  => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Background', 'energy'),
					'default' => energy_option('copyright_background', ''),
					'choices' => energy_customizer_backgrounds_array(),
				),
				'copyright_extra_padding_top'           => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Top padding', 'energy'),
					'default' => energy_option('copyright_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pt-0'  => esc_html__('0', 'energy'),
						'pt-1'  => esc_html__('1em', 'energy'),
						'pt-2'  => esc_html__('2em', 'energy'),
						'pt-3'  => esc_html__('3em', 'energy'),
						'pt-4'  => esc_html__('4em', 'energy'),
						'pt-5'  => esc_html__('5em', 'energy'),
						'pt-6'  => esc_html__('6em', 'energy'),
						'pt-7'  => esc_html__('7em', 'energy'),
						'pt-8'  => esc_html__('8em', 'energy'),
						'pt-9'  => esc_html__('9em', 'energy'),
						'pt-10' => esc_html__('10em', 'energy'),
					),
				),
				'copyright_extra_padding_bottom'        => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Bottom padding', 'energy'),
					'default' => energy_option('copyright_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'energy'),
						'pb-0'  => esc_html__('0', 'energy'),
						'pb-1'  => esc_html__('1em', 'energy'),
						'pb-2'  => esc_html__('2em', 'energy'),
						'pb-3'  => esc_html__('3em', 'energy'),
						'pb-4'  => esc_html__('4em', 'energy'),
						'pb-5'  => esc_html__('5em', 'energy'),
						'pb-6'  => esc_html__('6em', 'energy'),
						'pb-7'  => esc_html__('7em', 'energy'),
						'pb-8'  => esc_html__('8em', 'energy'),
						'pb-9'  => esc_html__('9em', 'energy'),
						'pb-10' => esc_html__('10em', 'energy'),
					),
				),
				'copyright_font_size'                   => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright section font size', 'energy'),
					'default' => energy_option('copyright_font_size', ''),
					'choices' => energy_customizer_font_size_array(),
				),
				'copyright_background_image'            => array(
					'type'    => 'image',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Section Background Image', 'energy'),
					'default' => energy_option('copyright_background_image', ''),
				),
				'copyright_background_image_cover'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Cover background image', 'energy'),
					'default' => energy_option('copyright_background_image_cover', false),
				),
				'copyright_background_image_fixed'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Fixed background image', 'energy'),
					'default' => energy_option('copyright_background_image_fixed', false),
				),
				'copyright_background_image_overlay'    => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Overlay for background image', 'energy'),
					'default' => energy_option('footer_background_image_overlay', ''),
					'choices' => energy_customizer_background_overlay_array(),
				),

				/////////
				//fonts//
				/////////
				'font_body_heading'                     => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Body font options', 'energy'),
					'description' => esc_html__('You can use CMD (CTRL) key for select multiple variants and subsets.', 'energy'),
				),
				'font_body'                             => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Body Custom Font', 'energy'),
					'default' => energy_option('font_body', '{"font":"","variant": [],"subset":[]}'),
				),
				'font_headings_heading'                 => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Secondary font options', 'energy'),
					'description' => esc_html__('You can use CMD (CTRL) key for select multiple variants and subsets.', 'energy'),
				),
				'font_headings'                         => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Secondary Custom Font', 'energy'),
					'default' => energy_option('font_headings', '{"font":"","variant": [],"subset":[]}'),
				),

				////////
				//blog//
				////////
				'blog_layout'                           => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog feed layout', 'energy'),
					'default' => energy_option('blog_layout', ''),
					'choices' => energy_get_feed_layout_options(),
				),
				'blog_sidebar_position'                 => array(
					'type'        => 'radio',
					'section'     => 'section_blog',
					'label'       => esc_html__('Blog sidebar position', 'energy'),
					'description' => esc_html__('Can be overriden for certain category on category edit page', 'energy'),
					'default'     => energy_option('blog_sidebar_position', 'right'),
					'choices'     => energy_get_sidebar_position_options(),
				),
				'blog_page_name'                        => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog page name. Default: \'Blog\'', 'energy'),
					'default' => energy_option('blog_page_name', esc_html__('Blog', 'energy')),
				),
				'blog_show_full_text'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show full text instead of excerpt', 'energy'),
					'default' => energy_option('blog_show_full_text', false),
				),
				'blog_excerpt_length'                   => array(
					'type'        => 'number',
					'section'     => 'section_blog',
					'label'       => esc_html__('Custom excerpt length', 'energy'),
					'description' => esc_html__('Words amount', 'energy'),
					'default'     => energy_option('blog_excerpt_length', 40),
				),
				'blog_read_more_text'                   => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('\'Read More\' text. Leave blank to hide', 'energy'),
					'default' => energy_option('blog_read_more_text', ''),
				),
				'blog_hide_taxonomy_type_name'          => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog',
					'label'       => esc_html__('Hide taxonomy type name in title section', 'energy'),
					'default'     => energy_option('blog_hide_taxonomy_type_name', false),
					'description' => esc_html__('You can hide taxonomy name (ex. \'Tag:\') word if you want.', 'energy'),
				),
				'blog_meta_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Post meta options', 'energy'),
					'description' => esc_html__('Select what post meta you want to show in blog feed. Not all layouts will show post meta even if it is checked.', 'energy'),
				),
				'blog_hide_meta_icons'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Hide icons in the post meta', 'energy'),
					'default' => energy_option('blog_hide_meta_icons', false),
				),
				'blog_show_author'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author', 'energy'),
					'default' => energy_option('blog_show_author', true),
				),
				'blog_show_author_avatar'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author avatar', 'energy'),
					'default' => energy_option('blog_show_author_avatar', false),
				),
				'blog_before_author_word'               => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before author', 'energy'),
					'default' => energy_option('blog_before_author_word', ''),
				),
				'blog_show_date'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show date', 'energy'),
					'default' => energy_option('blog_show_date', true),
				),
				'blog_before_date_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before date', 'energy'),
					'default' => energy_option('blog_before_date_word', ''),
				),
				'blog_show_categories'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show categories', 'energy'),
					'default' => energy_option('blog_show_categories', true),
				),
				'blog_before_categories_word'           => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before categories', 'energy'),
					'default' => energy_option('blog_before_categories_word', ''),
				),
				'blog_show_tags'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show tags', 'energy'),
					'default' => energy_option('blog_show_tags', true),
				),
				'blog_before_tags_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before tags', 'energy'),
					'default' => energy_option('blog_before_tags_word', ''),
				),
				'blog_show_views'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show views', 'energy'),
					'default' => energy_option('blog_show_views', true),
				),
				'blog_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before views', 'energy'),
					'default' => energy_option('blog_before_views_word', ''),
				),
				'blog_show_likes'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show likes', 'energy'),
					'default' => energy_option('blog_show_likes', true),
				),
				'blog_before_likes_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before likes', 'energy'),
					'default' => energy_option('blog_before_likes_word', ''),
				),
				'blog_show_comments_link'               => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Show comments count', 'energy'),
					'default' => energy_option('blog_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'energy'),
						'text'   => esc_html__('Comments number with text', 'energy'),
						'number' => esc_html__('Only comments number', 'energy'),
					),
				),
				'blog_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Share buttons', 'energy'),
				),
				'blog_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button facebook', 'energy'),
					'default' => energy_option('blog_share_facebook', true),
				),
				'blog_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button twitter', 'energy'),
					'default' => energy_option('blog_share_twitter', true),
				),
				'blog_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button telegram', 'energy'),
					'default' => energy_option('blog_share_telegram', true),
				),
				'blog_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button pinterest', 'energy'),
					'default' => energy_option('blog_share_pinterest', true),
				),
				'blog_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button linkedin', 'energy'),
					'default' => energy_option('blog_share_linkedin', true),
				),

				////////
				//post//
				////////
				//same as blog (except post nav and author bio)
				'blog_single_sidebar_position'          => array(
					'type'        => 'radio',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Blog post sidebar position', 'energy'),
					'description' => esc_html__('Can be overriden for certain post by selecting appropriate post template', 'energy'),
					'default'     => energy_option('blog_single_sidebar_position', 'right'),
					'choices'     => energy_get_sidebar_position_options(),
				),
				'blog_single_show_author_bio'           => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Show Author Bio', 'energy'),
					'description' => esc_html__('You need to fill Biographical Info to display author bio', 'energy'),
					'default'     => energy_option('blog_single_show_author_bio', true),
				),
				'blog_single_author_bio_about_word'     => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'About author\' intro word', 'energy'),
					'description' => esc_html__('Leave blank if not needed', 'energy'),
					'default'     => energy_option('blog_single_author_bio_about_word', ''),
				),
				'blog_single_post_nav_heading'          => array(
					'type'    => 'block-heading',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts navigation settings', 'energy'),
				),
				'blog_single_post_nav'                  => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts Navigation', 'energy'),
					'default' => energy_option('blog_single_post_nav', ''),
					'choices' => array(
						''          => esc_html__('Disabled', 'energy'),
						'title'     => esc_html__('Only title', 'energy'),
						'arrow'     => esc_html__('Only next/previous word', 'energy'),
						'bg'        => esc_html__('Background featured image', 'energy'),
						'thumbnail' => esc_html__('Thumbnail featured image', 'energy'),
					),
				),
				'blog_single_post_nav_word_prev'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Previous post\' word', 'energy'),
					'description' => esc_html__('Post navigation has to be chosen', 'energy'),
					'default'     => energy_option('blog_single_post_nav_word_prev', esc_html__('Prev', 'energy')),
				),
				'blog_single_post_nav_word_next'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Next post\' word', 'energy'),
					'description' => esc_html__('Post navigation has to be chosen', 'energy'),
					'default'     => energy_option('blog_single_post_nav_word_next', esc_html__('Next', 'energy')),
				),
				'blog_single_related_posts_heading'     => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts settings', 'energy'),
					'description' => esc_html__('Related posts are based on post tags', 'energy'),
				),
				'blog_single_related_posts'             => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Related posts', 'energy'),
					'default' => energy_option('blog_single_related_posts', ''),
					'choices' => array(
						''                => esc_html__('Hidden', 'energy'),
						'list'            => esc_html__('Simple list', 'energy'),
						'list-thumbnails' => esc_html__('List with thumbnails', 'energy'),
						'grid'            => esc_html__('Posts grid', 'energy'),
					),
				),
				'blog_single_related_posts_title'       => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts title', 'energy'),
					'default'     => energy_option('blog_single_related_posts_title', ''),
					'description' => esc_html__('Related posts heading title', 'energy'),
				),
				'blog_single_related_posts_number'      => array(
					'type'        => 'number',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts number', 'energy'),
					'default'     => energy_option('blog_single_related_posts_number', ''),
					'description' => esc_html__('Related posts layout has to be chosen', 'energy'),
				),
				'blog_single_meta_options_heading'      => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Single post meta options', 'energy'),
					'description' => esc_html__('Select what post meta you want to show in single post. Not all layouts will show post meta even if it is checked.', 'energy'),
				),
				'blog_single_hide_meta_icons'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Hide icons in the post meta', 'energy'),
					'default' => energy_option('blog_single_hide_meta_icons', false),
				),
				'blog_single_hide_meta_categories_icons'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Hide icons in post meta categories', 'energy'),
					'default' => energy_option('blog_single_hide_meta_categories_icons', false),
				),
				'blog_single_show_author'               => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show author', 'energy'),
					'default' => energy_option('blog_single_show_author', true),
				),
				'blog_single_show_author_avatar'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show author avatar', 'energy'),
					'default' => energy_option('blog_single_show_author_avatar', false),
				),
				'blog_single_before_author_word'        => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before author', 'energy'),
					'default' => energy_option('blog_single_before_author_word', ''),
				),
				'blog_single_show_date'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show date', 'energy'),
					'default' => energy_option('blog_single_show_date', true),
				),
				'blog_single_before_date_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before date', 'energy'),
					'default' => energy_option('blog_single_before_date_word', ''),
				),
				'blog_single_show_categories'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show categories', 'energy'),
					'default' => energy_option('blog_single_show_categories', true),
				),
				'blog_single_before_categories_word'    => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before categories', 'energy'),
					'default' => energy_option('blog_single_before_categories_word', ''),
				),
				'blog_single_show_tags'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show tags', 'energy'),
					'default' => energy_option('blog_single_show_tags', true),
				),
				'blog_single_before_tags_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before tags', 'energy'),
					'default' => energy_option('blog_single_before_tags_word', ''),
				),
				'blog_single_show_views'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show views', 'energy'),
					'default' => energy_option('blog_single_show_views', true),
				),
				'blog_single_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before views', 'energy'),
					'default' => energy_option('blog_single_before_views_word', ''),
				),
				'blog_single_show_likes'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show likes', 'energy'),
					'default' => energy_option('blog_single_show_likes', true),
				),
				'blog_single_show_comments_link'        => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show comments count', 'energy'),
					'default' => energy_option('blog_single_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'energy'),
						'text'   => esc_html__('Comments number with text', 'energy'),
						'number' => esc_html__('Only comments number', 'energy'),
					),
				),
				'blog_single_comments_title_reply'      => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Comments form title', 'energy'),
					'default' => energy_option('blog_single_comments_title_reply', ''),
				),
				'blog_single_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Share buttons', 'energy'),
				),
				'blog_single_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button facebook', 'energy'),
					'default' => energy_option('blog_single_share_facebook', true),
				),
				'blog_single_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button twitter', 'energy'),
					'default' => energy_option('blog_single_share_twitter', true),
				),
				'blog_single_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button telegram', 'energy'),
					'default' => energy_option('blog_single_share_telegram', true),
				),
				'blog_single_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button pinterest', 'energy'),
					'default' => energy_option('blog_single_share_pinterest', true),
				),
				'blog_single_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button linkedin', 'energy'),
					'default' => energy_option('blog_single_share_linkedin', true),
				),

				///////////////
				// animation //
				///////////////
				'animation_enabled'                     => array(
					'type'        => 'checkbox',
					'section'     => 'section_animation',
					'label'       => esc_html__('Enable CSS animation for elements', 'energy'),
					'default'     => energy_option('animation_enabled', false),
					'description' => esc_html__('Please note that additional JS file (2 kB) and CSS file (25 kB) will be loaded if enabled', 'energy'),
				),
				'animation_sidebar_widgets'             => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for main sidebar widgets', 'energy'),
					'description' => esc_html__('If you want to animate main sidebar widgets - select one of predefined animation type', 'energy'),
					'default'     => energy_option('animation_sidebar_widgets', ''),
					'choices'     => energy_get_animation_options(),
				),
				'animation_footer_top_widgets'              => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for footer top widgets', 'energy'),
					'description' => esc_html__('If you want to animate footer top widgets - select one of predefined animation type', 'energy'),
					'default'     => energy_option('animation_footer_top_widgets', ''),
					'choices'     => energy_get_animation_options(),
				),
				'animation_footer_widgets'              => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for footer widgets', 'energy'),
					'description' => esc_html__('If you want to animate footer widgets - select one of predefined animation type', 'energy'),
					'default'     => energy_option('animation_footer_widgets', ''),
					'choices'     => energy_get_animation_options(),
				),
				'animation_feed_posts'                  => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts in posts feed', 'energy'),
					'description' => esc_html__('If you want to animate blog feed posts - select one of predefined animation type', 'energy'),
					'default'     => energy_option('animation_feed_posts', ''),
					'choices'     => energy_get_animation_options(),
				),
				'animation_feed_posts_thumbnail'        => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts thumbnails in posts feed', 'energy'),
					'description' => esc_html__('If you want to animate blog feed posts thumbnail - select one of predefined animation type', 'energy'),
					'default'     => energy_option('animation_feed_posts_thumbnail', ''),
					'choices'     => energy_get_animation_options(),
				),
			) //options array
		); //apply_filters
	}
endif;

//init customizer with 'energy_customizer_settings_array' settings filter
add_action('init', 'energy_init_customizer_class');
if (!function_exists('energy_init_customizer_class')) :
	function energy_init_customizer_class()
	{
		$energy_customizer = new Energy_Customizer(
			energy_customizer_settings_array()
		);
	}
endif;
