<?php

/**
 * The 404 page template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$energy_404_heading          = energy_option('404_heading', '');
$energy_404_text_bottom_line = energy_option('404_text_bottom_line', '');
$energy_background           = energy_option('404_background', '');
$energy_background_image     = energy_option('404_background_image', '');
$energy_overlay 		       = energy_option('404_background_image_overlay', '');

$energy_extra_padding_top    = energy_option('404_extra_padding_top', '');
$energy_extra_padding_bottom = energy_option('404_extra_padding_bottom', '');

if (!empty($energy_overlay)) {
	$energy_overlay = ' background-overlay ' . $energy_overlay;
}

get_header();

?>
<div id="main" class="main section-404 <?php echo esc_attr($energy_background . ' background-cover cover-center ' . $energy_overlay); ?>" <?php echo (!empty($energy_background_image)) ? 'style="background-image: url(' . esc_url($energy_background_image) . ');"' : ''; ?>>
	<div class="container <?php echo esc_attr($energy_extra_padding_top . ' ' . $energy_extra_padding_bottom); ?>">
		<main>
			<div id="layout" class="text-center">
				<div class="content-wrap">
					<div class="text-404">
						<?php echo (!empty($energy_404_heading)) ? esc_html($energy_404_heading) : esc_html_e("404", 'energy'); ?>
					</div>
					<h3>
						<?php echo (!empty($energy_404_text_bottom_line)) ? esc_html($energy_404_text_bottom_line) : esc_html_e("Oops, page not found!", 'energy'); ?>
					</h3>
					<p>
						<?php esc_html_e('You can search what interested:', 'energy'); ?>
					</p>
					<div class="widget widget_search">
						<?php get_search_form(); ?>
					</div>
					<p class="topmargin_20">
						<?php esc_html_e('or', 'energy'); ?>
					</p>
					<a href="<?php echo get_home_url(); ?>" class="theme_button color min_width_button">
						<?php esc_html_e('Go Home', 'energy'); ?>
					</a>
				</div><!--eof #content-wrap -->
			</div><!-- #layout -->
		</main>
	</div><!-- .container -->
</div><!-- #main -->
<?php
get_footer();
