<?php

/**
 * Widget Posts view file
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-posts-title-only widget_recent_entries ' . esc_attr($mwt_css_class . ' layout-gap-' . $mwt_gap . ' ' . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<ul class="posts-list">
	<?php
	foreach ($mwt_r->posts as $mwt_post) :
		$mwt_post_title = get_the_title($mwt_post->ID);
		$mwt_title      = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');
	?>
		<li>
			<div class="item-content">
				<h3 class="post-title">
					<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
				</h3>
				<?php if (!empty($mwt_show_date)) : ?>
					<div class="icon-inline-wrap">
						<span class="icon-inline post-date">
							<span><?php echo get_the_date('', $mwt_post->ID); ?></span>
						</span>
					</div>
				<?php endif; ?>

			</div>
		</li>
	<?php endforeach; ?>
</ul>
<?php if (!empty($mwt_read_all)) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url($mwt_read_all_url); ?>">
			<?php echo esc_html($mwt_read_all); ?>
		</a>
	</span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .widget-posts-title-only -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
