<?php

/**
 * Widget Posts view file
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
//???
//no icon for other themes as we use 'get_template_part' for SVG icons
if (!function_exists('energy_icon')) :
    function energy_icon($mwt_name, $mwt_return = false, $mwt_container_css_class = 'svg-icon')
    {
        return '';
    }
endif;

//no icon for other themes as we use 'get_template_part' for SVG icons
if (!function_exists('energy_post_format_icon')) :
    function energy_post_format_icon($mwt_post_format = '')
    {
        return '';
    }
endif;

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-posts-default ' . esc_attr($mwt_css_class . ' layout-' . $mwt_layout . ' layout-gap-' . $mwt_gap . ' ' . $mwt_center_class) . '">';
if ($mwt_title) {
    echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
    echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
    echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<div class="page_slider flexslider">
    <ul class="posts-list slides">
        <?php
        foreach ($mwt_r->posts as $mwt_post) :
            $mwt_post_title     = get_the_title($mwt_post->ID);
            $mwt_post_thumbnail = get_the_post_thumbnail($mwt_post->ID, 'energy-square');
            $mwt_title          = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');
        ?>
            <li class="slide <?php echo esc_attr((!empty($mwt_post_thumbnail)) ? 'list-has-post-thumbnail' : 'no-post-thumbnail'); ?>">
                <?php if (!empty($mwt_post_thumbnail)) : ?>
                    <a class="posts-list-thumbnail" href="<?php the_permalink($mwt_post->ID); ?>">
                        <?php
                        echo wp_kses_post($mwt_post_thumbnail);
                        energy_post_format_icon(get_post_format($mwt_post->ID));
                        ?>
                    </a>
                <?php endif; ?>
                <div class="item-content">
                    <span class="author-avatar">
                        <?php
                        $author_id    = get_post_field('post_author', $mwt_post->ID);
                        $profile_image = get_the_author_meta('custom_profile_image', $author_id);
                        if (!empty($profile_image)) {
                            echo "<img alt='author-avatar' src='$profile_image' >";
                        } else {
                            echo get_avatar($author_id, 100);
                        }
                        //profile_img 
                        ?>
                    </span>
                    <h3 class="post-title">
                        <a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
                    </h3>
                    <?php if (!empty($mwt_show_date)) : ?>
                        <div class="icon-inline-wrap">
                            <span class="icon-inline post-date">
                                <span><?php echo get_the_date('', $mwt_post->ID); ?></span>
                            </span>
                            <span class="icon-inline post-date">
                                <span>
                                    <?php
                                    $author_id    = get_post_field('post_author', $mwt_post->ID);
                                    $display_name = get_the_author_meta('display_name', $author_id);
                                    echo esc_html($display_name);
                                    //echo get_the_author() 
                                    ?>
                                </span>
                            </span>

                        </div>
                    <?php endif; ?>

                </div>
            </li>
        <?php endforeach; ?>
    </ul>
</div>
<?php if (!empty($mwt_read_all)) : ?>
    <span class="read-all-link">
        <a href="<?php echo esc_url($mwt_read_all_url); ?>">
            <?php echo esc_html($mwt_read_all); ?>
        </a>
    </span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .widget-posts-default -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
