<?php

/**
 * Widget Theme meta view file
 *
 * @package Energy
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// if our theme is not active - return
if (!function_exists('energy_get_theme_meta')) {
    return;
}

//meta
$mwt_meta = energy_get_theme_meta();

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-theme-meta-links ' . esc_attr($mwt_css_class . $mwt_center_class) . '">';
if ($mwt_title) {
    echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}

if (
    (!empty($mwt_show_meta_facebook)
        || !empty($mwt_show_meta_twitter)
        || !empty($mwt_show_meta_instagram)
        || !empty($mwt_show_meta_linkedin)
        || !empty($mwt_show_meta_youtube)
        || !empty($mwt_show_meta_pinterest)
        || !empty($mwt_show_meta_github))
    && function_exists('energy_link_theme_meta_widget')
) :
?>
    <?php
    $mwt_twitter    = energy_option('meta_twitter');
    $mwt_facebook   = energy_option('meta_facebook');
    $mwt_linkedin   = energy_option('meta_linkedin');
    $mwt_youtube    = energy_option('meta_youtube');
    $mwt_instagram  = energy_option('meta_instagram');
    $mwt_pinterest  = energy_option('meta_pinterest');
    $mwt_github     = energy_option('meta_github');

    if (
        !empty($mwt_facebook)
        ||
        !empty($mwt_twitter)
        ||
        !empty($mwt_youtube)
        ||
        !empty($mwt_instagram)
        ||
        !empty($mwt_pinterest)
        ||
        !empty($mwt_linkedin)
        ||
        !empty($mwt_github)
    ) :

        echo '<span class="social-links">';

        if (!empty($mwt_twitter) && !empty($mwt_show_meta_twitter)) :
            energy_link_theme_meta_widget('twitter', $mwt_twitter);
        endif;

        if (!empty($mwt_facebook) && !empty($mwt_show_meta_facebook)) :
            energy_link_theme_meta_widget('facebook', $mwt_facebook);
        endif;

        if (!empty($mwt_instagram) && !empty($mwt_show_meta_instagram)) :
            energy_link_theme_meta_widget('instagram', $mwt_instagram);
        endif;

        if (!empty($mwt_youtube) && !empty($mwt_show_meta_youtube)) :
            energy_link_theme_meta_widget('youtube', $mwt_youtube);
        endif;

        if (!empty($mwt_pinterest) && !empty($mwt_show_meta_pinterest)) :
            energy_link_theme_meta_widget('pinterest', $mwt_pinterest);
        endif;

        if (!empty($mwt_linkedin) && !empty($mwt_show_meta_linkedin)) :
            energy_link_theme_meta_widget('linkedin', $mwt_linkedin);
        endif;

        if (!empty($mwt_github) && !empty($mwt_show_meta_github)) :
            energy_link_theme_meta_widget('github-circle', $mwt_github);
        endif;

        echo '</span><!--.social-links-->';

    endif;
    ?>
<?php endif; //social_links 
?>
</div><!-- .widget-theme-meta-links -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
