<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/*
 * Views
 */

if (!function_exists('energy_set_post_views')) :
    /**
     * Counter incrementor
     *
     * @param int $postID ID of the post.
     */
    function energy_set_post_views($postID)
    {
        $count_key = 'energy_post_views_count';
        $count     = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            $count = 0;
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '1');
        } else {
            //this fires twice for some unknown reason so we increase count by one half
            $count = $count + 0.5;
            update_post_meta($postID, $count_key, $count);
        }
    } //energy_set_post_views()
endif;

if (!function_exists('energy_action_track_post_views')) :
    /**
     * Post views tracker
     *
     * @param int $post_id ID of the post.
     */
    function energy_action_track_post_views($post_id = '')
    {
        if (!is_singular('post')) {
            return;
        }
        if (empty($post_id)) {
            global $post;
            $post_id = $post->ID;
        }
        energy_set_post_views($post_id);
    } //energy_action_track_post_views()
endif;
add_action('shutdown', 'energy_action_track_post_views');

if (!function_exists('energy_get_post_views')) :
    /**
     * Get counter value
     *
     * @param int $postID ID of the post.
     */
    function energy_get_post_views($post_id)
    {
        $count_key = 'energy_post_views_count';
        $count     = get_post_meta($post_id, $count_key, true);
        if ($count == '') {
            delete_post_meta($post_id, $count_key);
            add_post_meta($post_id, $count_key, '0');

            return "0";
        }

        return number_format($count, 0, ".", ",");
    } //energy_action_track_post_views()
endif;

if (!function_exists('energy_filter_post_column_views')) :
    //Function that Adds a 'Views' Column to your Posts tab in WordPress Dashboard.
    function energy_filter_post_column_views($newcolumn)
    {
        //Retrieves the translated string, if translation exists, and assign it to the 'default' array.
        $newcolumn['post_views'] = esc_html__('Views', 'energy');

        return $newcolumn;
    } //energy_filter_post_column_views()
endif;

if (!function_exists('energy_action_post_custom_column_views')) :
    //Function that Populates the 'Views' Column with the number of views count.
    function energy_action_post_custom_column_views($column_name, $id)
    {

        if ($column_name === 'post_views') {
            // Display the Post View Count of the current post.
            // get_the_ID() - Returns the numeric ID of the current post.
            echo energy_get_post_views(get_the_ID());
        }
    }
endif;
//Hooks a function to a specific filter action.
//applied to the list of columns to print on the manage posts screen.
add_filter('manage_posts_columns', 'energy_filter_post_column_views');

//Hooks a function to a specific action.
//allows you to add custom columns to the list post/custom post type pages.
//'10' default: specify the function's priority.
//and '2' is the number of the functions' arguments.
add_action('manage_posts_custom_column', 'energy_action_post_custom_column_views', 10, 2);


if (!function_exists('energy_show_post_views_count')) :
    function energy_show_post_views_count()
    {

        $id     = get_the_ID();
        $number = energy_get_post_views($id);
        $html   = '';

        if (!$number) {
            $html = '<span class="item-views-count">0</span> <span class="ml-1 item-views-word">' . esc_html__('Views', 'energy') . '</span>';
        }

        if ($number == 1) {
            $html = '<span class="item-views-count">1</span> <span class="ml-1 item-views-word">' . esc_html__('View', 'energy') . '</span>';
        }

        if ($number > 1) {
            $html = '<span class="item-views-count">' . $number . '</span> <span class="ml-1 item-views-word">' . esc_html__('Views', 'energy') . '</span>';
        }

        echo wp_kses_post($html);
    } //energy_show_post_views_count()
endif;

/*
 *  share buttons
 */
if (!function_exists('energy_share_this')) :
    /**
     * Share article through social networks.
     * bool $only_buttons
     */
    function energy_share_this($only_buttons = false)
    {

        $share_buttons                      = array();
        $share_buttons['share_facebook']    = '<a href="https://www.facebook.com/share.php?u=' . esc_url(get_permalink()) . '" class="dropdown-item ico-socicon-facebook" target="_blank"></a>';
        $share_buttons['share_twitter']     = '<a href="https://twitter.com/intent/tweet?url=' . esc_url(get_permalink()) . '" class="dropdown-item ico-Twitter" target="_blank"></a>';
        $share_buttons['share_telegram']    = '<a href="https://telegram.me/share/url?url=' . esc_url(get_permalink()) . '" class="dropdown-item ico-socicon-telegram" target="_blank"></a>';
        $share_buttons['share_pinterest']   = '<a href="https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url(get_permalink()) . '" class="dropdown-item ico-socicon-pinterest" target="_blank"></a>';
        $share_buttons['share_linkedin']    = '<a href="https://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink()) . '" class="dropdown-item ico-socicon-linkedin" target="_blank"></a>';

        if (is_singular()) {
            $blog_share_facebook  = energy_option('blog_single_share_facebook', true);
            $blog_share_twitter  = energy_option('blog_single_share_twitter', true);
            $blog_share_telegram  = energy_option('blog_single_share_telegram', true);
            $blog_share_pinterest  = energy_option('blog_single_share_pinterest', true);
            $blog_share_linkedin  = energy_option('blog_single_share_linkedin', true);
        } else {
            $blog_share_facebook  = energy_option('blog_share_facebook', true);
            $blog_share_twitter  = energy_option('blog_share_twitter', true);
            $blog_share_telegram  = energy_option('blog_share_telegram', true);
            $blog_share_pinterest  = energy_option('blog_share_pinterest', true);
            $blog_share_linkedin  = energy_option('blog_share_linkedin', true);
        }

        if (!$blog_share_facebook) {
            unset($share_buttons['share_facebook']);
        }
        if (!$blog_share_twitter) {
            unset($share_buttons['share_twitter']);
        }
        if (!$blog_share_telegram) {
            unset($share_buttons['share_telegram']);
        }
        if (!$blog_share_pinterest) {
            unset($share_buttons['share_pinterest']);
        }
        if (!$blog_share_linkedin) {
            unset($share_buttons['share_linkedin']);
        }


        if (!empty($share_buttons)) :
            $id = uniqid();
?>

            <div class="dropdown inline-block">
                <a href="#" data-target="#" class="share_button">
                    <?php energy_icon('share') ?>
                </a>
                <div class="dropdown-menu">
                    <div class="share_buttons">
                        <?php
                        foreach ($share_buttons as $share_button) :
                            echo wp_kses_post($share_button);
                        endforeach;
                        ?>
                    </div><!-- eof .share_buttons -->
                </div><!-- eof .dropdown-menu -->
            </div><!-- eof .dropdown -->

        <?php
        endif; // share_buttons
    } //energy_share_this()
endif; //function_exists 

if (!function_exists('energy_share_this_shop')) :
    /**
     * Share article through social networks.
     * bool $only_buttons
     */
    function energy_share_this_shop($only_buttons = false)
    {

        $share_buttons                      = array();
        $share_buttons['share_facebook']    = '<a href="https://www.facebook.com/share.php?u=' . esc_url(get_permalink()) . '" class="border-icon rounded-icon fa fa-facebook" target="_blank"></a>';
        $share_buttons['share_twitter']     = '<a href="https://twitter.com/intent/tweet?url=' . esc_url(get_permalink()) . '" class="border-icon rounded-icon ico-Twitter" target="_blank"></a>';
        $share_buttons['share_telegram']    = '<a href="https://telegram.me/share/url?url=' . esc_url(get_permalink()) . '" class="border-icon rounded-icon fa fa-paper-plane" target="_blank"></a>';
        $share_buttons['share_pinterest']   = '<a href="https://pinterest.com/pin/create/bookmarklet/?url=' . esc_url(get_permalink()) . '" class="border-icon rounded-icon fa fa-pinterest" target="_blank"></a>';
        $share_buttons['share_linkedin']    = '<a href="https://www.linkedin.com/shareArticle?url=' . esc_url(get_permalink()) . '" class="border-icon rounded-icon fa fa-linkedin" target="_blank"></a>';

        if (is_singular()) {
            $blog_share_facebook  = energy_option('blog_single_share_facebook', true);
            $blog_share_twitter  = energy_option('blog_single_share_twitter', true);
            $blog_share_telegram  = energy_option('blog_single_share_telegram', true);
            $blog_share_pinterest  = energy_option('blog_single_share_pinterest', true);
            $blog_share_linkedin  = energy_option('blog_single_share_linkedin', true);
        } else {
            $blog_share_facebook  = energy_option('blog_share_facebook', true);
            $blog_share_twitter  = energy_option('blog_share_twitter', true);
            $blog_share_telegram  = energy_option('blog_share_telegram', true);
            $blog_share_pinterest  = energy_option('blog_share_pinterest', true);
            $blog_share_linkedin  = energy_option('blog_share_linkedin', true);
        }

        if (!$blog_share_facebook) {
            unset($share_buttons['share_facebook']);
        }
        if (!$blog_share_twitter) {
            unset($share_buttons['share_twitter']);
        }
        if (!$blog_share_telegram) {
            unset($share_buttons['share_telegram']);
        }
        if (!$blog_share_pinterest) {
            unset($share_buttons['share_pinterest']);
        }
        if (!$blog_share_linkedin) {
            unset($share_buttons['share_linkedin']);
        }


        if (!empty($share_buttons)) :
            $id = uniqid();
        ?>


            <div class="share_buttons social_part">
                <?php
                foreach ($share_buttons as $share_button) :
                    echo wp_kses_post($share_button);
                endforeach;
                ?>
            </div><!-- eof .share_buttons -->

<?php
        endif; // share_buttons
    } //energy_share_this()
endif; //function_exists 
?>