<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor MWT Team Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Elementor_MWT_Team extends \Elementor\Widget_Base

{

	/**
	 * Retrieve Widget Dependent JS.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array JS script handles.
	 */
	public function get_script_depends()
	{
		return ['mwt-team-script'];
	}

	/**
	 * Retrieve Widget Dependent CSS.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array CSS style handles.
	 */
	public function get_style_depends()
	{
		return ['owl-carousel-style'];
		return ['mwt-team-style'];
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve list widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'mwt-team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve list widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('MWT Team', 'mwt-addons-for-elementor');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the list widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['mwt'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve image carousel widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-person';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords()
	{
		return ['mwt', 'image', 'photo', 'visual', 'team', 'carousel', 'slider', 'grid', 'masonry'];
	}

	/**
	 * Register list widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Team Items', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'team_layout',
			[
				'label' => esc_html__('Layout', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'carousel',
				'options' => [
					'carousel' => esc_html__('Carousel', 'mwt-addons-for-elementor'),
					'grid' => esc_html__('Masonry Grid', 'mwt-addons-for-elementor'),
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'member_item_layout',
			[
				'label'       => __('Skin', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'description' => __('Choose a layout style for the team item', 'mwt-addons-for-elementor'),
				'options'     => [
					'default' => __('Style 1', 'mwt-addons-for-elementor'),
					'style2'  => __('Style 2', 'mwt-addons-for-elementor'),
					'style3'  => __('Style 3', 'mwt-addons-for-elementor'),
					'style4'  => __('Style 4', 'mwt-addons-for-elementor'),
					'style5'  => __('Style 5', 'mwt-addons-for-elementor'),
				],
				'default'     => 'default',
				'separator'   => 'after',
				'label_block' => true,
			]
		);

		/* Start repeater */

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'item_name',
			[
				'label' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'default' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'ai' => [
					'active' => false,
				],
			]
		);

		$repeater->add_control(
			'item_name_link',
			[
				'label'       => __('Link', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::URL,
				'placeholder' => 'https://example.com/',
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'item_position',
			[
				'label'       => __('Position', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Position', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'ai' => [
					'active' => false,
				],
			]
		);

		$repeater->add_control(
			'item_description',
			[
				'label'       => __('Description', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Type your text here...', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'ai' => [
					'active' => false,
				],
			]
		);

		$repeater->add_control(
			'member_social_enable',
			[
				'label'     => __('Enable Social Icons', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'separator' => 'before',
			]
		);

		$fa_brands = [
			'android',
			'apple',
			'behance',
			'bitbucket',
			'codepen',
			'delicious',
			'deviantart',
			'digg',
			'dribbble',
			'elementor',
			'facebook',
			'flickr',
			'foursquare',
			'free-code-camp',
			'github',
			'gitlab',
			'globe',
			'houzz',
			'instagram',
			'jsfiddle',
			'linkedin',
			'medium',
			'meetup',
			'mix',
			'mixcloud',
			'odnoklassniki',
			'pinterest',
			'product-hunt',
			'reddit',
			'shopping-cart',
			'skype',
			'slideshare',
			'snapchat',
			'soundcloud',
			'spotify',
			'stack-overflow',
			'steam',
			'telegram',
			'thumb-tack',
			'threads',
			'tripadvisor',
			'tumblr',
			'twitch',
			'twitter',
			'viber',
			'vimeo',
			'weibo',
			'weixin',
			'whatsapp',
			'wordpress',
			'xing',
			'x-twitter',
			'yelp',
			'youtube',
			'500px',
		];

		//member_social_icon_1
		$repeater->add_control(
			'member_social_icon_1',
			[
				'label'     => __('Social Icon #1', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => $fa_brands,
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_link',
			[
				'label' => esc_html__('Social Icon Link #1', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => ['url', 'is_external', 'nofollow'],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_color_select',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'yes' => esc_html__('Custom', 'mwt-addons-for-elementor'),
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->start_controls_tabs(
			'member_social_icon_1_color_tabs',
			[
				'condition' => [
					'member_social_enable' => 'yes',
					'member_social_icon_1_color_select' => 'yes',
				],
			]
		);

		$repeater->start_controls_tab(
			'member_social_icon_1_color_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_1_color_normal',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1 svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_bg_color_normal',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_border_color_normal',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'member_social_icon_1_color_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_1_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_1_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-1:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		//member_social_icon_2
		$repeater->add_control(
			'member_social_icon_2',
			[
				'label'     => __('Social Icon #2', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'separator' => 'before',
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => $fa_brands,
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_link',
			[
				'label' => esc_html__('Social Icon Link #2', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => ['url', 'is_external', 'nofollow'],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_color_select',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'yes' => esc_html__('Custom', 'mwt-addons-for-elementor'),
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->start_controls_tabs(
			'member_social_icon_2_color_tabs',
			[
				'condition' => [
					'member_social_enable' => 'yes',
					'member_social_icon_2_color_select' => 'yes',
				],
			]
		);

		$repeater->start_controls_tab(
			'member_social_icon_2_color_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_2_color_normal',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2 svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_bg_color_normal',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_border_color_normal',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'member_social_icon_2_color_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_2_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_2_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-2:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		//member_social_icon_3
		$repeater->add_control(
			'member_social_icon_3',
			[
				'label'     => __('Social Icon #3', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'separator' => 'before',
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => $fa_brands,
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_link',
			[
				'label' => esc_html__('Social Icon Link #3', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => ['url', 'is_external', 'nofollow'],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_color_select',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'yes' => esc_html__('Custom', 'mwt-addons-for-elementor'),
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->start_controls_tabs(
			'member_social_icon_3_color_tabs',
			[
				'condition' => [
					'member_social_enable' => 'yes',
					'member_social_icon_3_color_select' => 'yes',
				],
			]
		);

		$repeater->start_controls_tab(
			'member_social_icon_3_color_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_3_color_normal',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3 svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_bg_color_normal',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_border_color_normal',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'member_social_icon_3_color_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_3_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_3_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-3:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		//member_social_icon_4
		$repeater->add_control(
			'member_social_icon_4',
			[
				'label'     => __('Social Icon #4', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'separator' => 'before',
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => $fa_brands,
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_link',
			[
				'label' => esc_html__('Social Icon Link #4', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => ['url', 'is_external', 'nofollow'],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_color_select',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'yes' => esc_html__('Custom', 'mwt-addons-for-elementor'),
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->start_controls_tabs(
			'member_social_icon_4_color_tabs',
			[
				'condition' => [
					'member_social_enable' => 'yes',
					'member_social_icon_4_color_select' => 'yes',
				],
			]
		);

		$repeater->start_controls_tab(
			'member_social_icon_4_color_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_4_color_normal',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4 svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_bg_color_normal',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_border_color_normal',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'member_social_icon_4_color_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_4_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_4_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-4:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		//member_social_icon_5
		$repeater->add_control(
			'member_social_icon_5',
			[
				'label'     => __('Social Icon #5', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'separator' => 'before',
				'default' => [
					'value' => 'fab fa-wordpress',
					'library' => 'fa-brands',
				],
				'recommended' => [
					'fa-brands' => $fa_brands,
					'fa-solid' => [
						'envelope',
						'link',
						'rss',
					],
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_link',
			[
				'label' => esc_html__('Social Icon Link #5', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => ['url', 'is_external', 'nofollow'],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_color_select',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'no',
				'options' => [
					'no' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'yes' => esc_html__('Custom', 'mwt-addons-for-elementor'),
				],
				'condition' => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->start_controls_tabs(
			'member_social_icon_5_color_tabs',
			[
				'condition' => [
					'member_social_enable' => 'yes',
					'member_social_icon_5_color_select' => 'yes',
				],
			]
		);

		$repeater->start_controls_tab(
			'member_social_icon_5_color_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_5_color_normal',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5 i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5 svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_bg_color_normal',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_border_color_normal',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->start_controls_tab(
			'member_social_icon_5_color_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$repeater->add_control(
			'member_social_icon_5_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$repeater->add_control(
			'member_social_icon_5_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons .mwt-team-social-icon-5:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$repeater->end_controls_tab();

		$repeater->end_controls_tabs();

		/* End repeater */
		$this->add_control(
			'team-list',
			[
				'label' => esc_html__('Members', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => '',
						'item_name' => esc_html__('Name 1', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_social_icon_1' => '',
						'member_social_icon_1_link' => '',
						'member_social_icon_1_color_select' => '',
						'member_social_icon_2' => '',
						'member_social_icon_2_link' => '',
						'member_social_icon_2_color_select' => '',
						'member_social_icon_3' => '',
						'member_social_icon_3_link' => '',
						'member_social_icon_3_color_select' => '',
						'member_social_icon_4' => '',
						'member_social_icon_4_link' => '',
						'member_social_icon_4_color_select' => '',
						'member_social_icon_5' => '',
						'member_social_icon_5_link' => '',
						'member_social_icon_5_color_select' => '',
					],
					[
						'image' => '',
						'item_name' => esc_html__('Name 2', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_social_icon_1' => '',
						'member_social_icon_1_link' => '',
						'member_social_icon_1_color_select' => '',
						'member_social_icon_2' => '',
						'member_social_icon_2_link' => '',
						'member_social_icon_2_color_select' => '',
						'member_social_icon_3' => '',
						'member_social_icon_3_link' => '',
						'member_social_icon_3_color_select' => '',
						'member_social_icon_4' => '',
						'member_social_icon_4_link' => '',
						'member_social_icon_4_color_select' => '',
						'member_social_icon_5' => '',
						'member_social_icon_5_link' => '',
						'member_social_icon_5_color_select' => '',
					],
					[
						'image' => '',
						'item_name' => esc_html__('Name 3', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_social_icon_1' => '',
						'member_social_icon_1_link' => '',
						'member_social_icon_1_color_select' => '',
						'member_social_icon_2' => '',
						'member_social_icon_2_link' => '',
						'member_social_icon_2_color_select' => '',
						'member_social_icon_3' => '',
						'member_social_icon_3_link' => '',
						'member_social_icon_3_color_select' => '',
						'member_social_icon_4' => '',
						'member_social_icon_4_link' => '',
						'member_social_icon_4_color_select' => '',
						'member_social_icon_5' => '',
						'member_social_icon_5_link' => '',
						'member_social_icon_5_color_select' => '',
					],
				],
				'title_field' => '{{{ item_name }}}',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'separator' => 'none',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'carousel_settings',
			[
				'label' => __('Carousel Settings', 'mwt-addons-for-elementor'),
				'condition' => [
					'team_layout' => 'carousel',
				]
			]
		);

		$this->add_control(
			'data_loop',
			[
				'label'   => __('Loop', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_rtl',
			[
				'label'   => __('Enable RTL', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_autoplay',
			[
				'label'   => __('Autoplay', 'mwt-addons-for-elementor'),
				'description' => esc_html__('Slide will start automatically', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_autoplaytimeout',
			[
				'label' => esc_html__('Autoplay Speed (ms)', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 5000,
				'min' => 0,
				'step' => 50,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_autoplay_hover_pause',
			[
				'label'   => __('Pause on Hover', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_center',
			[
				'label'   => __('Centered Carousel?', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		//Slides to Scroll

		$this->add_control(
			'data_responsive_lg',
			[
				'label' => esc_html__('Desktop Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 12,
				'step' => 1,
				'default' => 4,
				'separator' => 'before',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_responsive_md',
			[
				'label' => esc_html__('Laptop Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 12,
				'step' => 1,
				'default' => 3,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_responsive_sm',
			[
				'label' => esc_html__('Tablet Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 12,
				'step' => 1,
				'default' => 2,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_responsive_xs',
			[
				'label' => esc_html__('Mobile Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 12,
				'step' => 1,
				'default' => 1,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_margin',
			[
				'label' => esc_html__('Item Gap (px)', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 80,
				'step' => 1,
				'default' => 30,
				'separator' => 'before',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_nav_prev_next',
			[
				'label'   => __('Show prev/next', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'no',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'date_nav_prev',
			[
				'label'            => __('Previous Icon', 'mwt-addons-for-elementor'),
				'type'             => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => [
					'value'   => 'fas fa-chevron-left',
					'library' => 'fa-solid',
				],
				'recommended'      => [
					'fa-solid'   => [
						'chevron-left',
					],
				],
				'skin'             => 'inline',
				'label_block'      => false,
				'condition' => [
					'data_nav_prev_next' => 'yes',
				]
			]
		);

		$this->add_control(
			'date_nav_prev_word',
			[
				'label'     => __('Previous word', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Prev', 'mwt-addons-for-elementor'),
				'dynamic' => [
					'active' => true,
				],
				'condition'   => [
					'data_nav_prev_next' => 'yes',
				],
			]
		);

		$this->add_control(
			'date_nav_next',
			[
				'label'            => __('Next Icon', 'mwt-addons-for-elementor'),
				'type'             => \Elementor\Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => [
					'value'   => 'fas fa-chevron-right',
					'library' => 'fa-solid',
				],
				'recommended'      => [
					'fa-solid'   => [
						'chevron-right',
					],
				],
				'skin'             => 'inline',
				'label_block'      => false,
				'condition' => [
					'data_nav_prev_next' => 'yes',
				]
			]
		);

		$this->add_control(
			'date_nav_next_word',
			[
				'label'     => __('Next word', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Next', 'mwt-addons-for-elementor'),
				'dynamic' => [
					'active' => true,
				],
				'condition'   => [
					'data_nav_prev_next' => 'yes',
				],
			]
		);

		$this->add_control(
			'data_nav_dots',
			[
				'label'   => __('Show dots', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'team_grid_settings',
			[
				'label' => __('Grid Settings', 'mwt-addons-for-elementor'),
				'condition' => [
					'team_layout'   => 'grid',
				]
			]
		);

		$this->add_control(
			'team_items_per_row',
			[
				'label' => esc_html__('Items per row', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'description' => esc_html__('How many items should be shown per row?', 'mwt-addons-for-elementor'),
				'min'  => 1,
				'max'  => 4,
				'step' => 1,
				'default' => 3,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'team_layout_gap',
			[
				'label' => esc_html__('Gap', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'30' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'0' => esc_html__('None', 'mwt-addons-for-elementor'),
					'1'  => esc_html__('1px', 'mwt-addons-for-elementor'),
					'2' => esc_html__('2px', 'mwt-addons-for-elementor'),
					'3' => esc_html__('3px', 'mwt-addons-for-elementor'),
					'4' => esc_html__('4px', 'mwt-addons-for-elementor'),
					'5' => esc_html__('5px', 'mwt-addons-for-elementor'),
					'10' => esc_html__('10px', 'mwt-addons-for-elementor'),
					'15' => esc_html__('15px', 'mwt-addons-for-elementor'),
					'20' => esc_html__('20px', 'mwt-addons-for-elementor'),
					'30' => esc_html__('30px', 'mwt-addons-for-elementor'),
					'40' => esc_html__('40px', 'mwt-addons-for-elementor'),
					'50' => esc_html__('50px', 'mwt-addons-for-elementor'),
					'60' => esc_html__('60px', 'mwt-addons-for-elementor'),
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'team_horizontal_order',
			[
				'label' => esc_html__('Horizontal Order', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'mwt-addons-for-elementor'),
				'label_off' => esc_html__('No', 'mwt-addons-for-elementor'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();

		// style
		$this->start_controls_section(
			'style_item_section',
			[
				'label' => esc_html__('Items', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'member_item_align',
			[
				'label'     => __('Alignment', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __('Left', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center'     => [
						'title' => __('Center', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => __('Right', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'Left',
				'selectors' => [
					'{{WRAPPER}} .mwt-team-content-wrap' => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .style2 .mwt-team-content-wrap' => 'justify-content: {{VALUE}}',
					'{{WRAPPER}} .mwt-team-social-icons' => 'justify-content: {{VALUE}}',
				],
				'condition' => [
					'member_item_layout!' => 'style4',
				]
			]
		);

		$this->add_responsive_control(
			'member_item_image_padding',
			[
				'label'      => __('Image Padding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-image-wrap img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout' => 'style5',
				]
			]
		);

		$this->add_responsive_control(
			'member_item_content_padding',
			[
				'label'      => __('Content Padding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		//default
		$this->add_control(
			'member_item_bg_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-grid-container .grid-item' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'default',
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'member_item_border',
				'selector' => '{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item, .mwt-team-grid-container .grid-item',
				'condition' => [
					'member_item_layout' => 'default',
				]
			]
		);

		$this->add_control(
			'member_item_border_radius',
			[
				'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .mwt-team-grid-container .grid-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout' => 'default',
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'member_item_box_shadow',
				'selector' => '{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item, .mwt-team-grid-container .grid-item',
				'condition' => [
					'member_item_layout' => 'default',
					'data_center!' => 'yes',
				]
			]
		);

		//style2
		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'member_item_style2_bg_color',
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .mwt-team-content-wrap',
				'condition' => [
					'member_item_layout' => ['style2', 'style4']
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'member_item_style2_border',
				'selector' => '{{WRAPPER}} .mwt-team-content-wrap',
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'member_item_style2_border_radius',
			[
				'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'odd_items_style',
			[
				'label' => esc_html__('Odd Items', 'textdomain'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'odd_item_style2_title_color',
			[
				'label'     => __('Title Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-grid-container .grid-item:nth-child(even) .mwt-team-name' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-item:nth-child(odd) .mwt-team-name' => 'color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'odd_item_style2_title_color_hover',
			[
				'label'     => __('Title Color Hover', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-grid-container .grid-item:nth-child(even) .mwt-team-name:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-item:nth-child(odd) .mwt-team-name:hover' => 'color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'odd_item_style2_position_color',
			[
				'label'     => __('Position Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-grid-container .grid-item:nth-child(even) .mwt-team-position' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-item:nth-child(odd) .mwt-team-position' => 'color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'odd_item_style2_bg_color',
				'types' => ['classic', 'gradient'],
				'selector' => '{{WRAPPER}} .mwt-team-grid-container .grid-item:nth-child(even) .mwt-team-content-wrap, .mwt-team-carousel-container .owl-item:nth-child(odd) .mwt-team-content-wrap',
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->add_control(
			'odd_item_style2_border_color',
			[
				'label'     => __('Border Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-grid-container .grid-item:nth-child(even) .mwt-team-content-wrap' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-item:nth-child(odd) .mwt-team-content-wrap' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'style2',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_image',
			[
				'label' => esc_html__('Image', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'image_hover_overlay_color',
			[
				'label' => esc_html__('Hover Overlay Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item .mwt-team-image-wrap::after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-grid-container .grid-item .mwt-team-image-wrap::after' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'image_background_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item.style5 .mwt-team-image-wrap::before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-grid-container .grid-item.style5 .mwt-team-image-wrap::before' => 'background-color: {{VALUE}};',
				],
				'condition' => [
					'member_item_layout' => 'style5',
				]
			]
		);

		$this->add_responsive_control(
			'image_background_color_opacity',
			[
				'label' => esc_html__('Background Color Opacity', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'max' => 1,
						'min' => 0.10,
						'step' => 0.01,
					],
				],
				'default' => [
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-carousel-item.style5 .mwt-team-image-wrap::before' => 'opacity: {{SIZE}};',
					'{{WRAPPER}} .mwt-team-grid-container .grid-item.style5 .mwt-team-image-wrap::before' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'member_item_layout' => 'style5',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_name_section',
			[
				'label' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-name' => 'color: {{VALUE}};',
					'{{WRAPPER}} a.mwt-team-name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'name_color_hover',
			[
				'label' => esc_html__('Color Hover', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.mwt-team-name:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'name_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-team-name',
			]
		);

		$this->add_responsive_control(
			'name_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_position_section',
			[
				'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'position_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-position' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'position_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-team-position',
			]
		);

		$this->add_responsive_control(
			'position_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-position' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_description_section',
			[
				'label' => esc_html__('Description', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'member_item_layout!' => ['style2', 'style4'],
				]
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'description_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-team-description',
			]
		);

		$this->add_responsive_control(
			'description_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		//soc icons style
		$this->start_controls_section(
			'social_icons_style',
			[
				'label'     => __('Social Icons', 'mwt-addons-for-elementor'),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'social_icons_size',
			[
				'label'       => __('Size', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => ['px', 'em', '%'],
				'label_block' => true,
				'selectors'   => [
					'{{WRAPPER}} .mwt-team-social-icons a i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .mwt-team-social-icons a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout!' => 'style3',
				]
			]
		);

		$this->start_controls_tabs(
			'social_icons_style_tabs'
		);

		$this->start_controls_tab(
			'social_icons_style_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'social_icons_color',
			[
				'label'     => __('Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons a i'  => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons a svg'  => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'social_icons_background_color',
			[
				'label'     => __('Background Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons a'  => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'social_icons_style_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'social_icons_hover_color',
			[
				'label'     => __('Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons a:hover i'  => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-social-icons a:hover svg'  => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'social_icons_hover_background_color',
			[
				'label'     => __('Background Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons a:hover'  => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'social_icons_hover_border_color',
			[
				'label'     => __('Border Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-social-icons a:hover'  => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'social_icons_hover_animation',
			[
				'label' => esc_html__('Hover Animation', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'social_icons_border',
				'selector' => '{{WRAPPER}} .mwt-team-social-icons a',
			]
		);

		$this->add_responsive_control(
			'social_icons_border_radius',
			[
				'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-social-icons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'social_icons_padding',
			[
				'label'      => __('Padding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-social-icons a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout!' => 'style3',
				],
			]
		);

		$this->add_responsive_control(
			'social_icons_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-social-icons a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'member_item_layout!' => 'style3',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_prev_next_section',
			[
				'label' => esc_html__('Prev/Next', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_layout' => 'carousel',
					'data_nav_prev_next' => 'yes',
				]
			]
		);

		$this->add_control(
			'prev_next_icons_position',
			[
				'label' => esc_html__('Prev/Next Position', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'bottom',
				'options' => [
					'bottom' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'middle' => esc_html__('Middle', 'mwt-addons-for-elementor'),
				],
			]
		);

		$this->add_control(
			'prev_next_align',
			[
				'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__('Start', 'mwt-addons-for-elementor'),
						'icon' => 'eicon-align-start-h',
					],
					'center' => [
						'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
						'icon' => 'eicon-align-center-h',
					],
					'end' => [
						'title' => esc_html__('End', 'mwt-addons-for-elementor'),
						'icon' => 'eicon-align-end-h',
					],
					'space-between' => [
						'title' => esc_html__('Space Between', 'mwt-addons-for-elementor'),
						'icon' => 'eicon-justify-space-between-h',
					],
				],
				'default' => 'start',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav' => 'justify-content: {{VALUE}};',
				],
				'condition' => [
					'prev_next_icons_position' => 'bottom',
				]
			]
		);

		$this->add_responsive_control(
			'prev_next_btn_gap',
			[
				'label'      => __('Buttons Spacing', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav' => 'gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'prev_next_icons_position' => 'bottom',
					'prev_next_align' => ['start', 'center', 'end'],
				]
			]
		);

		$this->add_responsive_control(
			'prev_next_offset',
			[
				'label'      => __('Offset X', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav' => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}}; width: calc(100% + {{SIZE}}{{UNIT}} * 2);',
				],
				'condition' => [
					'prev_next_icons_position' => 'bottom',
				]
			]
		);

		$this->add_responsive_control(
			'prev_next_offset_miffle',
			[
				'label'      => __('Offset X', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'range'      => [
					'px' => [
						'min'  => -1000,
						'max'  => 1000,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav.position-middle button.owl-prev' => 'left: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav.position-middle button.owl-next' => 'right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'prev_next_icons_position' => 'middle',
				]
			]
		);

		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'prev_next_typography',
				'selector' => '{{WRAPPER}} .mwt-team-carousel-container .owl-nav button',
			]
		);

		$this->add_responsive_control(
			'prev_next_icon_size',
			[
				'label'      => __('Icon Size', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'      => [
					'px' => [
						'min'  => 4,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 16,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button svg' => 'font-size: {{SIZE}}{{UNIT}};',

				],
			]
		);

		$this->add_control(
			'prev_next_icon_position',
			[
				'label' => esc_html__('Icon Position', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'row',
				'options' => [
					'row' => esc_html__('Default', 'mwt-addons-for-elementor'),
					'row-reverse' => esc_html__('Reverse', 'mwt-addons-for-elementor'),
				],
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button>span' => 'flex-direction: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'prev_next_icon_spacing',
			[
				'label'      => __('Icon Spacing', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'      => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 12,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button>span' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs(
			'prev_next_style_tabs'
		);

		$this->start_controls_tab(
			'prev_next_style_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'prev_next_color',
			[
				'label' => esc_html__('Text Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_icon_color',
			[
				'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_bg_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'prev_next_style_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'prev_next_color_hover',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_icon_color_hover',
			[
				'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button:hover i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button:hover svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_bg_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'prev_next_style_disabled_tab',
			[
				'label' => esc_html__('Disabled', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'prev_next_color_disabled',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_icon_color_disabled',
			[
				'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_bg_color_disabled',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'prev_next_border_color_disabled',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button.disabled' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'prev_next_border',
				'selector' => '{{WRAPPER}} .mwt-team-carousel-container .owl-nav button',
			]
		);

		$this->add_control(
			'prev_next_border_radius',
			[
				'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'prev_next_padding',
			[
				'label'      => esc_html__('Pdding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'prev_next_margin',
			[
				'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'allowed_dimensions' => 'vertical',
				'placeholder' => [
					'top' => '0',
					'right' => '0',
					'bottom' => '0',
					'left' => '0',
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-nav' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_dots_section',
			[
				'label' => esc_html__('Dots', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'team_layout' => 'carousel',
					'data_nav_dots' => 'yes',
				]
			]
		);

		$this->start_controls_tabs(
			'dots_style_tabs'
		);

		$this->start_controls_tab(
			'dots_style_normal_tab',
			[
				'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'dots_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'dots_style_hover_tab',
			[
				'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'dots_color_hover',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'dots_border_color_hover',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'dats_style_active_tab',
			[
				'label' => esc_html__('Active', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'dots_color_active',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot.active span' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'dots_border_color_active',
			[
				'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot.active span' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'dots_size',
			[
				'label'      => __('Size', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'      => [
					'px' => [
						'min'  => 5,
						'max'  => 50,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'dots_border',
				'selector' => '{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span',
			]
		);

		$this->add_control(
			'dots_border_radius',
			[
				'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span'  => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-team-carousel-container .owl-dots > .owl-dot span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render list widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$unique_id = uniqid();

		if (empty($settings['team-list'])) {
			return;
		}

		//carousel layout
		if ($settings['team_layout'] === 'carousel') : ?>
			<div class="mwt-team-carousel-container">
				<?php
				$data_loop = ($settings['data_loop'] === 'yes') ? 'true' : 'false';
				$data_autoplay = ($settings['data_autoplay'] === 'yes') ? 'true' : 'false';
				$data_center = ($settings['data_center'] === 'yes') ? 'true' : 'false';
				$data_nav = ($settings['data_nav_prev_next'] === 'yes') ? 'true' : 'false';
				$data_dots = ($settings['data_nav_dots'] === 'yes') ? 'true' : 'false';
				$data_autoplay_hover_pause = ($settings['data_autoplay_hover_pause'] === 'yes') ? 'true' : 'false';
				$data_rtl = ($settings['data_rtl'] === 'yes') ? 'true' : 'false';
				?>
				<div class="owl-carousel mwt-team-carousel <?php //echo esc_attr($settings['nav_layout']); 
															?>" data-number="<?php echo esc_attr($unique_id); ?>" data-rtl="<?php echo esc_attr($data_rtl) ?>" data-loop="<?php echo esc_attr($data_loop) ?>" data-autoplay="<?php echo esc_attr($data_autoplay) ?>" data-autoplaytimeout="<?php echo esc_attr($settings['data_autoplaytimeout']) ?>" data-autoplayhoverpause="<?php echo esc_attr($data_autoplay_hover_pause) ?>" data-center="<?php echo esc_attr($data_center) ?>" data-nav="<?php echo esc_attr($data_nav) ?>" data-dots="<?php echo esc_attr($data_dots) ?>" data-margin="<?php echo esc_attr($settings['data_margin']) ?>" data-responsive-lg="<?php echo esc_attr($settings['data_responsive_lg']) ?>" data-responsive-md="<?php echo esc_attr($settings['data_responsive_md']) ?>" data-responsive-sm="<?php echo esc_attr($settings['data_responsive_sm']) ?>" data-responsive-xs="<?php echo esc_attr($settings['data_responsive_xs']) ?>">
				<?php
			endif; //end carousel layout  

			//grid layout
			if ($settings['team_layout'] === 'grid') :
				$horizontal_order = ($settings['team_horizontal_order'] === 'yes') ? true : false;
				?>
					<div class="mwt-team-grid-container">
						<div class="layout-cols layout-cols-<?php echo esc_attr($settings['team_items_per_row']); ?> layout-gap-<?php echo esc_attr($settings['team_layout_gap']); ?>">
							<div class="grid-columns-wrapper">
								<div class="masonry" data-order="<?php echo esc_attr($horizontal_order); ?>">
									<div class="grid-sizer"></div>
									<?php endif;
								//end grid layout 

								foreach ($settings['team-list'] as $index => $item) {
									$item_layout = $settings['member_item_layout'];
									switch ($item_layout) {
										case 'default':
											//carousel layout
											if ($settings['team_layout'] === 'carousel') : ?>
												<div class="owl-carousel-item">
												<?php endif;
											//end carousel layout 

											//grid layout
											if ($settings['team_layout'] === 'grid') : ?>
													<div class="grid-item">
													<?php endif;
												//end grid layout  
													?>
													<div class="mwt-team-image-wrap">
														<?php
														$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
														if (!$image_url && isset($item['image']['url'])) {
															$image_url = $item['image']['url'];
														}
														if (!empty($item['item_name'])) {
															$image_alt = $item['item_name'];
														} else {
															$image_alt = 'This is a title';
														}
														$image_html = '<img class="mwt-team-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
														echo wp_kses_post($image_html);
														?>
														<?php
														$name_link = $settings['team-list'][$index]['item_name_link']['url'];
														if (!empty($name_link)) { ?>
															<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-media-link"></a>
														<?php } ?>
													</div>
													<?php
													$name = $settings['team-list'][$index]['item_name'];
													$position = $settings['team-list'][$index]['item_position'];
													$description = $settings['team-list'][$index]['item_description'];
													?>
													<div class="mwt-team-content-wrap">
														<?php
														if (!empty($name_link)) { ?>
															<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-name">
																<?php echo $name; ?>
															</a>
														<?php } else { ?>
															<div class="mwt-team-name">
																<?php echo $name; ?>
															</div>
														<?php } ?>
														<?php if (!empty($position)) { ?>
															<div class="mwt-team-position">
																<?php echo $position; ?>
															</div>
														<?php } ?>
														<?php if (!empty($description)) { ?>
															<div class="mwt-team-description">
																<?php echo $description; ?>
															</div>
														<?php } ?>
														<?php
														$social_icon_1_link = !empty($settings['team-list'][$index]['member_social_icon_1_link']) ? $settings['team-list'][$index]['member_social_icon_1_link']['url'] : '#';
														$social_icon_2_link = !empty($settings['team-list'][$index]['member_social_icon_2_link']) ? $settings['team-list'][$index]['member_social_icon_2_link']['url'] : '#';
														$social_icon_3_link = !empty($settings['team-list'][$index]['member_social_icon_3_link']) ? $settings['team-list'][$index]['member_social_icon_3_link']['url'] : '#';
														$social_icon_4_link = !empty($settings['team-list'][$index]['member_social_icon_4_link']) ? $settings['team-list'][$index]['member_social_icon_4_link']['url'] : '#';
														$social_icon_5_link = !empty($settings['team-list'][$index]['member_social_icon_5_link']) ? $settings['team-list'][$index]['member_social_icon_5_link']['url'] : '#';

														$animationClass = '';
														if ($settings['social_icons_hover_animation']) {
															$animationClass .= 'elementor-animation-' . $settings['social_icons_hover_animation'];
														}
														?>
														<div class="mwt-team-social-icons">
															<?php if (!empty($settings['team-list'][$index]['member_social_icon_1']['value'])) { ?>
																<a class="mwt-team-social-icon-1 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_1_link); ?>">
																	<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_1'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																</a>
															<?php } ?>
															<?php if (!empty($settings['team-list'][$index]['member_social_icon_2']['value'])) { ?>
																<a class="mwt-team-social-icon-2 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_2_link); ?>">
																	<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_2'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																</a>
															<?php } ?>
															<?php if (!empty($settings['team-list'][$index]['member_social_icon_3']['value'])) { ?>
																<a class="mwt-team-social-icon-3 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_3_link); ?>">
																	<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_3'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																</a>
															<?php } ?>
															<?php if (!empty($settings['team-list'][$index]['member_social_icon_4']['value'])) { ?>
																<a class="mwt-team-social-icon-4 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_4_link); ?>">
																	<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_4'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																</a>
															<?php } ?>
															<?php if (!empty($settings['team-list'][$index]['member_social_icon_5']['value'])) { ?>
																<a class="mwt-team-social-icon-5 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_5_link); ?>">
																	<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_5'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																</a>
															<?php } ?>
														</div>
													</div>
													</div>
													<?php break;
												case 'style2':
													//carousel layout
													if ($settings['team_layout'] === 'carousel') : ?>
														<div class="owl-carousel-item style2">
														<?php endif;
													//end carousel layout 

													//grid layout
													if ($settings['team_layout'] === 'grid') : ?>
															<div class="grid-item style2">
															<?php endif;
														//end grid layout  
															?>
															<div class="mwt-team-image-wrap">
																<?php
																$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
																if (!$image_url && isset($item['image']['url'])) {
																	$image_url = $item['image']['url'];
																}
																if (!empty($item['item_name'])) {
																	$image_alt = $item['item_name'];
																} else {
																	$image_alt = 'This is a title';
																}
																$image_html = '<img class="mwt-team-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
																echo wp_kses_post($image_html);
																?>
																<?php
																$name_link = $settings['team-list'][$index]['item_name_link']['url'];
																if (!empty($name_link)) { ?>
																	<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-media-link"></a>
																<?php } ?>
																<?php
																$social_icon_1_link = !empty($settings['team-list'][$index]['member_social_icon_1_link']) ? $settings['team-list'][$index]['member_social_icon_1_link']['url'] : '#';
																$social_icon_2_link = !empty($settings['team-list'][$index]['member_social_icon_2_link']) ? $settings['team-list'][$index]['member_social_icon_2_link']['url'] : '#';
																$social_icon_3_link = !empty($settings['team-list'][$index]['member_social_icon_3_link']) ? $settings['team-list'][$index]['member_social_icon_3_link']['url'] : '#';
																$social_icon_4_link = !empty($settings['team-list'][$index]['member_social_icon_4_link']) ? $settings['team-list'][$index]['member_social_icon_4_link']['url'] : '#';
																$social_icon_5_link = !empty($settings['team-list'][$index]['member_social_icon_5_link']) ? $settings['team-list'][$index]['member_social_icon_5_link']['url'] : '#';

																$animationClass = '';
																if ($settings['social_icons_hover_animation']) {
																	$animationClass .= 'elementor-animation-' . $settings['social_icons_hover_animation'];
																}
																?>
																<div class="mwt-team-social-icons">
																	<?php if (!empty($settings['team-list'][$index]['member_social_icon_1']['value'])) { ?>
																		<a class="mwt-team-social-icon-1 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_1_link); ?>">
																			<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_1'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																		</a>
																	<?php } ?>
																	<?php if (!empty($settings['team-list'][$index]['member_social_icon_2']['value'])) { ?>
																		<a class="mwt-team-social-icon-2 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_2_link); ?>">
																			<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_2'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																		</a>
																	<?php } ?>
																	<?php if (!empty($settings['team-list'][$index]['member_social_icon_3']['value'])) { ?>
																		<a class="mwt-team-social-icon-3 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_3_link); ?>">
																			<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_3'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																		</a>
																	<?php } ?>
																	<?php if (!empty($settings['team-list'][$index]['member_social_icon_4']['value'])) { ?>
																		<a class="mwt-team-social-icon-4 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_4_link); ?>">
																			<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_4'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																		</a>
																	<?php } ?>
																	<?php if (!empty($settings['team-list'][$index]['member_social_icon_5']['value'])) { ?>
																		<a class="mwt-team-social-icon-5 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_5_link); ?>">
																			<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_5'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																		</a>
																	<?php } ?>
																</div>
															</div>
															<?php
															$name = $settings['team-list'][$index]['item_name'];
															$position = $settings['team-list'][$index]['item_position'];
															?>
															<div class="mwt-team-content-wrap">
																<?php
																if (!empty($name_link)) { ?>
																	<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-name">
																		<?php echo $name; ?>
																	</a>
																<?php } else { ?>
																	<div class="mwt-team-name">
																		<?php echo $name; ?>
																	</div>
																<?php } ?>
																<?php if (!empty($position)) { ?>
																	<div class="mwt-team-position">
																		<?php echo $position; ?>
																	</div>
																<?php } ?>
															</div>
															</div>
															<?php break;

														case 'style3':
															//carousel layout
															if ($settings['team_layout'] === 'carousel') : ?>
																<div class="owl-carousel-item style3">
																<?php endif;
															//end carousel layout 

															//grid layout
															if ($settings['team_layout'] === 'grid') : ?>
																	<div class="grid-item style3">
																	<?php endif;
																//end grid layout  
																	?>
																	<div class="mwt-team-image-wrap">
																		<?php
																		$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
																		if (!$image_url && isset($item['image']['url'])) {
																			$image_url = $item['image']['url'];
																		}
																		if (!empty($item['item_name'])) {
																			$image_alt = $item['item_name'];
																		} else {
																			$image_alt = 'This is a title';
																		}
																		$image_html = '<img class="mwt-team-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
																		echo wp_kses_post($image_html);
																		?>
																		<?php
																		$name_link = $settings['team-list'][$index]['item_name_link']['url'];
																		if (!empty($name_link)) { ?>
																			<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-media-link"></a>
																		<?php } ?>
																		<?php
																		$social_icon_1_link = !empty($settings['team-list'][$index]['member_social_icon_1_link']) ? $settings['team-list'][$index]['member_social_icon_1_link']['url'] : '#';
																		$social_icon_2_link = !empty($settings['team-list'][$index]['member_social_icon_2_link']) ? $settings['team-list'][$index]['member_social_icon_2_link']['url'] : '#';
																		$social_icon_3_link = !empty($settings['team-list'][$index]['member_social_icon_3_link']) ? $settings['team-list'][$index]['member_social_icon_3_link']['url'] : '#';
																		$social_icon_4_link = !empty($settings['team-list'][$index]['member_social_icon_4_link']) ? $settings['team-list'][$index]['member_social_icon_4_link']['url'] : '#';
																		$social_icon_5_link = !empty($settings['team-list'][$index]['member_social_icon_5_link']) ? $settings['team-list'][$index]['member_social_icon_5_link']['url'] : '#';

																		$animationClass = '';
																		if ($settings['social_icons_hover_animation']) {
																			$animationClass .= 'elementor-animation-' . $settings['social_icons_hover_animation'];
																		}
																		?>
																		<div class="mwt-team-social-icons">
																			<?php if (!empty($settings['team-list'][$index]['member_social_icon_1']['value'])) { ?>
																				<a class="mwt-team-social-icon-1 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_1_link); ?>">
																					<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_1'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																				</a>
																			<?php } ?>
																			<?php if (!empty($settings['team-list'][$index]['member_social_icon_2']['value'])) { ?>
																				<a class="mwt-team-social-icon-2 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_2_link); ?>">
																					<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_2'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																				</a>
																			<?php } ?>
																			<?php if (!empty($settings['team-list'][$index]['member_social_icon_3']['value'])) { ?>
																				<a class="mwt-team-social-icon-3 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_3_link); ?>">
																					<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_3'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																				</a>
																			<?php } ?>
																			<?php if (!empty($settings['team-list'][$index]['member_social_icon_4']['value'])) { ?>
																				<a class="mwt-team-social-icon-4 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_4_link); ?>">
																					<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_4'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																				</a>
																			<?php } ?>
																			<?php if (!empty($settings['team-list'][$index]['member_social_icon_5']['value'])) { ?>
																				<a class="mwt-team-social-icon-5 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_5_link); ?>">
																					<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_5'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																				</a>
																			<?php } ?>
																		</div>
																	</div>
																	<?php
																	$name = $settings['team-list'][$index]['item_name'];
																	$position = $settings['team-list'][$index]['item_position'];
																	?>
																	<div class="mwt-team-content-wrap">
																		<?php
																		if (!empty($name_link)) { ?>
																			<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-name">
																				<?php echo $name; ?>
																			</a>
																		<?php } else { ?>
																			<div class="mwt-team-name">
																				<?php echo $name; ?>
																			</div>
																		<?php } ?>
																		<?php if (!empty($position)) { ?>
																			<div class="mwt-team-position">
																				<?php echo $position; ?>
																			</div>
																		<?php } ?>
																	</div>
																	</div>
																	<?php break;

																case 'style4':
																	//carousel layout
																	if ($settings['team_layout'] === 'carousel') : ?>
																		<div class="owl-carousel-item style4">
																		<?php endif;
																	//end carousel layout 

																	//grid layout
																	if ($settings['team_layout'] === 'grid') : ?>
																			<div class="grid-item style4">
																				<div class="mwt-team-grid-item-wrap">
																				<?php endif;
																			//end grid layout  
																				?>
																				<div class="mwt-team-image-wrap">
																					<?php
																					$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
																					if (!$image_url && isset($item['image']['url'])) {
																						$image_url = $item['image']['url'];
																					}
																					if (!empty($item['item_name'])) {
																						$image_alt = $item['item_name'];
																					} else {
																						$image_alt = 'This is a title';
																					}
																					$image_html = '<img class="mwt-team-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
																					echo wp_kses_post($image_html);
																					?>
																					<?php
																					$name_link = $settings['team-list'][$index]['item_name_link']['url'];
																					if (!empty($name_link)) { ?>
																						<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-media-link"></a>
																					<?php } ?>
																					<?php
																					$social_icon_1_link = !empty($settings['team-list'][$index]['member_social_icon_1_link']) ? $settings['team-list'][$index]['member_social_icon_1_link']['url'] : '#';
																					$social_icon_2_link = !empty($settings['team-list'][$index]['member_social_icon_2_link']) ? $settings['team-list'][$index]['member_social_icon_2_link']['url'] : '#';
																					$social_icon_3_link = !empty($settings['team-list'][$index]['member_social_icon_3_link']) ? $settings['team-list'][$index]['member_social_icon_3_link']['url'] : '#';
																					$social_icon_4_link = !empty($settings['team-list'][$index]['member_social_icon_4_link']) ? $settings['team-list'][$index]['member_social_icon_4_link']['url'] : '#';
																					$social_icon_5_link = !empty($settings['team-list'][$index]['member_social_icon_5_link']) ? $settings['team-list'][$index]['member_social_icon_5_link']['url'] : '#';

																					$animationClass = '';
																					if ($settings['social_icons_hover_animation']) {
																						$animationClass .= 'elementor-animation-' . $settings['social_icons_hover_animation'];
																					}
																					?>
																					<div class="mwt-team-social-icons">
																						<?php if (!empty($settings['team-list'][$index]['member_social_icon_1']['value'])) { ?>
																							<a class="mwt-team-social-icon-1 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_1_link); ?>">
																								<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_1'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																							</a>
																						<?php } ?>
																						<?php if (!empty($settings['team-list'][$index]['member_social_icon_2']['value'])) { ?>
																							<a class="mwt-team-social-icon-2 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_2_link); ?>">
																								<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_2'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																							</a>
																						<?php } ?>
																						<?php if (!empty($settings['team-list'][$index]['member_social_icon_3']['value'])) { ?>
																							<a class="mwt-team-social-icon-3 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_3_link); ?>">
																								<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_3'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																							</a>
																						<?php } ?>
																						<?php if (!empty($settings['team-list'][$index]['member_social_icon_4']['value'])) { ?>
																							<a class="mwt-team-social-icon-4 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_4_link); ?>">
																								<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_4'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																							</a>
																						<?php } ?>
																						<?php if (!empty($settings['team-list'][$index]['member_social_icon_5']['value'])) { ?>
																							<a class="mwt-team-social-icon-5 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_5_link); ?>">
																								<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_5'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																							</a>
																						<?php } ?>
																					</div>
																				</div>
																				<?php
																				$name = $settings['team-list'][$index]['item_name'];
																				$position = $settings['team-list'][$index]['item_position'];
																				?>
																				<div class="mwt-team-content-wrap">
																					<?php
																					if (!empty($name_link)) { ?>
																						<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-name">
																							<?php echo $name; ?>
																						</a>
																					<?php } else { ?>
																						<div class="mwt-team-name">
																							<?php echo $name; ?>
																						</div>
																					<?php } ?>
																					<?php if (!empty($position)) { ?>
																						<div class="mwt-team-position">
																							<?php echo $position; ?>
																						</div>
																					<?php } ?>
																				</div>
																				<?php
																				//grid layout
																				if ($settings['team_layout'] === 'grid') : ?>
																				</div>
																			<?php endif; ?>
																			</div>
																			<?php
																			break;

																		case 'style5':
																			//carousel layout
																			if ($settings['team_layout'] === 'carousel') : ?>
																				<div class="owl-carousel-item style5">
																				<?php endif;
																			//end carousel layout 

																			//grid layout
																			if ($settings['team_layout'] === 'grid') : ?>
																					<div class="grid-item style5">
																					<?php endif;
																				//end grid layout  
																					?>
																					<div class="mwt-team-image-wrap">
																						<?php
																						$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
																						if (!$image_url && isset($item['image']['url'])) {
																							$image_url = $item['image']['url'];
																						}
																						if (!empty($item['item_name'])) {
																							$image_alt = $item['item_name'];
																						} else {
																							$image_alt = 'This is a title';
																						}
																						$image_html = '<img class="mwt-team-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
																						echo wp_kses_post($image_html);
																						?>
																						<?php
																						$name_link = $settings['team-list'][$index]['item_name_link']['url'];
																						if (!empty($name_link)) { ?>
																							<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-media-link"></a>
																						<?php } ?>
																					</div>
																					<?php
																					$name = $settings['team-list'][$index]['item_name'];
																					$position = $settings['team-list'][$index]['item_position'];
																					$description = $settings['team-list'][$index]['item_description'];
																					?>
																					<div class="mwt-team-content-wrap">
																						<?php if (!empty($position)) { ?>
																							<div class="mwt-team-position">
																								<?php echo $position; ?>
																							</div>
																						<?php } ?>
																						<?php
																						if (!empty($name_link)) { ?>
																							<a href="<?php echo esc_attr($name_link) ?>" class="mwt-team-name">
																								<?php echo $name; ?>
																							</a>
																						<?php } else { ?>
																							<div class="mwt-team-name">
																								<?php echo $name; ?>
																							</div>
																						<?php } ?>
																						<?php if (!empty($description)) { ?>
																							<div class="mwt-team-description">
																								<?php echo $description; ?>
																							</div>
																						<?php } ?>
																						<?php
																						$social_icon_1_link = !empty($settings['team-list'][$index]['member_social_icon_1_link']) ? $settings['team-list'][$index]['member_social_icon_1_link']['url'] : '#';
																						$social_icon_2_link = !empty($settings['team-list'][$index]['member_social_icon_2_link']) ? $settings['team-list'][$index]['member_social_icon_2_link']['url'] : '#';
																						$social_icon_3_link = !empty($settings['team-list'][$index]['member_social_icon_3_link']) ? $settings['team-list'][$index]['member_social_icon_3_link']['url'] : '#';
																						$social_icon_4_link = !empty($settings['team-list'][$index]['member_social_icon_4_link']) ? $settings['team-list'][$index]['member_social_icon_4_link']['url'] : '#';
																						$social_icon_5_link = !empty($settings['team-list'][$index]['member_social_icon_5_link']) ? $settings['team-list'][$index]['member_social_icon_5_link']['url'] : '#';

																						$animationClass = '';
																						if ($settings['social_icons_hover_animation']) {
																							$animationClass .= 'elementor-animation-' . $settings['social_icons_hover_animation'];
																						}
																						?>
																						<div class="mwt-team-social-icons">
																							<?php if (!empty($settings['team-list'][$index]['member_social_icon_1']['value'])) { ?>
																								<a class="mwt-team-social-icon-1 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_1_link); ?>">
																									<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_1'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																								</a>
																							<?php } ?>
																							<?php if (!empty($settings['team-list'][$index]['member_social_icon_2']['value'])) { ?>
																								<a class="mwt-team-social-icon-2 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_2_link); ?>">
																									<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_2'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																								</a>
																							<?php } ?>
																							<?php if (!empty($settings['team-list'][$index]['member_social_icon_3']['value'])) { ?>
																								<a class="mwt-team-social-icon-3 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_3_link); ?>">
																									<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_3'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																								</a>
																							<?php } ?>
																							<?php if (!empty($settings['team-list'][$index]['member_social_icon_4']['value'])) { ?>
																								<a class="mwt-team-social-icon-4 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_4_link); ?>">
																									<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_4'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																								</a>
																							<?php } ?>
																							<?php if (!empty($settings['team-list'][$index]['member_social_icon_5']['value'])) { ?>
																								<a class="mwt-team-social-icon-5 <?php echo esc_attr($animationClass); ?>" href="<?php echo esc_url($social_icon_5_link); ?>">
																									<?php \Elementor\Icons_Manager::render_icon($settings['team-list'][$index]['member_social_icon_5'], ['aria-hidden' => 'true', 'class' => 'mwt-team-social-icon']) ?>
																								</a>
																							<?php } ?>
																						</div>
																					</div>
																					</div>
																			<?php break;
																	} ?>
																		<?php } ?>
																				</div>
																				<?php
																				//carousel layout 
																				if ($settings['team_layout'] === 'carousel') : ?>
																					<div class="owl-nav position-<?php echo esc_attr($settings['prev_next_icons_position']); ?> mwt-team-carousel-nav-<?php echo esc_attr($unique_id); ?>">
																						<?php
																						$date_nav_prev = isset($settings['date_nav_prev']) ? $settings['date_nav_prev'] : '';
																						$date_nav_next = isset($settings['date_nav_next']) ? $settings['date_nav_next'] : '';
																						$date_nav_prev_word = isset($settings['date_nav_prev_word']) ? $settings['date_nav_prev_word'] : '';
																						$date_nav_next_word = isset($settings['date_nav_next_word']) ? $settings['date_nav_next_word'] : '';
																						?>
																						<span class="mwt-team-carousel-prev-<?php echo esc_attr($unique_id); ?>">
																							<?php if ($date_nav_prev) :
																								\Elementor\Icons_Manager::render_icon($settings['date_nav_prev'], ['aria-hidden' => 'true', 'class' => 'icon-prev']);
																							endif; ?>
																							<span><?php echo esc_html($date_nav_prev_word); ?></span>
																						</span>
																						<span class="mwt-team-carousel-next-<?php echo esc_attr($unique_id); ?>">
																							<span><?php echo esc_html($date_nav_next_word); ?></span>
																							<?php
																							if ($date_nav_next) :
																								\Elementor\Icons_Manager::render_icon($settings['date_nav_next'], ['aria-hidden' => 'true', 'class' => 'icon-next']);
																							endif;
																							?>
																						</span>
																					</div>
																				<?php endif; //end carousel layout  
																				?>
																		</div>
																		<?php
																		//grid layout 
																		if ($settings['team_layout'] === 'grid') : ?>
																</div>
														</div>
											<?php endif; //end grid layout 
																	}
																}
