<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor MWT Main Slider Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Elementor_MWT_Main_Slider extends \Elementor\Widget_Base

{

    /**
     * Retrieve Widget Dependent JS.
     *
     * @since 1.0.0
     * @access public
     * @return array JS script handles.
     */
    public function get_script_depends()
    {
        return ['mwt-main-slider-script'];
    }

    /**
     * Retrieve Widget Dependent CSS.
     *
     * @since 1.0.0
     * @access public
     * @return array CSS style handles.
     */
    public function get_style_depends()
    {
        return ['mwt-main-slider-style'];
    }

    /**
     * Get widget name.
     *
     * Retrieve list widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'mwt-main-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve list widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('MWT Main Slider', 'mwt-addons-for-elementor');
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the list widget belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['mwt'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve image carousel widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @since 2.1.0
     * @access public
     *
     * @return array Widget keywords.
     */
    public function get_keywords()
    {
        return ['mwt', 'image', 'photo', 'main', 'visual', 'carousel', 'slider'];
    }

    /**
     * Register list widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Slider', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        /* Start repeater */

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'media_type',
            [
                'label' => esc_html__('Select', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'mwt-addons-for-elementor'),
                    'video' => esc_html__('Video', 'mwt-addons-for-elementor'),
                ],
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Background Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'media_type' => 'image',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'video',
            [
                'label' => esc_html__('Choose Video', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'media_types' => ['video'],
                'condition' => [
                    'media_type' => 'video',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'add_background_text',
            [
                'label'     => __('Add Background Text', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'background_text',
            [
                'label' => esc_html__('Background Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your background text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'add_background_text' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'background_text_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_background_text' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'background_text_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_background_text' => 'yes',
                    'background_text_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'add_image_layer_middle',
            [
                'label'     => __('Add Image Layer', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'condition' => [
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_middle',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'main_slider_middle_thumbnail',
                'separator' => 'none',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_middle_position',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'layer_middle_center' => esc_html__('Center', 'mwt-addons-for-elementor'),
                    'layer_middle_top'    => esc_html__('Center Top', 'mwt-addons-for-elementor'),
                    'layer_middle_bottom' => esc_html__('Center Bottom', 'mwt-addons-for-elementor'),
                    'layer_right_center' => esc_html__('Right Center', 'mwt-addons-for-elementor'),
                    'layer_left_center'    => esc_html__('Left Center', 'mwt-addons-for-elementor'),
                    'layer_custom_position' => esc_html__('Custom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'layer_middle_center',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_middle_size',
            [
                'label' => esc_html__('Display Size', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'contain' => esc_html__('Contain', 'mwt-addons-for-elementor'),
                    'cover'  => esc_html__('Cover', 'mwt-addons-for-elementor'),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_middle_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_middle_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'image_layer_middle_hide_on_tablet!' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'hr_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'add_image_layer_upper',
            [
                'label'     => __('Add Image Layer', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'add_background_text!' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'main_slider_upper_thumbnail',
                'separator' => 'none',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_upper_position',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'layer_middle_center' => esc_html__('Center', 'mwt-addons-for-elementor'),
                    'layer_middle_top'    => esc_html__('Center Top', 'mwt-addons-for-elementor'),
                    'layer_middle_bottom' => esc_html__('Center Bottom', 'mwt-addons-for-elementor'),
                    'layer_right_center' => esc_html__('Right Center', 'mwt-addons-for-elementor'),
                    'layer_left_center'    => esc_html__('Left Center', 'mwt-addons-for-elementor'),
                    'layer_custom_position' => esc_html__('Custom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'layer_middle_center',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_upper_size',
            [
                'label' => esc_html__('Display Size', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'contain' => esc_html__('Contain', 'mwt-addons-for-elementor'),
                    'cover'  => esc_html__('Cover', 'mwt-addons-for-elementor'),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'image_layer_upper_hide_on_tablet!' => 'yes',
                    'add_background_text!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'hr_2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_overlay',
            [
                'label' => esc_html__('Overlay', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'none'              => esc_html__('None', 'mwt-addons-for-elementor'),
                    'overlay-1'  => esc_html__('Overlay 1', 'mwt-addons-for-elementor'),
                    'overlay-2'  => esc_html__('Overlay 2', 'mwt-addons-for-elementor'),
                    'overlay-3'  => esc_html__('Overlay 3', 'mwt-addons-for-elementor'),
                ],
                'default' => 'none',
            ]
        );

        $repeater->add_control(
            'slide_layer_1',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_1_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
            ]
        );

        $repeater->add_control(
            'hr_3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_2',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_2_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h1',
            ]
        );

        $repeater->add_control(
            'hr_4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_3',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_3_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );

        $repeater->add_control(
            'hr_5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_4',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_4_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_5',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_5_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_7',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_6',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_6_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_8',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_7',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_7_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_9',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_button',
            [
                'label' => esc_html__('Button Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_link',
            [
                'label'       => __('Button Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'slide_text_between_buttons',
            [
                'label' => esc_html__('Text Between Buttons', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_2',
            [
                'label' => esc_html__('Button 2 Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_2_link',
            [
                'label'       => __('Button 2 Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        /* End repeater */

        $this->add_control(
            'main_slider',
            [
                'label' => esc_html__('Slider Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slide_layer_1' => esc_html__('Slide #1', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'slide_layer_1' => esc_html__('Slide #2', 'mwt-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ slide_layer_1 }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings',
            [
                'label' => __('Slider Settings', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'main_slider_thumbnail',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'data_slideshow',
            [
                'label' => esc_html__('Autoplay', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_speed',
            [
                'label' => esc_html__('Speed (ms)', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5000,
                'frontend_available' => true,
                'condition' => [
                    'data_slideshow' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'data_animationloop',
            [
                'label' => esc_html__('Loop', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_animation',
            [
                'label' => esc_html__('Animation Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'fade',
                'options' => [
                    'fade'  => esc_html__('Fade', 'mwt-addons-for-elementor'),
                    'slide' => esc_html__('Slide', 'mwt-addons-for-elementor'),
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_pauseonhover',
            [
                'label' => esc_html__('Pause on Hover', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'navigation_options',
            [
                'label' => esc_html__('Navigation', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'data_nav',
            [
                'label'   => __('Prev/Next', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'date_nav_prev',
            [
                'label'            => __('Previous Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-chevron-left',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'chevron-left',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'data_nav' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'date_nav_prev_word',
            [
                'label'     => __('Previous word', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Prev', 'mwt-addons-for-elementor'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition'   => [
                    'data_nav' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'date_nav_next',
            [
                'label'            => __('Next Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'chevron-right',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'data_nav' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'date_nav_next_word',
            [
                'label'     => __('Next word', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Next', 'mwt-addons-for-elementor'),
                'dynamic' => [
                    'active' => true,
                ],
                'condition'   => [
                    'data_nav' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'data_dots',
            [
                'label'   => __('Dots', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'scroll_button_section',
            [
                'label' => __('Scroll Button', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'scroll_button_show',
            [
                'label'   => __('Show Scroll Button', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'scroll_button_icon',
            [
                'label'            => __('Scroll Button Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-mouse',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'mouse',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'scroll_button_show' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'scroll_button_text',
            [
                'label' => esc_html__('Scroll Button Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'scroll_button_show' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'scroll_button_link',
            [
                'label'       => __('Scroll Button Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => '#example',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'scroll_button_show' => 'yes'
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'animation_section',
            [
                'label' => __('Entrance Animation', 'mwt-addons-for-elementor'),
            ]
        );

        $entrance_animation = [
            ''             => esc_html__('None', 'mwt-addons-for-elementor'),
            'bounce'       => esc_html__('bounce', 'mwt-addons-for-elementor'),
            'flash'        => esc_html__('flash', 'mwt-addons-for-elementor'),
            'pulse'        => esc_html__('pulse', 'mwt-addons-for-elementor'),
            'rubberBand'   => esc_html__('rubberBand', 'mwt-addons-for-elementor'),
            'shake'        => esc_html__('shake', 'mwt-addons-for-elementor'),
            'headShake'    => esc_html__('headShake', 'mwt-addons-for-elementor'),
            'swing'        => esc_html__('swing', 'mwt-addons-for-elementor'),
            'tada'         => esc_html__('tada', 'mwt-addons-for-elementor'),
            'wobble'       => esc_html__('wobble', 'mwt-addons-for-elementor'),
            'jello'        => esc_html__('jello', 'mwt-addons-for-elementor'),
            'heartBeat'    => esc_html__('heartBeat', 'mwt-addons-for-elementor'),
            'bounceIn'     => esc_html__('bounceIn', 'mwt-addons-for-elementor'),
            'fadeIn'       => esc_html__('fadeIn', 'mwt-addons-for-elementor'),
            'fadeInDown'   => esc_html__('fadeInDown', 'mwt-addons-for-elementor'),
            'fadeInLeft'   => esc_html__('fadeInLeft', 'mwt-addons-for-elementor'),
            'fadeInRight'  => esc_html__('fadeInRight', 'mwt-addons-for-elementor'),
            'fadeInUp'     => esc_html__('fadeInUp', 'mwt-addons-for-elementor'),
            'flip'         => esc_html__('flip', 'mwt-addons-for-elementor'),
            'flipInX'      => esc_html__('flipInX', 'mwt-addons-for-elementor'),
            'flipInY'      => esc_html__('flipInY', 'mwt-addons-for-elementor'),
            'lightSpeedIn' => esc_html__('lightSpeedIn', 'mwt-addons-for-elementor'),
            'jackInTheBox' => esc_html__('jackInTheBox', 'mwt-addons-for-elementor'),
            'zoomIn'       => esc_html__('zoomIn', 'mwt-addons-for-elementor'),
        ];

        $animation_duration = [
            'slower'   => esc_html__('Slower', 'mwt-addons-for-elementor'),
            'slow'   => esc_html__('Slow', 'mwt-addons-for-elementor'),
            ''   => esc_html__('Normal', 'mwt-addons-for-elementor'),
            'fast'   => esc_html__('Fast', 'mwt-addons-for-elementor'),
            'faster'   => esc_html__('Faster', 'mwt-addons-for-elementor'),
        ];

        $this->add_control(
            'slide_layer_1_image_animation',
            [
                'label' => esc_html__('Image Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_1_image_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_image_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_1_image_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_image_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation',
            [
                'label' => esc_html__('Image Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_image_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_image_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_1_animation',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_1_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_1_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_2_animation',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_2_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_2_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_3_animation',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_3_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_3_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_3_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_3_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_4_animation',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_4_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_4_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_4_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_4_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_5_animation',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_5_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_5_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_5_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_5_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_6_animation',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_6_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_6_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_6_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_6_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_7_animation',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_7_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_7_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_7_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_7_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_button_animation',
            [
                'label' => esc_html__('Buttons', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_button_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_button_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_button_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_button_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_slider_section',
            [
                'label' => esc_html__('Slider', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slider_content_width',
            [
                'label' => esc_html__('Content Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'boxed',
                'options' => [
                    'boxed' => esc_html__('Boxed', 'mwt-addons-for-elementor'),
                    'full_width' => esc_html__('Full Width', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 1600,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1170,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .container' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slider_content_width' => ['boxed'],
                ],
            ]
        );

        $this->add_responsive_control(
            'content_height',
            [
                'label' => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1000,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slides > li' => 'min-height: {{SIZE}}{{UNIT}}; max-height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slides > li img' => 'max-height: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'show_corner_border',
            [
                'label' => esc_html__('Show Corner Border', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'corner_border_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'show_corner_border' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'corner_border_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'show_corner_border' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'show_bg_animation',
            [
                'label' => esc_html__('Show Background Animation', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'bg_animation_width',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'unit' => 'px',
                    'size' => 730,
                ],
                'range' => [
                    'px' => [
                        'min' => 320,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .with_bg_animation' => 'width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'show_bg_animation' => 'yes',
                ]
            ]
        );

        $this->add_responsive_control(
            'bg_animation_height',
            [
                'label' => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'unit' => 'px',
                    'size' => 730,
                ],
                'range' => [
                    'px' => [
                        'min' => 320,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .with_bg_animation' => 'height: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'show_bg_animation' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'animation_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .with_bg_animation',
                'condition' => [
                    'show_bg_animation' => 'yes',
                ]
            ]
        );

        $this->add_responsive_control(
            'bg_animation_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .with_bg_animation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_bg_animation' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'show_animated_line',
            [
                'label' => esc_html__('Show Animated Line', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'no',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'animated_line_options',
            [
                'label' => esc_html__('Line', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'animated_line_background',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .lines-wrap-item',
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'animated_line_dots_up_options',
            [
                'label' => esc_html__('Dots Up', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'animated_line_dots_up_background',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .lines-wrap-item .animated-line:after',
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'animated_line_dots_down_options',
            [
                'label' => esc_html__('Dots Down', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'animated_line_dots_down_background',
                'types' => ['gradient'],
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .lines-wrap-item .animated-line:before',
                'condition' => [
                    'show_animated_line' => 'yes',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_slide_section',
            [
                'label' => esc_html__('Slide', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slide_description_custom_width',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'initial' => esc_html__('Custom', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_description_custom_width_initial',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    'px' => [
                        'min' => 320,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slide_description' => 'max-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_description_custom_width' => 'initial',
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_description_align',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slide_description_wrapper' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'slide_description_custom_width' => 'initial',
                ],
            ]
        );

        $this->add_control(
            'image_layer_middle_options',
            [
                'label' => esc_html__('Image layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_layer_middle_opacity',
            [
                'label' => esc_html__('Opacity', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-middle-wrap' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'image_layer_middle_custom_position',
            [
                'label' => esc_html__('Custom Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'description' => esc_html__('Works only when \'Position\' layout set to \'Custom\'', 'mwt-addons-for-elementor'),
                'options' => [
                    'custom_left_top'    => esc_html__('Left Top', 'mwt-addons-for-elementor'),
                    'custom_left_bottom' => esc_html__('Left Bottom', 'mwt-addons-for-elementor'),
                    'custom_right_top'    => esc_html__('Right Top', 'mwt-addons-for-elementor'),
                    'custom_right_bottom' => esc_html__('Right Bottom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'custom_left_top',
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_middle_custom_position_left_top',
            [
                'label'      => esc_html__('Left Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-middle.custom-position' => 'object-position: left {{SIZE}}{{UNIT}} top 0px;',
                ],
                'condition' => [
                    'image_layer_middle_custom_position' => 'custom_left_top',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_middle_custom_position_left_bottom',
            [
                'label'      => esc_html__('Left Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-middle.custom-position' => 'object-position: left {{SIZE}}{{UNIT}} bottom 0px;',
                ],
                'condition' => [
                    'image_layer_middle_custom_position' => 'custom_left_bottom',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_middle_custom_position_right_top',
            [
                'label'      => esc_html__('Right Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-middle.custom-position' => 'object-position: right {{SIZE}}{{UNIT}} top 0px;',
                ],
                'condition' => [
                    'image_layer_middle_custom_position' => 'custom_right_top',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_middle_custom_position_right_bottom',
            [
                'label'      => esc_html__('Right Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-middle.custom-position' => 'object-position: right {{SIZE}}{{UNIT}} bottom 0px;',
                ],
                'condition' => [
                    'image_layer_middle_custom_position' => 'custom_right_bottom',
                ],
            ]
        );

        $this->add_control(
            'image_layer_upper_options',
            [
                'label' => esc_html__('Image layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_layer_upper_opacity',
            [
                'label' => esc_html__('Opacity', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'default' => [
                    'size' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-upper-wrap' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'image_layer_upper_custom_position',
            [
                'label' => esc_html__('Custom Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'description' => esc_html__('Works only when \'Position\' layout set to \'Custom\'', 'mwt-addons-for-elementor'),
                'options' => [
                    'custom_left_top'    => esc_html__('Left Top', 'mwt-addons-for-elementor'),
                    'custom_left_bottom' => esc_html__('Left Bottom', 'mwt-addons-for-elementor'),
                    'custom_right_top'    => esc_html__('Right Top', 'mwt-addons-for-elementor'),
                    'custom_right_bottom' => esc_html__('Right Bottom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'custom_left_top',
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_upper_custom_position_left_top',
            [
                'label'      => esc_html__('Left Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-upper.custom-position' => 'object-position: left {{SIZE}}{{UNIT}} top 0px;',
                ],
                'condition' => [
                    'image_layer_upper_custom_position' => 'custom_left_top',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_upper_custom_position_left_bottom',
            [
                'label'      => esc_html__('Left Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-upper.custom-position' => 'object-position: left {{SIZE}}{{UNIT}} bottom 0px;',
                ],
                'condition' => [
                    'image_layer_upper_custom_position' => 'custom_left_bottom',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_upper_custom_position_right_top',
            [
                'label'      => esc_html__('Right Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-upper.custom-position' => 'object-position: right {{SIZE}}{{UNIT}} top 0px;',
                ],
                'condition' => [
                    'image_layer_upper_custom_position' => 'custom_right_top',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_image_layer_upper_custom_position_right_bottom',
            [
                'label'      => esc_html__('Right Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                    'em' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'vw' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-image-upper.custom-position' => 'object-position: right {{SIZE}}{{UNIT}} bottom 0px;',
                ],
                'condition' => [
                    'image_layer_upper_custom_position' => 'custom_right_bottom',
                ],
            ]
        );


        $this->add_control(
            'background_text',
            [
                'label' => esc_html__('Background Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'background_text_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slide-title-full p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'background_text_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-container .slide-title-full p',
            ]
        );

        $this->add_control(
            'background_text_bg',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slide-title-full' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_1',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_1_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_1_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-1',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_1_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_1_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_2',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_2_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_2_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-2',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_2_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_2_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_3',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_3_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_3_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-3',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_3_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_3_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_4',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_4_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_4_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-4',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_4_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_4_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_5',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_5_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_5_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-5',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_5_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_5_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_6',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_6_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_6_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-6',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_6_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_6_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_7',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_7_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_7_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-7',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_7_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_7_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button',
            [
                'label' => esc_html__('Button', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_button_layout',
            [
                'label' => esc_html__('Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'type-button',
                'options' => [
                    'type-button' => esc_html__('Button', 'mwt-addons-for-elementor'),
                    'type-simple-link' => esc_html__('Simple Link', 'mwt-addons-for-elementor'),
                    'type-button-with-icon' => esc_html__('Button With Icon', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'slide_button_icon',
            [
                'label'            => __('Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'angle-right',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'slide_button_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_icon_position',
            [
                'label' => esc_html__('Icon Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'row',
                'options' => [
                    'row' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'row-reverse' => esc_html__('Reverse', 'mwt-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button.type-button-with-icon' => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_button_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-button',
            ]
        );

        $this->start_controls_tabs(
            'slide_button_style_tabs'
        );

        $this->start_controls_tab(
            'slide_button_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'slide_button_icon_gap',
            [
                'label' => esc_html__('Icon Spacing', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button.type-button-with-icon' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-button svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_control(
            'slide_button_line_background_color',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'type-simple-link'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slide_button_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'slide_button_hover_icon_gap',
            [
                'label' => esc_html__('Icon Spacing', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button.type-button-with-icon:hover' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_background_color_hover',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_control(
            'slide_button_line_background_color_hover',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'type-simple-link'
                ]
            ]
        );

        $this->add_control(
            'slide_button_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_hover_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'slide_button_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-button',
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_control(
            'slide_button_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_min_width',
            [
                'label'      => __('Min Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button'  => 'min-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_button_layout' => ['type-button', 'type-button-with-icon'],
                ]
            ]
        );

        $this->add_control(
            'text_between_options',
            [
                'label' => esc_html__('Text Between Buttons', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_text_between_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-text-between',
            ]
        );

        $this->add_control(
            'slide_text_between_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-text-between' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2',
            [
                'label' => esc_html__('Button 2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_button_2_layout',
            [
                'label' => esc_html__('Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'type-button',
                'options' => [
                    'type-button' => esc_html__('Button', 'mwt-addons-for-elementor'),
                    'type-simple-link' => esc_html__('Simple Link', 'mwt-addons-for-elementor'),
                    'type-button-with-icon' => esc_html__('Button With Icon', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_icon',
            [
                'label'            => __('Icon', 'mwt-addons-for-elementor'),
                'type'             => \Elementor\Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
                'recommended'      => [
                    'fa-solid'   => [
                        'angle-right',
                    ],
                ],
                'skin'             => 'inline',
                'label_block'      => false,
                'condition' => [
                    'slide_button_2_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_icon_position',
            [
                'label' => esc_html__('Icon Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'row',
                'options' => [
                    'row' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'row-reverse' => esc_html__('Reverse', 'mwt-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button-2.type-button-with-icon' => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_button_2_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-button-2',
            ]
        );

        $this->start_controls_tabs(
            'slide_button_2_style_tabs'
        );

        $this->start_controls_tab(
            'slide_button_2_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'slide_button_2_icon_gap',
            [
                'label' => esc_html__('Icon Spacing', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button-2.type-button-with-icon' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2 svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_line_background_color',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-simple-link'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slide_button_2_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'slide_button_2_hover_icon_gap',
            [
                'label' => esc_html__('Icon Spacing', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-button-2.type-button-with-icon:hover' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button-with-icon',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_background_color_hover',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_line_background_color_hover',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-simple-link'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'slide_button_2_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-button-2',
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_2_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_button_2_min_width',
            [
                'label'      => __('Min Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2'  => 'min-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'type-button'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_buttons_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-buttons-wrap' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_buttons_gap',
            [
                'label' => esc_html__('Button Spacing', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-buttons-wrap' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_buttons_margin',
            [
                'label'      => __('Buttons Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-buttons-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_buttons_transition',
            [
                'label'      => __('Buttons Transition Duration', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'default' => [
                    'size' => 0.3,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-buttons-wrap a'  => 'transition: all {{SIZE}}s',
                    '{{WRAPPER}} .mwt-elementor-main-slider-buttons-wrap a svg'  => 'transition: all {{SIZE}}s',

                ],
            ]
        );

        $this->add_control(
            'slider_overlay',
            [
                'label' => esc_html__('Overlay', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'overlay_1_color',
            [
                'label' => esc_html__('Overlay 1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-1::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'overlay_2_color',
            [
                'label' => esc_html__('Overlay 2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-2::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'overlay_3_color',
            [
                'label' => esc_html__('Overlay 3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-3::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_mask',
            [
                'label' => esc_html__('Mask', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'mwt-addons-for-elementor'),
                    'slider-mask-1' => esc_html__('Layout 1', 'mwt-addons-for-elementor'),
                    'slider-mask-2' => esc_html__('Layout 2', 'mwt-addons-for-elementor'),
                    'slider-mask-3' => esc_html__('Layout 3', 'mwt-addons-for-elementor'),
                ],
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_scroll_section',
            [
                'label' => esc_html__('Scroll Button', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'scroll_button_show' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'scroll_button_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a',
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_size',
            [
                'label'      => __('Icon Size', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 8,
                        'max' => 60,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a i'  => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a svg'  => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_spacing',
            [
                'label'      => __('Icon Spacing', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 4,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'scroll_button_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'scroll_button_color_hover',
            [
                'label' => esc_html__('Color Hover', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button a:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_position',
            [
                'label'      => esc_html__('Position Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-button'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_prev_next_section',
            [
                'label' => esc_html__('Prev/Next', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'data_nav' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'prev_next_layout',
            [
                'label' => esc_html__('Layout', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('Middle', 'mwt-addons-for-elementor'),
                    'bottom' => esc_html__('Bottom', 'mwt-addons-for-elementor'),
                    'bottom-left'  => esc_html__('Bottom Left', 'mwt-addons-for-elementor'),
                    'bottom-right' => esc_html__('Bottom Right', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'prev_next_separator',
            [
                'label' => esc_html__('Separator', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'separator' => 'before',
                'default' => '',
                'placeholder' => esc_html__('Type your separator here', 'mwt-addons-for-elementor'),
                'condition' => [
                    'prev_next_layout' => ['bottom-left', 'bottom-right'],
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'prev_next_separator_typography',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-nav-separator',
            ]
        );

        $this->add_control(
            'prev_next_separator_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'separator' => 'after',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .mwt-elementor-main-slider-nav-separator' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'prev_next_typography',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a',
            ]
        );

        $this->add_responsive_control(
            'prev_next_icons_size',
            [
                'label'      => __('Icon Size', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 8,
                        'max' => 60,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a i'  => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a svg'  => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_icon_position',
            [
                'label' => esc_html__('Icon Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'row',
                'options' => [
                    'row' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'row-reverse' => esc_html__('Reverse', 'mwt-addons-for-elementor'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'prev_next_icon_spacing',
            [
                'label'      => __('Icon Spacing', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 12,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'prev_next_style_tabs'
        );

        $this->start_controls_tab(
            'prev_next_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'prev_next_color',
            [
                'label' => esc_html__('Text Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_icon_color',
            [
                'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_bg_color',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'prev_next_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'prev_next_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a:hover i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a:hover svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'prev_next_style_disabled_tab',
            [
                'label' => esc_html__('Disabled', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'prev_next_color_disabled',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_icon_color_disabled',
            [
                'label' => esc_html__('Icon Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_bg_color_disabled',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'prev_next_border_color_disabled',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-disabled' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'prev_next_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a',
            ]
        );

        $this->add_control(
            'prev_next_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'prev_next_padding',
            [
                'label'      => esc_html__('Pdding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'prev_next_margin',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'placeholder' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'prev_next_arrows_offset',
            [
                'label'      => esc_html__('Offset X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-prev'  => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-next'  => 'right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prev_next_layout!' => ['bottom-left', 'bottom-right'],
                ]
            ]
        );

        $this->add_responsive_control(
            'prev_next_arrows_offset_x_bottom_lr',
            [
                'label'      => esc_html__('Offset X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav.bottom-left'  => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav.bottom-right'  => 'right: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prev_next_layout' => ['bottom-left', 'bottom-right'],
                ]
            ]
        );

        $this->add_responsive_control(
            'prev_next_arrows_offset_y',
            [
                'label'      => esc_html__('Offset Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-prev'  => 'bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav a.flex-next'  => 'bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prev_next_layout' => 'bottom',
                ]
            ]
        );

        $this->add_responsive_control(
            'prev_next_arrows_offset_y_bottom_lr',
            [
                'label'      => esc_html__('Offset Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav.bottom-left'  => 'bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-direction-nav.bottom-right'  => 'bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'prev_next_layout' => ['bottom-left', 'bottom-right'],
                ]
            ]
        );

        $this->add_control(
            'prev_next_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'prev_next_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'prev_next_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_dots_section',
            [
                'label' => esc_html__('Dots', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'data_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_style',
            [
                'label' => esc_html__('Dots Style', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'dots-default',
                'options' => [
                    'dots-default' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'dots-with-numbering' => esc_html__('Dots with numbering of slides', 'mwt-addons-for-elementor'),
                    'dots-with-numbering-alt' => esc_html__('Dots with numbering of slides 2', 'mwt-addons-for-elementor'),
                    'dots-with-numbering-alt-2' => esc_html__('Dots with numbering of slides 3', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_position',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'dots-position-bottom-center',
                'options' => [
                    'dots-position-bottom-center' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'dots-position-left-center' => esc_html__('Left Center', 'mwt-addons-for-elementor'),
                    'dots-position-right-center' => esc_html__('Right Center', 'mwt-addons-for-elementor'),
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_size',
            [
                'label'      => esc_html__('Size', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a'  => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-default',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'navigation_dots_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a',
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt', 'dots-with-numbering-alt-2'],
                ]
            ]
        );

        $this->start_controls_tabs(
            'style_navigation_dots_tabs'
        );

        $this->start_controls_tab(
            'style_navigation_dots_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_width',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_height',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_width_before',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a::before'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_height_before',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a::before'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_before',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_navigation_dots_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_width_hover',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a:hover'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_height_hover',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a:hover'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_hover_width_before',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a:hover::before'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_hover_height_before',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a:hover::before'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_before_hover',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a:hover::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_navigation_dots_active_tab',
            [
                'label' => esc_html__('Active', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_width_active',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a.flex-active'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_height_active',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a.flex-active'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => ['dots-with-numbering', 'dots-with-numbering-alt'],
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_width_active_before',
            [
                'label'      => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a.flex-active::before'  => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_active_height_before',
            [
                'label'      => esc_html__('Height', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a.flex-active::before'  => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_color_active',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a.flex-active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_active',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a.flex-active' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_active_before',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a.flex-active::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_control(
            'navigation_dots_border_color_active',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a.flex-active' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'navigation_dots_gap',
            [
                'label'      => esc_html__('Gap', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-paging li a'  => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'dots_style' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'navigation_dots_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a',
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
                'condition' => [
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_margin',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_position_y',
            [
                'label'      => esc_html__('Position Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 60,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'navigation_dots_position' => 'dots-position-bottom-center',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_position_y_lr',
            [
                'label'      => esc_html__('Position Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'navigation_dots_position!' => 'dots-position-bottom-center',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_position_x',
            [
                'label'      => esc_html__('Position X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -1000,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav'  => 'left: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'navigation_dots_position' => 'dots-position-bottom-center',
                    'dots_style!' => 'dots-with-numbering-alt-2',
                ]
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_position_x_left',
            [
                'label'      => esc_html__('Position X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav'  => 'left: {{SIZE}}{{UNIT}}',
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'navigation_dots_position',
                            'operator' => '===',
                            'value' => 'dots-position-left-center',
                        ],
                        [
                            'name' => 'dots_style',
                            'operator' => '===',
                            'value' => 'dots-with-numbering-alt-2',
                        ],
                    ],
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_position_x_right',
            [
                'label'      => esc_html__('Position X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flex-control-nav'  => 'right: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'navigation_dots_position' => 'dots-position-right-center',
                ]
            ]
        );

        $this->add_control(
            'navigation_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'navigation_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'navigation_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render list widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $unique_id = uniqid();

        if (empty($settings['main_slider'])) {
            return;
        }
?>
        <div class="mwt-elementor-main-slider-container">
            <?php
            $dots_style = (isset($settings['dots_style'])) ? $settings['dots_style'] : 'dots-default';
            $dots_position = (isset($settings['navigation_dots_position'])) ? $settings['navigation_dots_position'] : '';
            //hide
            $nav_hide_on_tablet = ('yes' === ($settings['navigation_hide_on_tablet'])) ? 'nav-hide-tablet' : '';
            $nav_hide_on_mobile = ('yes' === ($settings['navigation_hide_on_mobile'])) ? 'nav-hide-mobile' : '';

            $slider_mask = (isset($settings['slider_mask'])) ? $settings['slider_mask'] : '';
            $slideshow = ('yes' === ($settings['data_slideshow'])) ? 'true' : 'false';
            $loop = ('yes' === ($settings['data_animationloop'])) ? 'true' : 'false';
            $pauseonhover = ('yes' === ($settings['data_pauseonhover'])) ? 'true' : 'false';

            //animation duration  
            $slide_layer_1_image_animation_duration = (!empty($settings['slide_layer_1_image_animation_duration'])) ? $settings['slide_layer_1_image_animation_duration'] : '';
            $slide_layer_2_image_animation_duration = (!empty($settings['slide_layer_2_image_animation_duration'])) ? $settings['slide_layer_2_image_animation_duration'] : '';
            $slide_layer_1_animation_duration = (!empty($settings['slide_layer_1_animation_duration'])) ? $settings['slide_layer_1_animation_duration'] : '';
            $slide_layer_2_animation_duration = (!empty($settings['slide_layer_2_animation_duration'])) ? $settings['slide_layer_2_animation_duration'] : '';
            $slide_layer_3_animation_duration = (!empty($settings['slide_layer_3_animation_duration'])) ? $settings['slide_layer_3_animation_duration'] : '';
            $slide_layer_4_animation_duration = (!empty($settings['slide_layer_4_animation_duration'])) ? $settings['slide_layer_4_animation_duration'] : '';
            $slide_layer_5_animation_duration = (!empty($settings['slide_layer_5_animation_duration'])) ? $settings['slide_layer_5_animation_duration'] : '';
            $slide_layer_6_animation_duration = (!empty($settings['slide_layer_6_animation_duration'])) ? $settings['slide_layer_6_animation_duration'] : '';
            $slide_layer_7_animation_duration = (!empty($settings['slide_layer_7_animation_duration'])) ? $settings['slide_layer_7_animation_duration'] : '';
            $slide_button_animation_duration = (!empty($settings['slide_button_animation_duration'])) ? $settings['slide_button_animation_duration'] : '';
            $corner_border_animation_duration = (!empty($settings['corner_border_animation_duration'])) ? $settings['corner_border_animation_duration'] : '';

            //animation delay  
            $layer1imagedelay = (!empty($settings['slide_layer_1_image_animation_delay'])) ? $settings['slide_layer_1_image_animation_delay'] : '';
            $layer2imagedelay = (!empty($settings['slide_layer_2_image_animation_delay'])) ? $settings['slide_layer_2_image_animation_delay'] : '';
            $layer1delay = (!empty($settings['slide_layer_1_animation_delay'])) ? $settings['slide_layer_1_animation_delay'] : '';
            $layer2delay = (!empty($settings['slide_layer_2_animation_delay'])) ? $settings['slide_layer_2_animation_delay'] : '';
            $layer3delay = (!empty($settings['slide_layer_3_animation_delay'])) ? $settings['slide_layer_3_animation_delay'] : '';
            $layer4delay = (!empty($settings['slide_layer_4_animation_delay'])) ? $settings['slide_layer_4_animation_delay'] : '';
            $layer5delay = (!empty($settings['slide_layer_5_animation_delay'])) ? $settings['slide_layer_5_animation_delay'] : '';
            $layer6delay = (!empty($settings['slide_layer_6_animation_delay'])) ? $settings['slide_layer_6_animation_delay'] : '';
            $layer7delay = (!empty($settings['slide_layer_7_animation_delay'])) ? $settings['slide_layer_7_animation_delay'] : '';
            $buttondelay = (!empty($settings['slide_button_animation_delay'])) ? $settings['slide_button_animation_delay'] : '';
            $cornerdelay = (!empty($settings['corner_border_animation_delay'])) ? $settings['corner_border_animation_delay'] : '';
            ?>
            <div class="flexslider main-slider <?php echo esc_attr($dots_style . ' ' . $dots_position . ' ' . $nav_hide_on_tablet . ' ' . $nav_hide_on_mobile . ' ' . $slider_mask); ?>" data-number="<?php echo esc_attr($unique_id); ?>" data-slideshow="<?php echo esc_attr($slideshow) ?>" data-slideshowspeed="<?php echo esc_attr($settings['data_speed']) ?>" data-animationloop="<?php echo esc_attr($loop) ?>" data-animation="<?php echo esc_attr($settings['data_animation']) ?>" data-pauseonhover="<?php echo esc_attr($pauseonhover) ?>" data-nav="<?php echo esc_attr($settings['data_nav']) ?>" data-dots="<?php echo esc_attr($settings['data_dots']) ?>" data-layer1animation="<?php echo esc_attr($settings['slide_layer_1_animation']) ?>" data-layer2animation="<?php echo esc_attr($settings['slide_layer_2_animation']) ?>" data-layer3animation="<?php echo esc_attr($settings['slide_layer_3_animation']) ?>" data-layer4animation="<?php echo esc_attr($settings['slide_layer_4_animation']) ?>" data-layer5animation="<?php echo esc_attr($settings['slide_layer_5_animation']) ?>" data-layer6animation="<?php echo esc_attr($settings['slide_layer_6_animation']) ?>" data-layer7animation="<?php echo esc_attr($settings['slide_layer_7_animation']) ?>" data-buttonanimation="<?php echo esc_attr($settings['slide_button_animation']) ?>" data-layer1imageanimation="<?php echo esc_attr($settings['slide_layer_1_image_animation']) ?>" data-layer2imageanimation="<?php echo esc_attr($settings['slide_layer_2_image_animation']) ?>" data-layer1imagedelay="<?php echo esc_attr($layer1imagedelay) ?>" data-layer2imagedelay="<?php echo esc_attr($layer2imagedelay) ?>" data-layer1delay="<?php echo esc_attr($layer1delay) ?>" data-layer2delay="<?php echo esc_attr($layer2delay) ?>" data-layer3delay="<?php echo esc_attr($layer3delay) ?>" data-layer4delay="<?php echo esc_attr($layer4delay) ?>" data-layer5delay="<?php echo esc_attr($layer5delay) ?>" data-layer6delay="<?php echo esc_attr($layer6delay) ?>" data-layer7delay="<?php echo esc_attr($layer7delay) ?>" data-buttondelay="<?php echo esc_attr($buttondelay) ?>" data-cornerdelay="<?php echo esc_attr($cornerdelay) ?>">
                <ul class="slides">
                    <?php
                    foreach ($settings['main_slider'] as $index => $item) {
                        $overlay = ('none' !== $item['slide_overlay']) ? $item['slide_overlay'] : '';
                    ?>
                        <li class="<?php echo esc_attr($overlay) ?>">
                            <?php if ('yes' === $settings['show_animated_line']) : ?>
                                <div class="lines-wrap-item">
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                    <span class="animated-line"></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($item['background_text'])) {
                                $bg_text_hide_on_tablet = ('yes' === ($item['background_text_hide_on_tablet'])) ? 'bg-text-hide-tablet' : '';
                                $bg_text_hide_on_mobile = ('yes' === ($item['background_text_hide_on_mobile'])) ? 'bg-text-hide-mobile' : '';
                            ?>
                                <div class="slide-title-full <?php echo esc_attr($bg_text_hide_on_tablet . ' ' . $bg_text_hide_on_mobile) ?>">
                                    <p><?php echo wp_kses_post($item['background_text']) ?></p>
                                </div>
                            <?php } ?>
                            <?php
                            $media_type = $item['media_type'];
                            //image
                            if ($media_type === 'image') {
                                $image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'main_slider_thumbnail', $settings);
                                if (!$image_url && isset($item['image']['url'])) {
                                    $image_url = $item['image']['url'];
                                }
                                $image_html = '<img class="mwt-elementor-main-slider-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image'])) . '" />';
                                echo wp_kses_post($image_html);
                            }
                            //video
                            if ($media_type === 'video') {
                                $video_url = '';
                                if (isset($item['video']['url'])) {
                                    $video_url = $item['video']['url'];
                                }
                            ?>
                                <video class="elementor-video mwt-elementor-main-slider-video" autoplay loop muted style="width:100%; height:100%;">
                                    <source src="<?php echo esc_url($video_url); ?>" type="video/mp4" />
                                    <p class="vjs-no-js"><?php esc_html_e('Please enable JavaScript', 'mwt-addons-for-elementor') ?></p>
                                </video>
                            <?php
                            }
                            $middle_hide_on_tablet = ('yes' === ($item['image_layer_middle_hide_on_tablet'])) ? 'middle-hide-tablet' : '';
                            $middle_hide_on_mobile = ('yes' === ($item['image_layer_middle_hide_on_mobile'])) ? 'middle-hide-mobile' : '';
                            $upper_hide_on_tablet = ('yes' === ($item['image_layer_upper_hide_on_tablet'])) ? 'upper-hide-tablet' : '';
                            $upper_hide_on_mobile = ('yes' === ($item['image_layer_upper_hide_on_mobile'])) ? 'upper-hide-mobile' : '';
                            $slide_image_layer_middle_position = (!empty($item['slide_image_layer_middle_position'])) ? $item['slide_image_layer_middle_position'] : 'layer_middle_center';
                            $slide_image_layer_middle_size = (!empty($item['slide_image_layer_middle_size'])) ? 'object-fit-' . $item['slide_image_layer_middle_size'] : '';
                            $slide_image_layer_upper_position = (!empty($item['slide_image_layer_upper_position'])) ? $item['slide_image_layer_upper_position'] : 'layer_middle_center';
                            $slide_image_layer_upper_size = (!empty($item['slide_image_layer_upper_size'])) ? 'object-fit-' . $item['slide_image_layer_upper_size'] : '';

                            //image_layer_middle
                            if ('yes' === $item['add_image_layer_middle'] && isset($item['image_layer_middle']['url'])) {
                                $image_middle_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image_layer_middle']['id'], 'main_slider_middle_thumbnail', $item);
                                $custom_position_layer_middle = ('layer_custom_position' === $item['slide_image_layer_middle_position']) ? 'custom-position' : '';
                                if (!$image_middle_url && isset($item['image_layer_middle']['url'])) {
                                    $image_middle_url = $item['image_layer_middle']['url'];
                                }
                                $image_middle_html = '<img class="mwt-elementor-main-slider-image-middle mwt-elementor-main-slider-image-animation ' . esc_attr($custom_position_layer_middle . ' ' . $slide_image_layer_middle_size . ' ' . $slide_image_layer_middle_position . ' ' . $slide_layer_1_image_animation_duration . ' ' . $middle_hide_on_tablet . ' ' . $middle_hide_on_mobile) . '" src="' . esc_attr($image_middle_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image_layer_middle'])) . '" />'; ?>
                                <div class="mwt-elementor-main-slider-image-middle-wrap">
                                    <?php echo wp_kses_post($image_middle_html); ?>
                                </div>
                            <?php
                            }
                            //image_layer_upper
                            if ('yes' === $item['add_image_layer_upper'] && isset($item['image_layer_upper']['url'])) {
                                $image_upper_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image_layer_upper']['id'], 'main_slider_upper_thumbnail', $item);
                                $custom_position_layer_upper = ('layer_custom_position' === $item['slide_image_layer_upper_position']) ? 'custom-position' : '';
                                if (!$image_upper_url && isset($item['image_layer_upper']['url'])) {
                                    $image_upper_url = $item['image_layer_upper']['url'];
                                }
                                $image_upper_html = '<img class="mwt-elementor-main-slider-image-upper mwt-elementor-main-slider-image-animation ' . esc_attr($custom_position_layer_upper . ' ' . $slide_image_layer_upper_size . ' ' . $slide_image_layer_upper_position . ' ' . $slide_layer_2_image_animation_duration  . ' ' . $upper_hide_on_tablet . ' ' . $upper_hide_on_mobile) . '" src="' . esc_attr($image_upper_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image_layer_upper'])) . '" />'; ?>
                                <div class="mwt-elementor-main-slider-image-upper-wrap">
                                    <?php echo wp_kses_post($image_upper_html); ?>
                                <?php
                            }
                            $full_width = ('full_width' === $settings['slider_content_width']) ? '-fluid' : '';
                            $show_bg_animation = ('yes' === $settings['show_bg_animation']) ? 'with_bg_animation' : '';
                                ?>
                                <div class="container<?php echo esc_attr($full_width); ?> slider-content intro_layers">
                                    <div class="slide_description_wrapper">
                                        <div class="slide_description">
                                            <div class="slide_layers <?php echo esc_attr($show_bg_animation); ?>">
                                                <?php if ($settings['show_corner_border'] === 'yes') : ?>
                                                    <div class="mwt-elementor-main-slider-top-corners-left <?php echo esc_attr($corner_border_animation_duration) ?>"></div>
                                                    <div class="mwt-elementor-main-slider-top-corners-right <?php echo esc_attr($corner_border_animation_duration) ?>"></div>
                                                <?php endif; ?>
                                                <?php
                                                //layer #1
                                                if ($item['slide_layer_1']) {
                                                    $layer_1 = $item['slide_layer_1'];
                                                    $layer_1_tag = $item['slide_layer_1_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_1_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-1 ' . esc_attr($slide_layer_1_animation_duration) . '">' . wp_kses_post($layer_1) . '</' . \Elementor\Utils::validate_html_tag($layer_1_tag) . '>';
                                                }
                                                //layer #2
                                                if ($item['slide_layer_2']) {
                                                    $layer_2 = $item['slide_layer_2'];
                                                    $layer_2_tag = $item['slide_layer_2_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_2_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-2 ' . esc_attr($slide_layer_2_animation_duration) . '">' . wp_kses_post($layer_2) . '</' . \Elementor\Utils::validate_html_tag($layer_2_tag) . '>';
                                                }
                                                //layer #3
                                                if ($item['slide_layer_3']) {
                                                    $layer_3 = $item['slide_layer_3'];
                                                    $layer_3_tag = $item['slide_layer_3_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_3_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-3 ' . esc_attr($slide_layer_3_animation_duration) . '">' . wp_kses_post($layer_3) . '</' . \Elementor\Utils::validate_html_tag($layer_3_tag) . '>';
                                                }
                                                //layer #4
                                                if ($item['slide_layer_4']) {
                                                    $layer_4 = $item['slide_layer_4'];
                                                    $layer_4_tag = $item['slide_layer_4_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_4_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-4 ' . esc_attr($slide_layer_4_animation_duration) . '">' . wp_kses_post($layer_4) . '</' . \Elementor\Utils::validate_html_tag($layer_4_tag) . '>';
                                                }

                                                //layer #5
                                                if ($item['slide_layer_5']) {
                                                    $layer_5 = $item['slide_layer_5'];
                                                    $layer_5_tag = $item['slide_layer_5_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_5_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-5 ' . esc_attr($slide_layer_5_animation_duration) . '">' . wp_kses_post($layer_5) . '</' . \Elementor\Utils::validate_html_tag($layer_5_tag) . '>';
                                                }

                                                //layer #6
                                                if ($item['slide_layer_6']) {
                                                    $layer_6 = $item['slide_layer_6'];
                                                    $layer_6_tag = $item['slide_layer_6_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_6_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-6 ' . esc_attr($slide_layer_6_animation_duration) . '">' . wp_kses_post($layer_6) . '</' . \Elementor\Utils::validate_html_tag($layer_6_tag) . '>';
                                                }

                                                //layer #7
                                                if ($item['slide_layer_7']) {
                                                    $layer_7 = $item['slide_layer_7'];
                                                    $layer_7_tag = $item['slide_layer_7_tag'];
                                                    echo '<' . \Elementor\Utils::validate_html_tag($layer_7_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-7 ' . esc_attr($slide_layer_7_animation_duration) . '">' . wp_kses_post($layer_7) . '</' . \Elementor\Utils::validate_html_tag($layer_7_tag) . '>';
                                                }
                                                //button
                                                if ($item['slide_button'] || $item['slide_button_2']) {
                                                    echo '<div class="mwt-elementor-main-slider-buttons-wrap ' . esc_attr($slide_button_animation_duration) . '">';
                                                    if ($item['slide_button']) { ?>
                                                        <a class="mwt-elementor-main-slider-button <?php echo esc_attr($settings['slide_button_layout']); ?>" href="<?php echo esc_url($item['slide_button_link']['url']); ?>">
                                                            <?php echo esc_html($item['slide_button']);
                                                            if ($settings['slide_button_layout'] === 'type-button-with-icon') :
                                                                \Elementor\Icons_Manager::render_icon($settings['slide_button_icon'], ['aria-hidden' => 'true', 'class' => 'button-icon']);
                                                            endif; ?>
                                                        </a>
                                                    <?php
                                                    }
                                                    if ($item['slide_text_between_buttons']) {
                                                        echo '<span class="mwt-elementor-main-slider-text-between">' . esc_html($item['slide_text_between_buttons']) . '</span>';
                                                    }
                                                    if ($item['slide_button_2']) { ?>
                                                        <a class="mwt-elementor-main-slider-button-2 <?php echo esc_attr($settings['slide_button_2_layout']); ?>" href="<?php echo esc_url($item['slide_button_2_link']['url']); ?>">
                                                            <?php echo esc_html($item['slide_button_2']);
                                                            if ($settings['slide_button_2_layout'] === 'type-button-with-icon') :
                                                                \Elementor\Icons_Manager::render_icon($settings['slide_button_2_icon'], ['aria-hidden' => 'true', 'class' => 'button-icon']);
                                                            endif; ?>
                                                        </a>
                                                <?php                                             }
                                                    echo '</div>';
                                                } ?>
                                                <?php if ($settings['show_corner_border'] === 'yes') : ?>
                                                    <div class="mwt-elementor-main-slider-bottom-corners-left <?php echo esc_attr($corner_border_animation_duration) ?>"></div>
                                                    <div class="mwt-elementor-main-slider-bottom-corners-right <?php echo esc_attr($corner_border_animation_duration) ?>"></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                        </li>
                    <?php } ?>
                </ul>
            </div>
            <?php
            $nav_arrows_hide_on_tablet = ('yes' === ($settings['prev_next_hide_on_tablet'])) ? 'nav-arrows-hide-tablet' : '';
            $nav_arrows_hide_on_mobile = ('yes' === ($settings['prev_next_hide_on_mobile'])) ? 'nav-arrows-hide-mobile' : '';
            ?>
            <div class="flex-direction-nav <?php echo esc_attr($settings['prev_next_layout']) ?> flex-direction-nav-<?php echo esc_attr($unique_id); ?> <?php echo esc_attr($nav_arrows_hide_on_tablet . ' ' . $nav_arrows_hide_on_mobile) ?>">
                <?php
                $date_nav_prev = isset($settings['date_nav_prev']) ? $settings['date_nav_prev'] : '';
                $date_nav_next = isset($settings['date_nav_next']) ? $settings['date_nav_next'] : '';
                $date_nav_prev_word = isset($settings['date_nav_prev_word']) ? $settings['date_nav_prev_word'] : '';
                $date_nav_next_word = isset($settings['date_nav_next_word']) ? $settings['date_nav_next_word'] : '';
                ?>
                <a class="flex-prev" href="#">
                    <?php if ($date_nav_prev) :
                        \Elementor\Icons_Manager::render_icon($settings['date_nav_prev'], ['aria-hidden' => 'true', 'class' => 'icon-prev']);
                    endif;
                    echo esc_html($date_nav_prev_word)
                    ?>
                </a>
                <?php
                if (!empty($settings['prev_next_separator'])) {
                    echo '<span class="mwt-elementor-main-slider-nav-separator">' . esc_html($settings['prev_next_separator']) . '</span>';
                }
                ?>
                <a class="flex-next" href="#">
                    <?php
                    echo esc_html($date_nav_next_word);
                    if ($date_nav_next) :
                        \Elementor\Icons_Manager::render_icon($settings['date_nav_next'], ['aria-hidden' => 'true', 'class' => 'icon-next']);
                    endif;
                    ?>
                </a>
            </div>
            <?php
            if ('yes' === $settings['scroll_button_show']) {
                $scroll_button_icon = isset($settings['scroll_button_icon']) ? $settings['scroll_button_icon'] : '';
                $scroll_button_text = isset($settings['scroll_button_text']) ? $settings['scroll_button_text'] : '';
            ?>
                <div class="mwt-elementor-main-slider-scroll-button">
                    <a href="<?php echo esc_url($settings['scroll_button_link']['url']); ?>">
                        <?php if ($scroll_button_icon) :
                            \Elementor\Icons_Manager::render_icon($settings['scroll_button_icon'], ['aria-hidden' => 'true', 'class' => 'icon-scroll']);
                        endif;
                        echo esc_html($scroll_button_text)
                        ?>
                    </a>
                </div>
            <?php
            }
            ?>
        </div>
<?php }
}
