<?php

if (!function_exists('mwt_get_post_likes')) :
    /**
     * Get likes value
     *
     * @param int $postID ID of the post.
     */
    function mwt_get_post_likes($postID)
    {
        $current_theme = wp_get_theme()->get_template();
        $count_key = sprintf($current_theme . '_post_likes_count');
        $count = get_post_meta($postID, $count_key, true);
        if ($count == '') {
            delete_post_meta($postID, $count_key);
            add_post_meta($postID, $count_key, '0');

            return '0';
        }

        return $count;
    } //mwt_get_post_likes()
endif;

if (!function_exists('mwt_get_post_views')) :
    /**
     * Get counter value
     *
     * @param int $postID ID of the post.
     */
    function mwt_get_post_views($post_id)
    {
        $current_theme = wp_get_theme()->get_template();
        $count_key = sprintf($current_theme . '_post_views_count');
        $count     = get_post_meta($post_id, $count_key, true);
        if ($count == '') {
            delete_post_meta($post_id, $count_key);
            add_post_meta($post_id, $count_key, '0');

            return "0";
        }

        return number_format($count, 0, ".", ",");
    } //mwt_action_track_post_views()
endif;
